/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.ObraAcompanhamentoImagem;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.MedicaoObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PlanilhaObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ObraRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindObraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ObraRepositoryImpl
implements ObraRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObraRepositoryImpl.class);
    private static final String OBRAS = "db/sql/aise/obras.sql";
    private static final String OBRAS_COUNT = "db/sql/aise/obras_count.sql";
    private static final String OBRA = "db/sql/aise/obra.sql";
    private static final String MEDICOES = "db/sql/aise/medicoes.sql";
    private static final String PLANILHAS = "db/sql/aise/planilhas.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/aise/ultimaAtualizacaoObra.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public ObraRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<ObraDTO> findObras(FindObraParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)OBRAS));
        StringBuilder sqlCount = new StringBuilder(FileUtils.readResourceAsString((String)OBRAS_COUNT));
        String sqlComplementar = this.getSqlComplementar(params);
        sqlCount.append(sqlComplementar);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.append(sqlComplementar).toString(), (String)"ORDER BY A.DATAINICIO DESC");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List obras = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ObraDTO.class));
        ObraDTO.setFieldsDisplay((List)obras);
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(obras, pageable, total.longValue());
    }

    protected String getSqlComplementar(FindObraParams params) {
        StringBuilder sqlComplementar = new StringBuilder();
        this.addWhereDescricaoBem(params, sqlComplementar);
        this.addWhereDescricaoObra(params, sqlComplementar);
        this.addWhereSituacao(params, sqlComplementar);
        this.addWhereEmpresa(params, sqlComplementar);
        return sqlComplementar.toString();
    }

    private void addWhereDescricaoObra(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDescricaoObra().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)"A.DESCRICAO", (String)((String)params.getDescricaoObra().get()))));
    }

    private void addWhereSituacao(FindObraParams params, StringBuilder sqlComplementar) {
        params.getSituacao().ifPresent(item -> sqlComplementar.append(" AND A.IDTIPOACOMPANHAMENTO = :situacao "));
    }

    private void addWhereDescricaoBem(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDescricaoBem().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)"A.BEMPROPRIO", (String)((String)params.getDescricaoBem().get()))));
    }

    private void addWhereEmpresa(FindObraParams params, StringBuilder sqlComplementar) {
        params.getEmpresa().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)"P.NOME", (String)((String)params.getEmpresa().get()))));
    }

    public ObraDTO findObra(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)OBRA));
        this.consoleLogger(params, query);
        return (ObraDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObraDTO.class));
    }

    public List<MedicaoObraDTO> findMedicoes(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)MEDICOES));
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(MedicaoObraDTO.class));
    }

    public List<PlanilhaObraDTO> findPlanilhas(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PLANILHAS));
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PlanilhaObraDTO.class));
    }

    public List<ObraAcompanhamentoImagem> findImagensMedicao(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder();
        query.append(" select *  from OBRAACOMPANHAMENTOIMAGEM ");
        query.append(" where entidade = :entidade ");
        query.append(" and exercicio = :exercicioMedicao ");
        query.append(" and idOrdemServico = :idOrdemServico ");
        query.append(" and acompanhamento = :sequencia ");
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObraAcompanhamentoImagem.class));
    }

    private void consoleLogger(FindObraParams params, StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
        }
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao() {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }
}

