SELECT
    tc.Descricao as DescricaoTipoCadastro,
    cg.Codigo as CadastroGeral,
    cg.Loteamento as Setor,
    cg.Quadra,
    cg.Lote,
    g.Descricao as DescricaoDivida,
    sp.descricao as situacaoLegal,
    case    
     when p.estornado is not null and p.estornado = 'N' then 'Protestado'
     else 'Sem Protesto'
     end as condicao,
     case when (coalesce( g.GUIATRIBUTARIA, 'N' ) = 'S') then 'Tributária' else 'Não Tributária' end as guiaTributaria,
    sum(vp.valor) as Valor
FROM CadastroGeral cg 
    JOIN CGCM c
       ON c.codigo = cg.CodigoCGCM
    JOIN tipocadastro tc
       ON tc.Codigo = cg.Tipo
    JOIN valoresparcelas vp 
        ON vp.TipoCadastro = cg.Tipo
        AND vp.CodigoImovel = cg.Codigo
    JOIN guiasrecolhimento g
        ON vp.CodigoDivida = g.Codigo
    LEFT OUTER JOIN situacaoparcela sp 
        ON sp.situacaoparcela = vp.situacao
    LEFT OUTER JOIN protestoparcela pp
        ON pp.idvaloresparcelas = vp.IDVALORESPARCELAS
    LEFT OUTER JOIN protesto p
        ON p.idprotesto = pp.idprotesto
WHERE c.nome = :nome
	AND c.CGCCPF = :cnpjCpfDB
	AND vp.Situacao in (1,2)
$[FILTRO]
GROUP BY tc.Descricao, cg.Codigo, cg.Loteamento, cg.Quadra, cg.Lote, g.Descricao, sp.descricao, p.estornado,
         g.guiaTributaria
ORDER BY tc.Descricao, cg.Codigo, cg.Loteamento, cg.Quadra, cg.Lote
