SELECT P.DATAPROCESSO AS DATA,
       P.TIPO,
       P.NUMERO AS PROCESSO,
       P.ANO AS EXERCICIO,
       P.ENTIDADE,
       P.DIGITACAO,
       P.USUARIOREG AS USUARIO,
       A.DESCRICAO AS ASSUNTO,
       S.DESCRICAO AS SITUACAO,
       G.DESCRICAO AS GRAUSIGILO
  FROM TRAMITACAO T
  LEFT OUTER JOIN PROCESSOS P 
    ON T.ENTIDADE = P.ENTIDADE 
   AND T.TIPO = P.TIPO
   AND T.NUMERO = P.NUMERO
   AND T.ANO = P.ANO
  LEFT OUTER JOIN ASSUNTO A 
    ON P.CODASSUNTO = A.CODIGO
  LEFT OUTER JOIN SITUACOES S 
    ON T.SITUACAO = S.CODIGO
  LEFT OUTER JOIN GRAUSIGILO G
    ON G.ID = P.GRAUSIGILO
 WHERE P.ENTIDADE = :entidade
   AND P.TIPO = :tipo
   AND P.ANO = :exercicio
   AND T.SEQUENCIA = (SELECT MAX(X.SEQUENCIA) 
                        FROM TRAMITACAO X
                       WHERE X.TIPO = T.TIPO
                         AND X.ANO = T.ANO
                         AND X.NUMERO = T.NUMERO
                         AND X.ENTIDADE = T.ENTIDADE)