/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class EmpenhoParams {
    private Long entidade;
    private Long exercicio;
    private Long empenhoInicial;
    private Long empenhoFinal;
    private Long empenho;
    private String unidadeOrcamentaria;
    private Boolean aPagar;
    private Boolean passagens;
    private Boolean comprasDireta;
    private Boolean dispensaInexigibilidade;
    private String tipoNivelDespesa;
    private String nivelLei;
    private String codigoNivelDespesa;
    private String search;
    private String exportType;
    private String tipoBem;
    private String chapaBem;
    private ProgramaticaParams programatica;
    private String cnpjCpf;
    private Long ordemItemEmpenho;
    private Long mesInicialMov;
    private Long mesFinalMov;
    private Long mesInicialEmissao;
    private Long mesFinalEmissao;
    private Long fonteRecurso;
    private String esfera;
    private Long noLiquidacao;
    private String isCovid;
    private Boolean consumo;
    private Boolean permanente;

    public String montaFiltro() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.entidade)) {
            where.append("\n WHERE E.ENTIDADE = :entidade");
        }
        if (Objects.nonNull(this.exercicio)) {
            where.append("\n AND E.EXERCICIO = :exercicio");
        }
        if (Objects.nonNull(this.empenho)) {
            where.append("\n AND E.EMPENHO = :empenho");
        }
        if (Objects.nonNull(this.empenhoInicial)) {
            where.append("\n AND E.EMPENHO >= :empenhoInicial");
        }
        if (Objects.nonNull(this.empenhoFinal)) {
            where.append("\n AND E.EMPENHO <= :empenhoFinal");
        }
        if (Objects.nonNull(this.ordemItemEmpenho)) {
            where.append("\n AND A.ORDEM = :ordem");
        }
        where.append("\n AND E.CONTABILIZADO = 'S'");
        if (Objects.nonNull(this.programatica)) {
            this.createProgramaticaFilters(where);
        }
        return where.toString();
    }

    private void createProgramaticaFilters(StringBuilder where) {
        this.filtroOrgao(where);
        this.filtroUnidade(where);
        this.filtroFuncao(where);
        this.filtroSubFuncao(where);
        this.filtroPrograma(where);
        this.filtroProjeto(where);
        this.filtroElemento(where);
        this.filtroDesdobramento(where);
        this.fitlerSubDesdobramento(where);
    }

    private void filtroOrgao(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getOrgao())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) = :orgao");
        }
    }

    private void filtroUnidade(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getUnidade())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO) = :unidade");
        }
    }

    private void filtroFuncao(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getFuncao())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) = :funcao");
        }
    }

    private void filtroSubFuncao(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getSubFuncao())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) = :subFuncao");
        }
    }

    private void filtroPrograma(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getPrograma())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) = :programa");
        }
    }

    private void filtroProjeto(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getProjeto())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) = :projeto");
        }
    }

    private void filtroElemento(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getElemento())) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO-4) LIKE :elemento");
        }
    }

    private void filtroDesdobramento(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getDesdobramento())) {
            where.append("\n AND E.DESDOBRADESP = :desdobramento");
        }
    }

    private void fitlerSubDesdobramento(StringBuilder where) {
        if (Objects.nonNull(this.programatica.getSubDesdobramento())) {
            where.append("\n AND E.SUBDESDOBRAMENTO = :subDesdobramento");
        }
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.empenho)) {
            params.addValue("empenho", (Object)this.empenho, 2);
        }
        if (Objects.nonNull(this.empenhoInicial)) {
            params.addValue("empenhoInicial", (Object)this.empenhoInicial, 2);
        }
        if (Objects.nonNull(this.empenhoFinal)) {
            params.addValue("empenhoFinal", (Object)this.empenhoFinal, 2);
        }
        if (Objects.nonNull(this.programatica)) {
            this.createProgramaticaParams(params);
        }
        if (Objects.nonNull(this.ordemItemEmpenho)) {
            params.addValue("ordem", (Object)this.ordemItemEmpenho, 2);
        }
        if (Objects.nonNull(this.noLiquidacao)) {
            params.addValue("noLiquidacao", (Object)this.noLiquidacao, 2);
        }
        return params;
    }

    private void createProgramaticaParams(MapSqlParameterSource params) {
        this.addOrgaoUnidade(params);
        this.addFuncaoSubFuncao(params);
        this.addPrograma(params);
        this.addProjeto(params);
        this.addElemento(params);
        this.addDesdobramentoSubDesdobramento(params);
    }

    private void addOrgaoUnidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getOrgao())) {
            params.addValue("orgao", (Object)this.programatica.getOrgao(), 12);
        }
        if (Objects.nonNull(this.programatica.getUnidade())) {
            params.addValue("unidade", (Object)this.programatica.getUnidade(), 12);
        }
    }

    private void addFuncaoSubFuncao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getFuncao())) {
            params.addValue("funcao", (Object)this.programatica.getFuncao(), 12);
        }
        if (Objects.nonNull(this.programatica.getSubFuncao())) {
            params.addValue("subFuncao", (Object)this.programatica.getSubFuncao(), 12);
        }
    }

    private void addPrograma(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getPrograma())) {
            params.addValue("programa", (Object)this.programatica.getPrograma(), 12);
        }
    }

    private void addProjeto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getProjeto())) {
            params.addValue("projeto", (Object)this.programatica.getProjeto(), 12);
        }
    }

    private void addElemento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getElemento())) {
            params.addValue("elemento", (Object)this.programatica.getElemento(), 12);
        }
    }

    private void addDesdobramentoSubDesdobramento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programatica.getDesdobramento())) {
            params.addValue("desdobramento", (Object)this.programatica.getDesdobramento(), 12);
        }
        if (Objects.nonNull(this.programatica.getSubDesdobramento())) {
            params.addValue("subDesdobramento", (Object)this.programatica.getSubDesdobramento(), 12);
        }
    }

    public Long getEntidadeDefault(Long padrao) {
        if (Objects.isNull(this.entidade)) {
            return padrao;
        }
        return this.entidade;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getEmpenhoInicial() {
        return this.empenhoInicial;
    }

    @Generated
    public Long getEmpenhoFinal() {
        return this.empenhoFinal;
    }

    @Generated
    public Long getEmpenho() {
        return this.empenho;
    }

    @Generated
    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    @Generated
    public Boolean getAPagar() {
        return this.aPagar;
    }

    @Generated
    public Boolean getPassagens() {
        return this.passagens;
    }

    @Generated
    public Boolean getComprasDireta() {
        return this.comprasDireta;
    }

    @Generated
    public Boolean getDispensaInexigibilidade() {
        return this.dispensaInexigibilidade;
    }

    @Generated
    public String getTipoNivelDespesa() {
        return this.tipoNivelDespesa;
    }

    @Generated
    public String getNivelLei() {
        return this.nivelLei;
    }

    @Generated
    public String getCodigoNivelDespesa() {
        return this.codigoNivelDespesa;
    }

    @Generated
    public String getSearch() {
        return this.search;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public String getTipoBem() {
        return this.tipoBem;
    }

    @Generated
    public String getChapaBem() {
        return this.chapaBem;
    }

    @Generated
    public ProgramaticaParams getProgramatica() {
        return this.programatica;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public Long getOrdemItemEmpenho() {
        return this.ordemItemEmpenho;
    }

    @Generated
    public Long getMesInicialMov() {
        return this.mesInicialMov;
    }

    @Generated
    public Long getMesFinalMov() {
        return this.mesFinalMov;
    }

    @Generated
    public Long getMesInicialEmissao() {
        return this.mesInicialEmissao;
    }

    @Generated
    public Long getMesFinalEmissao() {
        return this.mesFinalEmissao;
    }

    @Generated
    public Long getFonteRecurso() {
        return this.fonteRecurso;
    }

    @Generated
    public String getEsfera() {
        return this.esfera;
    }

    @Generated
    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    @Generated
    public String getIsCovid() {
        return this.isCovid;
    }

    @Generated
    public Boolean getConsumo() {
        return this.consumo;
    }

    @Generated
    public Boolean getPermanente() {
        return this.permanente;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setEmpenhoInicial(Long empenhoInicial) {
        this.empenhoInicial = empenhoInicial;
    }

    @Generated
    public void setEmpenhoFinal(Long empenhoFinal) {
        this.empenhoFinal = empenhoFinal;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    @Generated
    public void setAPagar(Boolean aPagar) {
        this.aPagar = aPagar;
    }

    @Generated
    public void setPassagens(Boolean passagens) {
        this.passagens = passagens;
    }

    @Generated
    public void setComprasDireta(Boolean comprasDireta) {
        this.comprasDireta = comprasDireta;
    }

    @Generated
    public void setDispensaInexigibilidade(Boolean dispensaInexigibilidade) {
        this.dispensaInexigibilidade = dispensaInexigibilidade;
    }

    @Generated
    public void setTipoNivelDespesa(String tipoNivelDespesa) {
        this.tipoNivelDespesa = tipoNivelDespesa;
    }

    @Generated
    public void setNivelLei(String nivelLei) {
        this.nivelLei = nivelLei;
    }

    @Generated
    public void setCodigoNivelDespesa(String codigoNivelDespesa) {
        this.codigoNivelDespesa = codigoNivelDespesa;
    }

    @Generated
    public void setSearch(String search) {
        this.search = search;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setTipoBem(String tipoBem) {
        this.tipoBem = tipoBem;
    }

    @Generated
    public void setChapaBem(String chapaBem) {
        this.chapaBem = chapaBem;
    }

    @Generated
    public void setProgramatica(ProgramaticaParams programatica) {
        this.programatica = programatica;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setOrdemItemEmpenho(Long ordemItemEmpenho) {
        this.ordemItemEmpenho = ordemItemEmpenho;
    }

    @Generated
    public void setMesInicialMov(Long mesInicialMov) {
        this.mesInicialMov = mesInicialMov;
    }

    @Generated
    public void setMesFinalMov(Long mesFinalMov) {
        this.mesFinalMov = mesFinalMov;
    }

    @Generated
    public void setMesInicialEmissao(Long mesInicialEmissao) {
        this.mesInicialEmissao = mesInicialEmissao;
    }

    @Generated
    public void setMesFinalEmissao(Long mesFinalEmissao) {
        this.mesFinalEmissao = mesFinalEmissao;
    }

    @Generated
    public void setFonteRecurso(Long fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setEsfera(String esfera) {
        this.esfera = esfera;
    }

    @Generated
    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setConsumo(Boolean consumo) {
        this.consumo = consumo;
    }

    @Generated
    public void setPermanente(Boolean permanente) {
        this.permanente = permanente;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmpenhoParams)) {
            return false;
        }
        EmpenhoParams other = (EmpenhoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$empenhoInicial = this.getEmpenhoInicial();
        Long other$empenhoInicial = other.getEmpenhoInicial();
        if (this$empenhoInicial == null ? other$empenhoInicial != null : !((Object)this$empenhoInicial).equals(other$empenhoInicial)) {
            return false;
        }
        Long this$empenhoFinal = this.getEmpenhoFinal();
        Long other$empenhoFinal = other.getEmpenhoFinal();
        if (this$empenhoFinal == null ? other$empenhoFinal != null : !((Object)this$empenhoFinal).equals(other$empenhoFinal)) {
            return false;
        }
        Long this$empenho = this.getEmpenho();
        Long other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        String this$unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        String other$unidadeOrcamentaria = other.getUnidadeOrcamentaria();
        if (this$unidadeOrcamentaria == null ? other$unidadeOrcamentaria != null : !this$unidadeOrcamentaria.equals(other$unidadeOrcamentaria)) {
            return false;
        }
        Boolean this$aPagar = this.getAPagar();
        Boolean other$aPagar = other.getAPagar();
        if (this$aPagar == null ? other$aPagar != null : !((Object)this$aPagar).equals(other$aPagar)) {
            return false;
        }
        Boolean this$passagens = this.getPassagens();
        Boolean other$passagens = other.getPassagens();
        if (this$passagens == null ? other$passagens != null : !((Object)this$passagens).equals(other$passagens)) {
            return false;
        }
        Boolean this$comprasDireta = this.getComprasDireta();
        Boolean other$comprasDireta = other.getComprasDireta();
        if (this$comprasDireta == null ? other$comprasDireta != null : !((Object)this$comprasDireta).equals(other$comprasDireta)) {
            return false;
        }
        Boolean this$dispensaInexigibilidade = this.getDispensaInexigibilidade();
        Boolean other$dispensaInexigibilidade = other.getDispensaInexigibilidade();
        if (this$dispensaInexigibilidade == null ? other$dispensaInexigibilidade != null : !((Object)this$dispensaInexigibilidade).equals(other$dispensaInexigibilidade)) {
            return false;
        }
        String this$tipoNivelDespesa = this.getTipoNivelDespesa();
        String other$tipoNivelDespesa = other.getTipoNivelDespesa();
        if (this$tipoNivelDespesa == null ? other$tipoNivelDespesa != null : !this$tipoNivelDespesa.equals(other$tipoNivelDespesa)) {
            return false;
        }
        String this$nivelLei = this.getNivelLei();
        String other$nivelLei = other.getNivelLei();
        if (this$nivelLei == null ? other$nivelLei != null : !this$nivelLei.equals(other$nivelLei)) {
            return false;
        }
        String this$codigoNivelDespesa = this.getCodigoNivelDespesa();
        String other$codigoNivelDespesa = other.getCodigoNivelDespesa();
        if (this$codigoNivelDespesa == null ? other$codigoNivelDespesa != null : !this$codigoNivelDespesa.equals(other$codigoNivelDespesa)) {
            return false;
        }
        String this$search = this.getSearch();
        String other$search = other.getSearch();
        if (this$search == null ? other$search != null : !this$search.equals(other$search)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        String this$tipoBem = this.getTipoBem();
        String other$tipoBem = other.getTipoBem();
        if (this$tipoBem == null ? other$tipoBem != null : !this$tipoBem.equals(other$tipoBem)) {
            return false;
        }
        String this$chapaBem = this.getChapaBem();
        String other$chapaBem = other.getChapaBem();
        if (this$chapaBem == null ? other$chapaBem != null : !this$chapaBem.equals(other$chapaBem)) {
            return false;
        }
        ProgramaticaParams this$programatica = this.getProgramatica();
        ProgramaticaParams other$programatica = other.getProgramatica();
        if (this$programatica == null ? other$programatica != null : !this$programatica.equals(other$programatica)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        Long this$ordemItemEmpenho = this.getOrdemItemEmpenho();
        Long other$ordemItemEmpenho = other.getOrdemItemEmpenho();
        if (this$ordemItemEmpenho == null ? other$ordemItemEmpenho != null : !((Object)this$ordemItemEmpenho).equals(other$ordemItemEmpenho)) {
            return false;
        }
        Long this$mesInicialMov = this.getMesInicialMov();
        Long other$mesInicialMov = other.getMesInicialMov();
        if (this$mesInicialMov == null ? other$mesInicialMov != null : !((Object)this$mesInicialMov).equals(other$mesInicialMov)) {
            return false;
        }
        Long this$mesFinalMov = this.getMesFinalMov();
        Long other$mesFinalMov = other.getMesFinalMov();
        if (this$mesFinalMov == null ? other$mesFinalMov != null : !((Object)this$mesFinalMov).equals(other$mesFinalMov)) {
            return false;
        }
        Long this$mesInicialEmissao = this.getMesInicialEmissao();
        Long other$mesInicialEmissao = other.getMesInicialEmissao();
        if (this$mesInicialEmissao == null ? other$mesInicialEmissao != null : !((Object)this$mesInicialEmissao).equals(other$mesInicialEmissao)) {
            return false;
        }
        Long this$mesFinalEmissao = this.getMesFinalEmissao();
        Long other$mesFinalEmissao = other.getMesFinalEmissao();
        if (this$mesFinalEmissao == null ? other$mesFinalEmissao != null : !((Object)this$mesFinalEmissao).equals(other$mesFinalEmissao)) {
            return false;
        }
        Long this$fonteRecurso = this.getFonteRecurso();
        Long other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !((Object)this$fonteRecurso).equals(other$fonteRecurso)) {
            return false;
        }
        String this$esfera = this.getEsfera();
        String other$esfera = other.getEsfera();
        if (this$esfera == null ? other$esfera != null : !this$esfera.equals(other$esfera)) {
            return false;
        }
        Long this$noLiquidacao = this.getNoLiquidacao();
        Long other$noLiquidacao = other.getNoLiquidacao();
        if (this$noLiquidacao == null ? other$noLiquidacao != null : !((Object)this$noLiquidacao).equals(other$noLiquidacao)) {
            return false;
        }
        String this$isCovid = this.getIsCovid();
        String other$isCovid = other.getIsCovid();
        if (this$isCovid == null ? other$isCovid != null : !this$isCovid.equals(other$isCovid)) {
            return false;
        }
        Boolean this$consumo = this.getConsumo();
        Boolean other$consumo = other.getConsumo();
        if (this$consumo == null ? other$consumo != null : !((Object)this$consumo).equals(other$consumo)) {
            return false;
        }
        Boolean this$permanente = this.getPermanente();
        Boolean other$permanente = other.getPermanente();
        return !(this$permanente == null ? other$permanente != null : !((Object)this$permanente).equals(other$permanente));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmpenhoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $empenhoInicial = this.getEmpenhoInicial();
        result = result * 59 + ($empenhoInicial == null ? 43 : ((Object)$empenhoInicial).hashCode());
        Long $empenhoFinal = this.getEmpenhoFinal();
        result = result * 59 + ($empenhoFinal == null ? 43 : ((Object)$empenhoFinal).hashCode());
        Long $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        String $unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        result = result * 59 + ($unidadeOrcamentaria == null ? 43 : $unidadeOrcamentaria.hashCode());
        Boolean $aPagar = this.getAPagar();
        result = result * 59 + ($aPagar == null ? 43 : ((Object)$aPagar).hashCode());
        Boolean $passagens = this.getPassagens();
        result = result * 59 + ($passagens == null ? 43 : ((Object)$passagens).hashCode());
        Boolean $comprasDireta = this.getComprasDireta();
        result = result * 59 + ($comprasDireta == null ? 43 : ((Object)$comprasDireta).hashCode());
        Boolean $dispensaInexigibilidade = this.getDispensaInexigibilidade();
        result = result * 59 + ($dispensaInexigibilidade == null ? 43 : ((Object)$dispensaInexigibilidade).hashCode());
        String $tipoNivelDespesa = this.getTipoNivelDespesa();
        result = result * 59 + ($tipoNivelDespesa == null ? 43 : $tipoNivelDespesa.hashCode());
        String $nivelLei = this.getNivelLei();
        result = result * 59 + ($nivelLei == null ? 43 : $nivelLei.hashCode());
        String $codigoNivelDespesa = this.getCodigoNivelDespesa();
        result = result * 59 + ($codigoNivelDespesa == null ? 43 : $codigoNivelDespesa.hashCode());
        String $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : $search.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        String $tipoBem = this.getTipoBem();
        result = result * 59 + ($tipoBem == null ? 43 : $tipoBem.hashCode());
        String $chapaBem = this.getChapaBem();
        result = result * 59 + ($chapaBem == null ? 43 : $chapaBem.hashCode());
        ProgramaticaParams $programatica = this.getProgramatica();
        result = result * 59 + ($programatica == null ? 43 : $programatica.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        Long $ordemItemEmpenho = this.getOrdemItemEmpenho();
        result = result * 59 + ($ordemItemEmpenho == null ? 43 : ((Object)$ordemItemEmpenho).hashCode());
        Long $mesInicialMov = this.getMesInicialMov();
        result = result * 59 + ($mesInicialMov == null ? 43 : ((Object)$mesInicialMov).hashCode());
        Long $mesFinalMov = this.getMesFinalMov();
        result = result * 59 + ($mesFinalMov == null ? 43 : ((Object)$mesFinalMov).hashCode());
        Long $mesInicialEmissao = this.getMesInicialEmissao();
        result = result * 59 + ($mesInicialEmissao == null ? 43 : ((Object)$mesInicialEmissao).hashCode());
        Long $mesFinalEmissao = this.getMesFinalEmissao();
        result = result * 59 + ($mesFinalEmissao == null ? 43 : ((Object)$mesFinalEmissao).hashCode());
        Long $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : ((Object)$fonteRecurso).hashCode());
        String $esfera = this.getEsfera();
        result = result * 59 + ($esfera == null ? 43 : $esfera.hashCode());
        Long $noLiquidacao = this.getNoLiquidacao();
        result = result * 59 + ($noLiquidacao == null ? 43 : ((Object)$noLiquidacao).hashCode());
        String $isCovid = this.getIsCovid();
        result = result * 59 + ($isCovid == null ? 43 : $isCovid.hashCode());
        Boolean $consumo = this.getConsumo();
        result = result * 59 + ($consumo == null ? 43 : ((Object)$consumo).hashCode());
        Boolean $permanente = this.getPermanente();
        result = result * 59 + ($permanente == null ? 43 : ((Object)$permanente).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmpenhoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", empenhoInicial=" + this.getEmpenhoInicial() + ", empenhoFinal=" + this.getEmpenhoFinal() + ", empenho=" + this.getEmpenho() + ", unidadeOrcamentaria=" + this.getUnidadeOrcamentaria() + ", aPagar=" + this.getAPagar() + ", passagens=" + this.getPassagens() + ", comprasDireta=" + this.getComprasDireta() + ", dispensaInexigibilidade=" + this.getDispensaInexigibilidade() + ", tipoNivelDespesa=" + this.getTipoNivelDespesa() + ", nivelLei=" + this.getNivelLei() + ", codigoNivelDespesa=" + this.getCodigoNivelDespesa() + ", search=" + this.getSearch() + ", exportType=" + this.getExportType() + ", tipoBem=" + this.getTipoBem() + ", chapaBem=" + this.getChapaBem() + ", programatica=" + this.getProgramatica() + ", cnpjCpf=" + this.getCnpjCpf() + ", ordemItemEmpenho=" + this.getOrdemItemEmpenho() + ", mesInicialMov=" + this.getMesInicialMov() + ", mesFinalMov=" + this.getMesFinalMov() + ", mesInicialEmissao=" + this.getMesInicialEmissao() + ", mesFinalEmissao=" + this.getMesFinalEmissao() + ", fonteRecurso=" + this.getFonteRecurso() + ", esfera=" + this.getEsfera() + ", noLiquidacao=" + this.getNoLiquidacao() + ", isCovid=" + this.getIsCovid() + ", consumo=" + this.getConsumo() + ", permanente=" + this.getPermanente() + ")";
    }

    @Generated
    public EmpenhoParams() {
    }
}

