/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.portaltransparencia.protocportal.domain.Escolaridade;
import br.com.elotech.portaltransparencia.protocportal.domain.Local;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoArquivo;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoPK;
import br.com.elotech.portaltransparencia.protocportal.domain.Sexo;
import br.com.elotech.portaltransparencia.protocportal.domain.Situacao;
import br.com.elotech.portaltransparencia.protocportal.domain.Tramite;
import br.com.elotech.portaltransparencia.protocportal.domain.dto.converter.SexoConverter;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="processos")
@DynamicInsert
@DynamicUpdate
public class Processo
implements EloEntity<ProcessoPK>,
Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ProcessoPK id = new ProcessoPK();
    @ManyToOne
    @JoinColumn(name="codpessoa")
    @NotFound(action=NotFoundAction.IGNORE)
    private Pessoa pessoa;
    @Length(max=2000)
    private @Length(max=2000) String digitacao;
    @Column(name="senhainternet", length=5)
    private String senha;
    @ManyToOne
    private Situacao situacao;
    private Long codAssunto;
    @Length(max=100)
    private @Length(max=100) String assunto;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="localDestino", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    private Local localDestino;
    private LocalDate dataDestino = LocalDate.now();
    private LocalDateTime horaDestino = LocalDateTime.now();
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="localOrigem", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    private Local localOrigem;
    private LocalDate dataOrigem = LocalDate.now();
    private LocalDateTime horaOrigem = LocalDateTime.now();
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="localAtual", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    private Local localAtual;
    @Length(max=100)
    private @Length(max=100) String endereco;
    private String complemento;
    @Length(max=2)
    private @Length(max=2) String uf;
    @Length(max=9)
    private @Length(max=9) String cep;
    @Length(max=40)
    private @Length(max=40) String telefone;
    @Length(max=20)
    private @Length(max=20) String rg;
    @Length(max=60)
    private @Length(max=60) String email;
    @Length(max=60)
    private @Length(max=60) String celular;
    @Length(max=20)
    @Column(name="cnpj_cpf")
    private @Length(max=20) String cnpjCpf;
    @Length(max=2)
    private @Length(max=2) String unidadeFederacao;
    @Length(max=10)
    private @Length(max=10) String numeroEndereco;
    @Length(max=255)
    private @Length(max=255) String outrosDados;
    private LocalDate dataprocesso = LocalDate.now();
    private String status;
    @Length(max=40)
    private @Length(max=40) String cidadeAux;
    @Length(max=40)
    private @Length(max=40) String bairroAux;
    private String usuarioReg;
    @Column(name="processo_referencia")
    private String processoReferencia;
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.processo")
    private final List<Tramite> tramites = new ArrayList();
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.processo")
    private final List<ProcessoArquivo> arquivos = new ArrayList();
    @Caption(value="Escolaridade")
    @ManyToOne
    private Escolaridade escolaridade;
    @Caption(value="Sexo")
    @Column(length=1)
    @Convert(converter=SexoConverter.class)
    private Sexo sexo;
    @Caption(value="Dt. Nascimento")
    private LocalDate dataNascimento;

    public Processo(ProcessoPK id, String digitacao) {
        this.id = id;
        this.digitacao = digitacao;
    }

    public Processo() {
    }

    public List<Tramite> getTramites() {
        return Optional.ofNullable(this.tramites).orElse(Lists.newArrayList());
    }

    public Tramite addTramite(Tramite tramite) {
        this.getTramites().add(tramite);
        return tramite;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Processo)) {
            return false;
        }
        Processo other = (Processo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProcessoPK this$id = this.getId();
        ProcessoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Processo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Processo(id=" + this.getId() + ")";
    }

    @Generated
    public ProcessoPK getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getDigitacao() {
        return this.digitacao;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public Situacao getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getCodAssunto() {
        return this.codAssunto;
    }

    @Generated
    public String getAssunto() {
        return this.assunto;
    }

    @Generated
    public Local getLocalDestino() {
        return this.localDestino;
    }

    @Generated
    public LocalDate getDataDestino() {
        return this.dataDestino;
    }

    @Generated
    public LocalDateTime getHoraDestino() {
        return this.horaDestino;
    }

    @Generated
    public Local getLocalOrigem() {
        return this.localOrigem;
    }

    @Generated
    public LocalDate getDataOrigem() {
        return this.dataOrigem;
    }

    @Generated
    public LocalDateTime getHoraOrigem() {
        return this.horaOrigem;
    }

    @Generated
    public Local getLocalAtual() {
        return this.localAtual;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public String getRg() {
        return this.rg;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getCelular() {
        return this.celular;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public String getNumeroEndereco() {
        return this.numeroEndereco;
    }

    @Generated
    public String getOutrosDados() {
        return this.outrosDados;
    }

    @Generated
    public LocalDate getDataprocesso() {
        return this.dataprocesso;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getCidadeAux() {
        return this.cidadeAux;
    }

    @Generated
    public String getBairroAux() {
        return this.bairroAux;
    }

    @Generated
    public String getUsuarioReg() {
        return this.usuarioReg;
    }

    @Generated
    public String getProcessoReferencia() {
        return this.processoReferencia;
    }

    @Generated
    public List<ProcessoArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public Escolaridade getEscolaridade() {
        return this.escolaridade;
    }

    @Generated
    public Sexo getSexo() {
        return this.sexo;
    }

    @Generated
    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    @Generated
    public void setId(ProcessoPK id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setDigitacao(String digitacao) {
        this.digitacao = digitacao;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setSituacao(Situacao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCodAssunto(Long codAssunto) {
        this.codAssunto = codAssunto;
    }

    @Generated
    public void setAssunto(String assunto) {
        this.assunto = assunto;
    }

    @Generated
    public void setLocalDestino(Local localDestino) {
        this.localDestino = localDestino;
    }

    @Generated
    public void setDataDestino(LocalDate dataDestino) {
        this.dataDestino = dataDestino;
    }

    @Generated
    public void setHoraDestino(LocalDateTime horaDestino) {
        this.horaDestino = horaDestino;
    }

    @Generated
    public void setLocalOrigem(Local localOrigem) {
        this.localOrigem = localOrigem;
    }

    @Generated
    public void setDataOrigem(LocalDate dataOrigem) {
        this.dataOrigem = dataOrigem;
    }

    @Generated
    public void setHoraOrigem(LocalDateTime horaOrigem) {
        this.horaOrigem = horaOrigem;
    }

    @Generated
    public void setLocalAtual(Local localAtual) {
        this.localAtual = localAtual;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setRg(String rg) {
        this.rg = rg;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setCelular(String celular) {
        this.celular = celular;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public void setNumeroEndereco(String numeroEndereco) {
        this.numeroEndereco = numeroEndereco;
    }

    @Generated
    public void setOutrosDados(String outrosDados) {
        this.outrosDados = outrosDados;
    }

    @Generated
    public void setDataprocesso(LocalDate dataprocesso) {
        this.dataprocesso = dataprocesso;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setCidadeAux(String cidadeAux) {
        this.cidadeAux = cidadeAux;
    }

    @Generated
    public void setBairroAux(String bairroAux) {
        this.bairroAux = bairroAux;
    }

    @Generated
    public void setUsuarioReg(String usuarioReg) {
        this.usuarioReg = usuarioReg;
    }

    @Generated
    public void setProcessoReferencia(String processoReferencia) {
        this.processoReferencia = processoReferencia;
    }

    @Generated
    public void setEscolaridade(Escolaridade escolaridade) {
        this.escolaridade = escolaridade;
    }

    @Generated
    public void setSexo(Sexo sexo) {
        this.sexo = sexo;
    }

    @Generated
    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }
}

