/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.QPatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioDetalheDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.mapper.PatrimonioBemToDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PatrimonioBemRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PatrimonioLocalNiveisModClafRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PatrimonioParams;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.function.Function;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PatrimonioBemService {
    private final PatrimonioBemRepository patrimonioBemRepository;
    private final PatrimonioLocalNiveisModClafRepository localNiveisModClafRepository;
    private final ParametroRepository parametroRepository;
    private final EntityManager em;

    @Autowired
    public PatrimonioBemService(PatrimonioBemRepository patrimonioBemRepository, PatrimonioLocalNiveisModClafRepository localNiveisModClafRepository, ParametroRepository parametroRepository, @Qualifier(value="entityManager") EntityManager em) {
        this.patrimonioBemRepository = patrimonioBemRepository;
        this.localNiveisModClafRepository = localNiveisModClafRepository;
        this.parametroRepository = parametroRepository;
        this.em = em;
    }

    public Page<PatrimonioBemDTO> findByEntidade(Long entidade, String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder();
        searchBuilder.append(" id.entidade==");
        searchBuilder.append(entidade);
        searchBuilder.append(" and baixado=='N'");
        if (search != null) {
            searchBuilder.append(" and ");
            searchBuilder.append(search);
        }
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.em, (String)searchBuilder.toString());
        PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id.tipo", "id.chapa"});
        Page list = this.patrimonioBemRepository.findAll(specification, (Pageable)pageRequest).map((Function)new PatrimonioBemToDTO());
        for (PatrimonioBemDTO patrimonioBemDTO : list) {
            patrimonioBemDTO.setDisplayTipoIncorporacao(patrimonioBemDTO.getTipoIncorporacao().getDescricao());
            if ("M".equals(patrimonioBemDTO.getTipo())) {
                patrimonioBemDTO.setDisplayTipoPatrimonio("M\u00f3vel");
                continue;
            }
            patrimonioBemDTO.setDisplayTipoPatrimonio(patrimonioBemDTO.getTipo());
        }
        return list;
    }

    public Page<PatrimonioBemDTO> getListPatrimonioBem(Pageable pageable, PatrimonioParams params) {
        return this.patrimonioBemRepository.getListPatrimonioBem(pageable, params);
    }

    public PatrimonioBem findByBem(PatrimonioParams params) {
        Long entidade = params.getEntidade();
        String tipo = params.getTipo();
        Long bem = params.getBem();
        String chapa = params.getChapa();
        PatrimonioBem patrimonioBem = (PatrimonioBem)this.patrimonioBemRepository.findOne((Predicate)QPatrimonioBem.patrimonioBem.id().entidade.eq((Object)entidade).and((Predicate)QPatrimonioBem.patrimonioBem.id().tipo.eq((Object)tipo)).and((Predicate)QPatrimonioBem.patrimonioBem.id().bem.eq((Object)bem)).and((Predicate)QPatrimonioBem.patrimonioBem.id().chapa.eq((Object)chapa))).orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel encontrar o patrim\u00f4nio bem"));
        if (patrimonioBem.getBaixado().booleanValue()) {
            params.setBaixado("S");
            List list = this.patrimonioBemRepository.findPatrimonioBemBaixa(params);
            if (!list.isEmpty()) {
                list.stream().findFirst().ifPresent(baixa -> patrimonioBem.setJustificativa(baixa.getJustificativa()));
                list.stream().findFirst().ifPresent(baixa -> patrimonioBem.setTipoBaixa(baixa.getTipoBaixa()));
            }
        }
        return patrimonioBem;
    }

    public List<PatrimonioDetalheDTO> findPatrimonioDetalhe(PatrimonioParams params) {
        PatrimonioBem patrimonioBem = this.findByBem(params);
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ParametroEnum.MODELOCLASSIFICAOLOCAIS.getModulo().getValue(), ParametroEnum.MODELOCLASSIFICAOLOCAIS.getCodigo());
        return this.localNiveisModClafRepository.findByLocalAtualEntidadeAndModelo(patrimonioBem.getLocalAtual(), params.getEntidade(), parametro.getValor());
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes(FindExercicioParams params) {
        return this.patrimonioBemRepository.findUltimasAtualizacoes(params);
    }
}

