/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.portaltransparencia.contabportal.domain.Empenho;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.function.Function;
import javax.swing.text.MaskFormatter;

public class EmpenhoToDTO
implements Function<Empenho, EmpenhosListaDTO> {
    @Override
    public EmpenhosListaDTO apply(Empenho empenho) {
        EmpenhosListaDTO empDto = new EmpenhosListaDTO();
        empDto.setEntidade(empenho.getId().getEntidade());
        empDto.setExercicio(empenho.getId().getExercicio());
        empDto.setEmpenho(empenho.getId().getEmpenho());
        empDto.setEmpenhoExercicio(empenho.getId().getEmpenho() + "/" + empenho.getId().getExercicio());
        empDto.setData(empenho.getData());
        empDto.setFornecedor(empenho.getFornecedor().getId());
        if (empenho.getFornecedor().getTipoPessoa().equals("J")) {
            empDto.setNome(this.getMaskFormatado(empenho.getFornecedor().getCnpj(), "##.###.###/####-##") + " - " + empenho.getFornecedor().getNome());
        } else {
            empDto.setNome("****" + empenho.getFornecedor().getCnpj().substring(4, 7) + "**** - " + empenho.getFornecedor().getNome());
        }
        empDto.setHistorico(empenho.getHistorico());
        empDto.setValorEmpenhado(this.getValorEmpenhado(empenho));
        empDto.setValorAnulado(this.getValorAnulado(empenho));
        empDto.setValorLiquidado(this.getValorLiquidado(empenho));
        empDto.setValorRetido(this.getValorRetido(empenho));
        empDto.setValorPago(this.getValorPago(empenho));
        empDto.setValorAPagar(this.getValorAPagar(empenho));
        return empDto;
    }

    private String getMaskFormatado(String value, String mask) {
        try {
            MaskFormatter formatter = new MaskFormatter(mask);
            formatter.setValueContainsLiteralCharacters(false);
            return formatter.valueToString(value);
        }
        catch (ParseException e) {
            return value;
        }
    }

    public BigDecimal getValorEmpenhado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorAnulado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorAnulado).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorLiquidado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorLiquidado).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorRetido(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::getValorRetencoes).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorPago(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorPago).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorAPagar(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorAPagar).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

