/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class DataSourceConfig {
    public static final String DIALECT = "${db.contabilidade.dialect:}";
    private static final String PREFIX = "spring.datasource.contab";
    private static final String[] DOMAINPACKAGES = new String[]{"br.com.elotech.portaltransparencia.contabportal.domain", "br.com.elotech.portaltransparencia.admportal.domain", "br.com.elotech.portaltransparencia.legislacaoportal.domain", "br.com.elotech.portaltransparencia.arquivoportal.domain"};

    @Primary
    @Bean
    @ConfigurationProperties(prefix="spring.datasource.contab")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean
    public LocalContainerEntityManagerFactoryBean entityManager(EntityManagerFactoryBuilder builder, @Qualifier(value="dataSource") DataSource dataSource, @Value(value="${db.contabilidade.dialect:}") String dialect, List<HibernatePropertiesCustomizer> propertiesCustomizer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", dialect);
        propertiesCustomizer.forEach(props -> props.customize(properties));
        return builder.dataSource(dataSource).packages(DOMAINPACKAGES).properties(properties).build();
    }

    @Primary
    @Bean
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManager") LocalContainerEntityManagerFactoryBean entityManager) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManager.getObject());
        return transactionManager;
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        return dataSourceInitializer;
    }
}

