/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.TipoContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.service.ContratoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/contratos"})
public class ContratoResource {
    private final ContratoService contratoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public ContratoResource(ContratoService contratoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.contratoService = contratoService;
    }

    @GetMapping
    public ResponseEntity<Page<ContratoDTO>> findContratos(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio") Long exercicio, @Valid FindContratoParams findContratoParams, Pageable pageable) {
        findContratoParams.setEntidade(entidade);
        findContratoParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.contratoService.findContratos(findContratoParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findContratosExport(HttpServletRequest request, HttpServletResponse response, @Valid FindContratoParams findContratoParams, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.contratoService.findContratos(findContratoParams, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)findContratoParams.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Contratos");
        reportParam.setClazzDTO(ContratoDTO.class);
        reportParam.setHeaderFields("Tipo Contrato,N\u00ba Contrato,Tipo Licita\u00e7\u00e3o,Licita\u00e7\u00e3o,Contratado,In\u00edcio Vig\u00eancia,T\u00e9rmino Vig\u00eancia,Valor Contratado,Valor Aditivo,Situa\u00e7\u00e3o");
        reportParam.setFields("displayTipoContrato,displayContrato,descricaoTipoLicitacao,displayLicitacao,nome,inicioVigencia,terminoVigencia,valorContratado,valorAditivo,situacao");
        float[] fieldsPerc = new float[]{1.3f, 1.3f, 1.0f, 0.7f, 2.0f, 0.7f, 0.7f, 0.7f, 0.7f, 0.9f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 20, 20, 20, 100, 15, 15, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(findContratoParams.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(params={"entidade", "exercicio", "contrato"})
    public ResponseEntity<ContratoDTO> findContrato(FindContratoParams params) {
        ContratoDTO contrato = this.contratoService.findContrato(params);
        return ResponseEntity.ok((Object)contrato);
    }

    @GetMapping(value={"/tipos"}, params={"uf"})
    public ResponseEntity<List<TipoContratoDTO>> findTiposContrato(@RequestParam String uf) {
        List list = this.contratoService.findTiposContrato(uf);
        return ResponseEntity.ok((Object)list);
    }

    @GetMapping(value={"/licitacao"}, params={"entidade", "exercicioLicitacao", "numeroLicitacao", "tipoLicitacao"})
    public ResponseEntity<List<ContratoDTO>> findContratosLicitacao(FindContratoParams findContratoParams) {
        return ResponseEntity.ok((Object)this.contratoService.findContratosLicitacao(findContratoParams));
    }

    @GetMapping(value={"/obra"}, params={"entidade", "exercicio", "contrato"})
    public ResponseEntity<ContratoDTO> findContratoByIdContrato(FindContratoParams findContratoParams) {
        return ResponseEntity.ok((Object)this.contratoService.findContratoByIdContrato(findContratoParams));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "contrato"})
    public ResponseEntity<List<ContratoArquivoDTO>> findArquivos(FindContratoParams findContratoParams) {
        return ResponseEntity.ok((Object)this.contratoService.findArquivos(findContratoParams));
    }

    @GetMapping(value={"/ultimas-atualizacoes"})
    public ResponseEntity<List<UltimaAtualizacaoDTO>> findUltimaAtualizacao(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindExercicioParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.contratoService.findUltimaAtualizacao(params));
    }
}

