/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.DefinicaoClasse;
import br.com.elotech.portaltransparencia.aiseportal.repository.DefinicaoClasseRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DefinicaoClasseRepositoryImpl
implements DefinicaoClasseRepository {
    private static final String NATUREZAS_SERVIDORES_SQL = "db/sql/aise/naturezas-servidores.sql";
    private static final String NATUREZAS_APOSENTADOS_PENS_SQL = "db/sql/aise/naturezas-aposentados-pensionistas.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    public DefinicaoClasseRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public List<DefinicaoClasse> findDefinicoesServidores(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)NATUREZAS_SERVIDORES_SQL));
        MapSqlParameterSource parameter = params.toJdbcParameter();
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(DefinicaoClasse.class));
    }

    public List<DefinicaoClasse> findDefinicoesAposentadosPensionistas(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)NATUREZAS_APOSENTADOS_PENS_SQL));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DefinicaoClasse.class));
    }
}

