SELECT EXTRACT(MONTH FROM PR.DATA) MES,
       CAST(COALESCE(SUM(PR.VALOR) + SUM(RM.VALORCORRECAOORCADO + RM.VALORCORRECAO),0) AS NUMERIC(15,2)) VALORPREVISTO,
	   CAST(COALESCE(SUM(RM.VALORARRECADADO-RM.VALORESTARRECADADO-RM.VALORDEVOLUCAO+RM.VALORESTDEVOLUCAO),0) AS NUMERIC(15,2)) VALORARRECADADO 
FROM   PREVISAORECEITA PR
JOIN RECEITA R
 ON R.ENTIDADE 						  = PR.ENTIDADE
AND R.EXERCICIO 					  = PR.EXERCICIO
AND R.FONTERECURSO 					= PR.FONTERECURSO
AND R.RECEITA 						  = PR.RECEITA
AND R.IDTIPOOPERACAORECEITA = PR.IDTIPOOPERACAORECEITA
JOIN RECEITAMENSAL RM
  ON RM.ENTIDADE              = R.ENTIDADE
 AND RM.EXERCICIO					  	= R.EXERCICIO
 AND RM.FONTERECURSO			   	= R.FONTERECURSO
 AND RM.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
 AND RM.RECEITA								= R.RECEITA
 AND RM.MES										= EXTRACT(MONTH FROM PR.DATA)
WHERE  PR.ENTIDADE  = :entidade
AND    PR.EXERCICIO = :exercicio
AND    R.MOVSN      = 'S'
GROUP BY EXTRACT(MONTH FROM PR.DATA)
ORDER BY EXTRACT(MONTH FROM PR.DATA)