/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LgLeisAtosRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LgLeisAtosRepositoryImpl
implements LgLeisAtosRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LgLeisAtosRepositoryImpl.class);
    private static final String LGLEI = "db/sql/contab/lg_lei.sql";
    private static final String LGDECRETO = "db/sql/contab/lg_decreto.sql";
    private static final String LGPORTARIA = "db/sql/contab/lg_portaria.sql";
    private static final String LGLEIARQUIVO = "db/sql/contab/lg_lei_arquivo.sql";
    private static final String LGLEIARQUIVO_LEG = "db/sql/contab/lg_lei_arquivo_legislativo.sql";
    private static final String LGDECRETOARQUIVO = "db/sql/contab/lg_decreto_arquivo.sql";
    private static final String LGDECRETOARQUIVO_LEG = "db/sql/contab/lg_decreto_arquivo_legislativo.sql";
    private static final String LGPORTARIAARQUIVO = "db/sql/contab/lg_portaria_arquivo.sql";
    private static final String LGPORTARIAARQUIVO_LEG = "db/sql/contab/lg_portaria_arquivo_legislativo.sql";
    private static final String LEIDESC = "Lei";
    private static final String DECRETODESC = "Decreto";
    private static final String PORTARIADESC = "Portaria";
    private final DatasourceWrapper datasourceWrapper;
    private final PortalParametroService portalParametroService;

    @Autowired
    public LgLeisAtosRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, PortalParametroService portalParametroService) {
        this.datasourceWrapper = datasourceWrapper;
        this.portalParametroService = portalParametroService;
    }

    public List<LeisAtosDTO> findLgLei(LeisAtosParams params) {
        if (!params.getNatureza().isPresent() || params.getNatureza().filter("LEI"::equalsIgnoreCase).isPresent()) {
            StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LGLEI));
            params.getAno().ifPresent(item -> query.append("\n   AND A.ANO = :ano"));
            params.getNumero().ifPresent(item -> query.append("\n   AND A.LEI = :numero "));
            params.getTipo().ifPresent(item -> query.append("\n   AND A.TIPOLEI = :tipo "));
            params.getId().ifPresent(item -> query.append("\n AND A.LEI = :id "));
            params.getDescricao().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(BLOBTOVARCHAR(A.DESCRICAOBLOB))) LIKE tiraacento(UPPER(:descricao)) "));
            params.getSumula().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(A.SUMULA)) LIKE tiraacento(UPPER(:sumula)) "));
            params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATALEI >= :dataInicial "));
            params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATALEI <= :dataFinal "));
            params.getIsCovid().ifPresent(isCovid -> query.append("\n AND UPPER(A.MPCOVID19) LIKE UPPER(:isCovid) "));
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
            return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
        }
        return new ArrayList<LeisAtosDTO>();
    }

    public List<LeisAtosDTO> findLgDecreto(LeisAtosParams params) {
        if (!params.getNatureza().isPresent() || params.getNatureza().filter("DECRETO"::equalsIgnoreCase).isPresent() && !params.getSumula().isPresent()) {
            StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LGDECRETO));
            params.getAno().ifPresent(item -> query.append("\n AND A.ANODECRETO = :ano"));
            params.getNumero().ifPresent(item -> query.append("\n   AND A.DECRETO = :numero "));
            params.getId().ifPresent(item -> query.append("\n   AND A.DECRETO = :id "));
            params.getDescricao().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(F.DESCRICAO)) LIKE tiraacento(UPPER(:descricao)) "));
            params.getSumula().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(BLOBTOVARCHAR(A.SUMULABLOB))) LIKE tiraacento(UPPER(:sumula)) "));
            params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATA >= :dataInicial "));
            params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATA <= :dataFinal "));
            params.getIsCovid().ifPresent(isCovid -> query.append("\n AND UPPER(A.MPCOVID19) LIKE UPPER(:isCovid) "));
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
            return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
        }
        return new ArrayList<LeisAtosDTO>();
    }

    public List<LeisAtosDTO> findLgPortaria(LeisAtosParams params) {
        if (!params.getNatureza().isPresent() || params.getNatureza().filter("PORTARIA"::equalsIgnoreCase).isPresent() && !params.getSumula().isPresent()) {
            StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LGPORTARIA));
            params.getAno().ifPresent(item -> query.append("\n AND A.ANOPORTARIA = :ano "));
            params.getNumero().ifPresent(item -> query.append("\n   AND A.PORTARIA = :numero "));
            params.getTipo().ifPresent(item -> query.append("\n   AND A.TIPOPORTARIA = :tipo "));
            params.getId().ifPresent(item -> query.append("\n   AND A.PORTARIA = :id "));
            params.getDescricao().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(F.DESCRICAO)) LIKE tiraacento(UPPER(:descricao)) "));
            params.getSumula().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(BLOBTOVARCHAR(A.SUMULABLOB))) LIKE tiraacento(UPPER(:sumula)) "));
            params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATA >= :dataInicial "));
            params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATA <= :dataFinal "));
            params.getIsCovid().ifPresent(isCovid -> query.append("\n AND UPPER(A.MPCOVID19) LIKE UPPER(:isCovid) "));
            this.loggerSql(query);
            return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
        }
        return new ArrayList<LeisAtosDTO>();
    }

    private void loggerSql(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<LeisAtosArquivoDTO> findLgLeisArquivos(Long exercicio, Long id, Long tipo, String natureza) {
        StringBuilder query = new StringBuilder();
        Boolean schemaImagem = SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_USA_LEGISLATIVO));
        if (!schemaImagem.booleanValue()) {
            if (LEIDESC.equalsIgnoreCase(natureza)) {
                query.append(FileUtils.readResourceAsString((String)LGLEIARQUIVO));
            } else if (DECRETODESC.equalsIgnoreCase(natureza)) {
                query.append(FileUtils.readResourceAsString((String)LGDECRETOARQUIVO));
            } else if (PORTARIADESC.equalsIgnoreCase(natureza)) {
                query.append(FileUtils.readResourceAsString((String)LGPORTARIAARQUIVO));
            }
        } else if (LEIDESC.equalsIgnoreCase(natureza)) {
            query.append(FileUtils.readResourceAsString((String)LGLEIARQUIVO_LEG));
        } else if (DECRETODESC.equalsIgnoreCase(natureza)) {
            query.append(FileUtils.readResourceAsString((String)LGDECRETOARQUIVO_LEG));
        } else if (PORTARIADESC.equalsIgnoreCase(natureza)) {
            query.append(FileUtils.readResourceAsString((String)LGPORTARIAARQUIVO_LEG));
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (!Objects.isNull(tipo)) {
            params.addValue("TIPO", (Object)tipo, 2);
        }
        params.addValue("IDLEIATO", (Object)id, 2);
        params.addValue("ANO", (Object)exercicio, 2);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosArquivoDTO.class));
    }

    public List<LeisAtosArquivoDTO> findLgLeisArquivos(Long exercicio, Long id, String natureza) {
        return this.findLgLeisArquivos(exercicio, id, null, natureza);
    }
}

