/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(entityManagerFactoryRef="entityManagerProtocolo", basePackages={"br.com.elotech.portaltransparencia.protocportal"})
public class DataSourceConfigProtocolo {
    public static final String DIALECT = "${db.protoc.dialect:}";
    private static final String PREFIX = "spring.datasource.protoc";
    private static final String[] DOMAINPACKAGES = new String[]{"br.com.elotech.portaltransparencia.protocportal.domain"};

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.protoc")
    public DataSource dataSourceProtocolo() {
        return DataSourceBuilder.create().build();
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerProtocolo(EntityManagerFactoryBuilder builder, @Qualifier(value="dataSourceProtocolo") DataSource dataSourceProtocolo, @Value(value="${db.protoc.dialect:}") String dialect, List<HibernatePropertiesCustomizer> propertiesCustomizer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", dialect);
        propertiesCustomizer.forEach(props -> props.customize(properties));
        return builder.dataSource(dataSourceProtocolo).packages(DOMAINPACKAGES).persistenceUnit("protocportal").properties(properties).build();
    }

    @Bean
    public PlatformTransactionManager transactionManagerProtocolo(@Qualifier(value="entityManagerProtocolo") LocalContainerEntityManagerFactoryBean entityManager) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManager.getObject());
        return transactionManager;
    }
}

