SELECT A.PORTARIA AS ID,
       :entidade AS ENTIDADE,
       CAST('Portaria' AS VARCHAR(8)) AS NATUREZA,
       A.PORTARIA AS NUMERO,
       A.TIPOPORTARIA AS TIPO,
       A.ANOPORTARIA AS EXERCICIO,
       A.PAGINA_EDICAO AS PAGINA,
       A.NUMERO_EDICAO AS NUMEROEDICAO,
       F.DESCRICAO,
       A.DATA,
       B.NOME AS VEICULOPUBLICACAO,
       A.DATAPUBLICACAO,
       TP.DESCRICAO AS TIPODOCUMENTOLEGAL,
       CAST(' ' AS VARCHAR(100)) AS SUMULA,
       CASE WHEN A.ARQUIVOPDF IS NULL THEN 0 ELSE 1 END AS TOTALARQUIVO,
       CAST('L' AS VARCHAR(1)) AS SISTEMA,
       CAST('P' AS VARCHAR(1)) AS TABELALEGISLATIVO
  FROM LG_PORTARIA A
  LEFT JOIN LG_ORGAOPUBLICACAO B ON A.ORGAOPUBLICACAO = B.ORGAOPUBLICACAO
  LEFT JOIN LG_FINALIDADE F ON A.FINALIDADE = F.FINALIDADE
  LEFT JOIN LG_TIPOPORTARIA TP ON TP.TIPOPORTARIA = A.TIPOPORTARIA
 WHERE A.PORTARIA IS NOT NULL
