/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContaPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams;
import br.com.elotech.portaltransparencia.contabportal.service.LiquidacaoService;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/liquidacoes"})
public class LiquidacaoResource {
    private final LiquidacaoService liquidacaoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public LiquidacaoResource(LiquidacaoService liquidacaoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.liquidacaoService = liquidacaoService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping(value={"/pagar"})
    public ResponseEntity<Page<LiquidacaoDTO>> findLiquidacoesAPagar(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params, Pageable pageable) {
        this.setTipoPagar(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesAPagar(params, pageable));
    }

    private void setTipoPagar(LiquidacaoParams params) {
        if (Objects.isNull(params.getTipo())) {
            params.setTipo("pagar");
        }
    }

    @GetMapping(value={"/pagar/report"})
    public ModelAndView findLiquidacoesPagarExport(HttpServletRequest request, HttpServletResponse response, LiquidacaoParams params, Pageable pageable) throws Throwable {
        this.setTipoPagar(params);
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.liquidacaoService.findLiquidacoesAPagar(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Liquida\u00e7\u00f5es a pagar");
        reportParam.setClazzDTO(LiquidacaoDTO.class);
        reportParam.setHeaderFields("Fonte Recurso,Data Liquida\u00e7\u00e3o,Liquida\u00e7\u00e3o,Empenho,Fornecedor,Tipo Licita\u00e7\u00e3o,Licita\u00e7\u00e3o,Notas Fiscais,Valor");
        reportParam.setFields("fonteRecurso,data,noLiquidacao,empenhoExercicio,fornecedor,tipoLicitacao,licitacao,notasFiscais,valor");
        float[] fieldsPerc = new float[]{2.0f, 1.0f, 1.0f, 1.0f, 2.5f, 1.0f, 0.8f, 0.7f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 15, 15, 15, 100, 15, 15, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/aptos-pagamentos/report"})
    public ModelAndView findAptosPagamentoExport(HttpServletRequest request, HttpServletResponse response, LiquidacaoParams params, Pageable pageable) throws Throwable {
        this.setTipoAptosPagamentos(params);
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.liquidacaoService.findLiquidacoesAPagar(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Aptos para Pagamento");
        reportParam.setClazzDTO(LiquidacaoDTO.class);
        reportParam.setHeaderFields("Fonte Recurso,Data Liquida\u00e7\u00e3o,Liquida\u00e7\u00e3o,Empenho,Fornecedor,Tipo Licita\u00e7\u00e3o,Licita\u00e7\u00e3o,Notas Fiscais,Valor");
        reportParam.setFields("fonteRecurso,data,noLiquidacao,empenhoExercicio,fornecedor,tipoLicitacao,licitacao,notasFiscais,valor");
        float[] fieldsPerc = new float[]{2.0f, 1.0f, 1.0f, 1.0f, 2.5f, 1.0f, 0.8f, 0.7f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 15, 15, 15, 100, 15, 15, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/pagas/report"})
    public ModelAndView findLiquidacoesPagasExport(HttpServletRequest request, HttpServletResponse response, LiquidacaoParams params, Pageable pageable) throws Throwable {
        this.setTipoPagas(params);
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.liquidacaoService.findLiquidacoesPagas(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Liquida\u00e7\u00f5es pagas");
        reportParam.setClazzDTO(LiquidacaoDTO.class);
        reportParam.setHeaderFields("Fonte Recurso,Data Liquida\u00e7\u00e3o,Liquida\u00e7\u00e3o,Empenho,Fornecedor,Tipo Licita\u00e7\u00e3o,Licita\u00e7\u00e3o,Notas Fiscais,Valor");
        reportParam.setFields("fonteRecurso,data,noLiquidacao,empenhoExercicio,fornecedor,tipoLicitacao,licitacao,notasFiscais,valor");
        float[] fieldsPerc = new float[]{2.0f, 1.0f, 1.0f, 1.0f, 2.5f, 1.0f, 0.8f, 0.7f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 15, 15, 15, 100, 15, 15, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/suprimentos-fundos/report"})
    public ModelAndView findSuprimentosFundosExport(HttpServletRequest request, HttpServletResponse response, LiquidacaoParams params, Pageable pageable) throws Throwable {
        this.setTipoSuprimentosFundos(params);
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.liquidacaoService.findLiquidacoesPagas(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Suprimento de Fundos");
        reportParam.setClazzDTO(LiquidacaoDTO.class);
        reportParam.setHeaderFields("Empenho,Exercicio,Processo,Data de Pagamento,Fornecedor,Valor");
        reportParam.setFields("empenho,exercicio,processo,data,fornecedor,valor");
        float[] fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 5.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 20, 50, 20, 100, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/pagar/total"})
    public ResponseEntity<LiquidacaoDTO> findLiquidacoesAPagarTotal(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params) {
        this.setTipoPagar(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesAPagarTotal(params));
    }

    @GetMapping(value={"/pagas"})
    public ResponseEntity<Page<LiquidacaoDTO>> findLiquidacoesPagas(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params, Pageable pageable) {
        this.setTipoPagas(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesPagas(params, pageable));
    }

    private void setTipoPagas(LiquidacaoParams params) {
        if (Objects.isNull(params.getTipo())) {
            params.setTipo("pagas");
        }
    }

    @GetMapping(value={"/pagas/total"})
    public ResponseEntity<LiquidacaoDTO> findLiquidacoesPagasTotal(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params) {
        this.setTipoPagas(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesPagasTotal(params));
    }

    @GetMapping(value={"/suprimentos-fundos"})
    public ResponseEntity<Page<LiquidacaoDTO>> findSuprimentosFundos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, LiquidacaoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        this.setTipoSuprimentosFundos(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesPagas(params, pageable));
    }

    private void setTipoSuprimentosFundos(LiquidacaoParams params) {
        if (Objects.isNull(params.getTipo())) {
            params.setTipo("suprimentos-fundos");
        }
    }

    @GetMapping(value={"/suprimentos-fundos/total"})
    public ResponseEntity<LiquidacaoDTO> findSuprimentosFundosTotal(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params) {
        params.setEntidade(entidade);
        this.setTipoSuprimentosFundos(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesPagasTotal(params));
    }

    @GetMapping(value={"/aptos-pagamentos"})
    public ResponseEntity<Page<LiquidacaoDTO>> findAptosPagamentos(@RequestHeader(value="entidade") Long entidade, LiquidacaoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        this.setTipoAptosPagamentos(params);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesAPagar(params, pageable));
    }

    @GetMapping(value={"/agenda-previsao-pagamentos"})
    public ResponseEntity<Page<LiquidacaoDTO>> findAgendaPagamentos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, LiquidacaoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setTipo("agenda-pagamento");
        params.setIsSomenteComOrdensNaoCanceladas(Boolean.TRUE);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesAPagar(params, pageable));
    }

    @GetMapping(value={"/agenda-previsao-pagamentos/conta"})
    public ResponseEntity<ContaPagamentoDTO> findPagamentoConta(LiquidacaoParams params) {
        return ResponseEntity.ok((Object)this.liquidacaoService.findContaPagamento(params));
    }

    private void setTipoAptosPagamentos(LiquidacaoParams params) {
        if (Objects.isNull(params.getTipo())) {
            params.setTipo("aptos-pagamentos");
        }
    }

    @GetMapping(value={"/aptos-pagamentos/total"})
    public ResponseEntity<LiquidacaoDTO> findAptosPagamentosTotal(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, LiquidacaoParams params) {
        params.setEntidade(entidade);
        this.setTipoAptosPagamentos(params);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.liquidacaoService.findLiquidacoesAPagarTotal(params));
    }
}

