/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContaPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LiquidacaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LiquidacaoRepositoryImpl
implements LiquidacaoRepository {
    private static final Long TIPO_DOC_NOTA_FISCAL = 1L;
    private static final Long TIPO_DOC_NOTA_FISCAL_ELETRONICO = 42L;
    private static final String PAGAS = "pagas";
    private static final String PAGAR = "pagar";
    private static final String SUPRIMENTOS_FUNDOS = "suprimentos-fundos";
    private static final String APTOS_PAGAMENTOS = "aptos-pagamentos";
    private static final String AGENDA_PAGAMENTO = "agenda-pagamento";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquidacaoRepositoryImpl.class);
    private static final String LIQUIDACAO_PAGAR = "db/sql/contab/liquidacao-pagar.sql";
    private static final String LIQUIDACAO_PAGAS = "db/sql/contab/liquidacao-pagas.sql";
    private static final String CONTA_PAGAMENTO = "db/sql/contab/ordempagamento-liquidacao-conta.sql";
    private static final String REPLACE_ROW_NUM = "row_number() OVER (PARTITION BY XX.FONTERECURSO ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO)";
    private static final String ZERO = "0";
    private final DatasourceWrapper datasourceWrapper;
    private final Environment environment;

    @Autowired
    public LiquidacaoRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, Environment environment) {
        this.datasourceWrapper = datasourceWrapper;
        this.environment = environment;
    }

    private String loadSQL(LiquidacaoParams params, String fileSql) {
        String sql = FileUtils.readResourceAsString((String)fileSql);
        if (this.environment.acceptsProfiles(new String[]{"!production"})) {
            sql = sql.replace(REPLACE_ROW_NUM, ZERO);
        }
        if (PAGAR.equals(params.getTipo()) || APTOS_PAGAMENTOS.equals(params.getTipo()) || AGENDA_PAGAMENTO.equals(params.getTipo())) {
            return this.sqlLiquidacoesPagar(params, sql);
        }
        if (PAGAS.equals(params.getTipo()) || SUPRIMENTOS_FUNDOS.equals(params.getTipo())) {
            return this.sqlLiquidacoesPagas(params, sql);
        }
        return "";
    }

    private StringBuilder buildWhere(LiquidacaoParams params) {
        StringBuilder where = new StringBuilder("");
        where.append(" WHERE E.CONTABILIZADO = 'S'");
        if (Objects.nonNull(params.getEntidade())) {
            where.append(" AND E.ENTIDADE = ").append(params.getEntidade());
        }
        params.getCnpjCpf().ifPresent(p -> where.append(" AND (F.CNPJ = '").append((String)params.getCnpjCpf().get()).append("')"));
        params.getNome().ifPresent(p -> where.append(" AND tiraacento(UPPER(F.NOME)) like tiraacento('%").append(((String)params.getNome().get()).toUpperCase(LocaleContextHolder.getLocale()).replaceAll(" ", "%")).append("%') "));
        if (StringUtils.isNotEmpty((String)params.getNotaFiscal())) {
            where.append(" AND EXISTS (SELECT NF.ENTIDADE FROM LIQUIDACAODOCUMENTOS NF").append(" WHERE NF.ENTIDADE = L.ENTIDADE").append(" AND NF.EXERCICIO = L.EXERCICIO").append(" AND NF.EXERCICIOEMPENHO = L.ANODOCORIGEM").append(" AND NF.EMPENHO = L.NODOCORIGEM").append(" AND NF.NOLIQUIDACAO = L.NOLIQUIDACAO").append(" AND NF.NODOCUMENTO = '").append(params.getNotaFiscal()).append("')");
        }
        params.getEmpenho().ifPresent(e -> where.append(String.format(" AND E.EMPENHO = %d", e)));
        if (params.filtrarPorExercicioDoEmpenho()) {
            if (AGENDA_PAGAMENTO.equals(params.getTipo())) {
                where.append(String.format(" AND EXTRACT(YEAR FROM COALESCE(O.VENCIMENTO, L.DATAVENCIMENTO, L.DATA)) = %d ", params.getExercicio().get()));
            } else {
                where.append(String.format(" AND E.EXERCICIO = %d ", params.getExercicio().get()));
            }
        }
        if (params.filtrarPorEmpenhosPendentes()) {
            where.append(String.format(" AND E.EXERCICIO < %d ", params.getExercicio().get()));
        }
        return where;
    }

    private void filterDataLiquidacoesPagar(LiquidacaoParams params, StringBuilder filtro) {
        if (AGENDA_PAGAMENTO.equals(params.getTipo())) {
            if (Objects.nonNull(params.getDataInicial())) {
                filtro.append(" AND (COALESCE(O.VENCIMENTO, L.DATAVENCIMENTO, L.DATA) >= :dataInicial)");
            }
            if (Objects.nonNull(params.getDataFinal())) {
                filtro.append(" AND (COALESCE(O.VENCIMENTO, L.DATAVENCIMENTO, L.DATA) <= :dataFinal)");
            }
        } else {
            if (Objects.nonNull(params.getDataInicial())) {
                filtro.append(" AND (L.DATA >= :dataInicial)");
            }
            if (Objects.nonNull(params.getDataFinal())) {
                filtro.append(" AND (L.DATA <= :dataFinal)");
            }
        }
    }

    private String sqlLiquidacoesPagar(LiquidacaoParams params, String sql) {
        StringBuilder filtro = this.buildWhere(params);
        StringBuilder whereClause = new StringBuilder();
        this.filterDataLiquidacoesPagar(params, filtro);
        if (params.getEmpenhoExercicio().isPresent()) {
            filtro.append(" AND E.EXERCICIO = :empenhoExercicio ");
        }
        if (APTOS_PAGAMENTOS.equals(params.getTipo())) {
            filtro.append(" AND E.TIPOLICITACAO <> '00' ");
        }
        if (Objects.nonNull(params.getIsCovid())) {
            filtro.append(" AND (E.MPCOVID19 = 'S') ");
        }
        filtro.append(" AND L.CONTABILIZADO = 'S' ");
        whereClause.append(" WHERE ");
        if (!params.getIsSomentePagos().booleanValue()) {
            whereClause.append(" XX.SALDO > 0.01 AND ");
        }
        if (params.getIsSomenteComOrdensNaoCanceladas().booleanValue()) {
            whereClause.append(" COALESCE(XX.CANCELADO, 'N') <> 'S' AND ");
        }
        return sql.replace("$[FILTRO]", filtro).replace("$[WHERE]", whereClause);
    }

    private String sqlLiquidacoesPagas(LiquidacaoParams params, String sql) {
        StringBuilder filtro = this.buildWhere(params);
        if (Objects.nonNull(params.getDataInicial())) {
            filtro.append(" AND (P.DATA >= :dataInicial)");
        }
        if (Objects.nonNull(params.getDataFinal())) {
            filtro.append(" AND (P.DATA <= :dataFinal)");
        }
        if (Objects.nonNull(params.getIsCovid())) {
            filtro.append(" AND (E.MPCOVID19 = 'S') ");
        }
        params.getExercicio().ifPresent(exercicio -> filtro.append(String.format(" AND P.EXERCICIO = %d ", exercicio)));
        if (SUPRIMENTOS_FUNDOS.equals(params.getTipo())) {
            filtro.append(" AND E.DESDOBRADESP = '96' ");
            filtro.append(" AND E.SUBDESDOBRAMENTO = '00' ");
        }
        return sql.replace("$[FILTRO]", filtro);
    }

    private void findNotasFiscais(List<LiquidacaoDTO> liquidacoes, LiquidacaoParams params) {
        for (LiquidacaoDTO liquidacao : liquidacoes) {
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct nodocumento as notasFiscais from liquidacaodocumentos");
            sql.append(" where entidade = ").append(params.getEntidade());
            sql.append(" and exercicio = ").append(liquidacao.getExercicioLiquidacao());
            sql.append(" and exercicioempenho = ").append(liquidacao.getExercicio());
            sql.append(" and empenho = ").append(liquidacao.getEmpenho());
            sql.append(" and noliquidacao = ").append(liquidacao.getNoLiquidacao());
            sql.append(" and tipodocumento in (").append(TIPO_DOC_NOTA_FISCAL);
            sql.append(", " + TIPO_DOC_NOTA_FISCAL_ELETRONICO + ")");
            List notas = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class));
            StringBuilder nota = new StringBuilder();
            for (LiquidacaoDTO str : notas) {
                if (nota.length() > 0) {
                    nota.append('-');
                }
                nota.append(str.getNotasFiscais());
            }
            liquidacao.setNotasFiscais(nota.toString());
        }
    }

    private Page<LiquidacaoDTO> execFind(LiquidacaoParams params, String fileSql, Pageable pageable) {
        String sql = this.loadSQL(params, fileSql);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)this.getOrder(params));
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        LOGGER.debug(query);
        LOGGER.debug(params.toString());
        List list = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class));
        this.findNotasFiscais(list, params);
        return new PageImpl(list, pageable, this.quantidadeTotal(params, sql).longValue());
    }

    private String getOrder(LiquidacaoParams params) {
        if (AGENDA_PAGAMENTO.equals(params.getTipo())) {
            return "ORDER BY XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC ";
        }
        String order = "XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC, XX.FONTERECURSO";
        if (PAGAS.equals(params.getTipo()) || SUPRIMENTOS_FUNDOS.equals(params.getTipo())) {
            order = "XX.EXERCICIO DESC, XX.DATA DESC, XX.EMPENHO DESC";
        }
        if (APTOS_PAGAMENTOS.equals(params.getTipo())) {
            order = "XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO";
        }
        return "ORDER BY " + order;
    }

    private Long quantidadeTotal(LiquidacaoParams params, String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }

    private LiquidacaoDTO getTotal(LiquidacaoParams params, String fileSql) {
        String sql = this.loadSQL(params, fileSql);
        StringBuilder sqlTotal = new StringBuilder();
        sqlTotal.append("SELECT SUM(X.VALOR) AS VALOR, SUM(X.SALDO) AS SALDO");
        sqlTotal.append(" FROM (");
        sqlTotal.append(sql);
        sqlTotal.append(") X");
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(LiquidacaoDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(sqlTotal.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst().orElse(new LiquidacaoDTO());
    }

    public Page<LiquidacaoDTO> findLiquidacoesAPagar(LiquidacaoParams params, Pageable pageable) {
        return this.execFind(params, LIQUIDACAO_PAGAR, pageable);
    }

    public Page<LiquidacaoDTO> findLiquidacoesPagas(LiquidacaoParams params, Pageable pageable) {
        return this.execFind(params, LIQUIDACAO_PAGAS, pageable);
    }

    public LiquidacaoDTO findLiquidacoesPagasTotal(LiquidacaoParams params) {
        return this.getTotal(params, LIQUIDACAO_PAGAS);
    }

    public LiquidacaoDTO findLiquidacoesAPagarTotal(LiquidacaoParams params) {
        return this.getTotal(params, LIQUIDACAO_PAGAR);
    }

    public ContaPagamentoDTO findContaPagamento(LiquidacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)CONTA_PAGAMENTO);
        LOGGER.debug(sql);
        LOGGER.debug(params.toString());
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContaPagamentoDTO.class));
        return list.stream().findFirst().orElse(new ContaPagamentoDTO());
    }
}

