/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EmLiquidacaoRepository {
    private static final String EMPENHOS_EM_LIQUIDACAO = "db/sql/contab/empenhoEmLiquidacao.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public EmLiquidacaoRepository(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<EmpenhoEmLiquidacaoDTO> findEmLiquidacao(LiquidacaoParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)EMPENHOS_EM_LIQUIDACAO);
        sql = sql.replace("$[FILTRO]", this.montaFiltro(params));
        List lista = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoEmLiquidacaoDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(SqlUtils.createSQLCount((String)sql), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(lista, pageable, total.longValue());
    }

    private String montaFiltro(LiquidacaoParams params) {
        StringBuilder where = new StringBuilder();
        params.getCnpjCpf().ifPresent(c -> where.append(SqlUtils.andLike((String)"F.CNPJ", (String)c)));
        params.getNome().ifPresent(n -> where.append(SqlUtils.andLike((String)"F.NOME", (String)n)));
        params.getEmpenho().ifPresent(e -> where.append(SqlUtils.andEqual((String)"E.EMPENHO", (Long)e)));
        if (Objects.nonNull(params.getId())) {
            where.append(SqlUtils.andEqual((String)"EL.ID", (Long)params.getId()));
        }
        if (Objects.nonNull(params.getLiquidacao())) {
            where.append(SqlUtils.andEqual((String)"EL.NOEMLIQUIDACAO", (Long)params.getLiquidacao()));
        }
        if (Objects.nonNull(params.getDataInicial())) {
            where.append(" AND EL.DATA >= :dataInicial ");
        }
        if (Objects.nonNull(params.getDataFinal())) {
            where.append(" AND EL.DATA <= :dataFinal ");
        }
        return where.toString();
    }
}

