SELECT S.ENTIDADE,
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
	   S.NUMEROSIT,
       S.TERMO,
       S.LEIAUTORIZATORIA,
	   S.IDTIPO,
       TS.DESCRICAO AS TIPOSUBVENCAO,
       S.ENTIDADEBENEFICIARIA,
       S.NOMEBENEFICIARIO,
       F.CNPJ,
       S.TIPOENTIDADE,
       S.OBJETO,
       S.UNIDADEMEDIDA,
       S.PERIODICIDADEPRESTACAO,
       S.DATATLIMITE,
       S.DATAINICIOCONVENIO,
       S.DATAVENCIMENTOCONVENIO,
       S.ARTIGOLOA,
       S.NRQTDPREVISTA,
       COALESCE(S.VALORPRESTADOEXERCANT, 0) AS VALORPRESTADOEXERCANT,
       COALESCE(S.VALORPREVISTO, 0) AS VALORPREVISTO,
       COALESCE(S.VALORCONTRAPARTIDA, 0) AS VALORCONTRAPARTIDA,
       S.DATACELEBRACAO,
       S.DATAPRAZOFINAL,
       S.VEICULOPUBLICACAO,
       S.DATAPUBLICACAO,
       S.NREDICAOPUBLICACAO,
       S.CONTADEBITO,
       S.CONTACREDITO,
       S.ANOLEIAUTORIZATORIA,
       S.PROGRAMATICA,
       S.FONTERECURSO,
       COALESCE((SELECT SUM(VALORPAGAMENTO - VALORESTPAGAMENTO + VALORRETENCOES)
          FROM EMPENHO 
         WHERE ENTIDADE     = S.ENTIDADE
           AND EXERCICIO    = S.EXERCICIO
           AND SUBVENCAO    = S.SUBVENCAO
           AND ANOSUBVENCAO = S.ANOSUBVENCAO),0) AS VALORLIBERADO,
       COALESCE(S.VALORPREVISTO - (SELECT SUM(VALORPAGAMENTO - VALORESTPAGAMENTO + VALORRETENCOES)
                                     FROM EMPENHO 
                                    WHERE ENTIDADE     = S.ENTIDADE
                                      AND EXERCICIO    = S.EXERCICIO
                                      AND SUBVENCAO    = S.SUBVENCAO
                                      AND ANOSUBVENCAO = S.ANOSUBVENCAO), 0) AS SALDO,
      (SELECT DISTINCT D.DESCRICAO
         FROM DESPESA D, 
              NIVEISMODELODESPESA N
        WHERE CAST(SUBSTR(D.PROGRAMATICA, N.POSICAO, N.TAMANHO) AS VARCHAR(80)) = S.ORGAO
          AND D.ENTIDADE      = S.ENTIDADE
          AND D.EXERCICIO     = S.EXERCICIO
          AND D.MODELODESPESA = N.MODELODESPESA
          AND D.TIPO          = N.TIPO
          AND D.NIVEL         = N.ORDEM
          AND N.NIVELLEI      = 'O') ORGAO
  FROM SUBVENCAOSOCIAL S  
  JOIN TIPOSUBVENCAO TS  
    ON TS.ID = S.IDTIPO
  LEFT JOIN FORNECEDOR F
    ON F.FORNECEDOR = S.ENTIDADEBENEFICIARIA
 WHERE S.ENTIDADE  = :entidade
   AND S.EXERCICIO = :exercicio