SELECT EL.ID, 
       EL.ENTIDADE,
       EL.EXERCICIO,
       EL.NOEMLIQUIDACAO, 
       EL.NODOCORIGEM,
       EL.ANODOCORIGEM,
       EL.HISTORICOOBS AS HISTORICO,
       E.FORNECEDOR,
       F.NOME AS NOMEFORNECEDOR,
       F.CNPJ,
       EL.DATA,
       EL.DATAVENCIMENTO,
       COALESCE(EL.VALOR, 0) AS VALOR,
       COALESCE(EL.VALORESTEMLIQUIDACAO, 0) AS VALORESTORNADO,
       COALESCE(EL.VALORLIQUIDADO, 0) AS VALORLIQUIDADO,
       SUM(FE.VALOR) - SUM(FE.VALORANULACOES) - SUM(FE.VALORESTANULACOES) AS VALOREMPENHO
  FROM EMLIQUIDACAO EL
  JOIN EMPENHO E 
    ON E.ENTIDADE = EL.ENTIDADE
   AND E.EXERCICIO = EL.ANODOCORIGEM
   AND E.EMPENHO = EL.NODOCORIGEM
  LEFT JOIN FICHAEMPENHO FE
    ON FE.ENTIDADE = EL.ENTIDADE
   AND FE.EXERCICIO = EL.ANODOCORIGEM
   AND FE.EMPENHO = EL.NODOCORIGEM
  LEFT JOIN FORNECEDOR F
    ON F.FORNECEDOR = E.FORNECEDOR
 WHERE EL.ENTIDADE = :entidade
   AND EL.EXERCICIO = :exercicio
   $[FILTRO]
   AND EL.CONTABILIZADO = 'S'
 GROUP BY EL.ENTIDADE, EL.EXERCICIO, EL.NOEMLIQUIDACAO, EL.NODOCORIGEM, 
          EL.ANODOCORIGEM, EL.HISTORICOOBS, EL.DATA, EL.DATAVENCIMENTO, 
          EL.VALOR, EL.VALORESTEMLIQUIDACAO, EL.VALORLIQUIDADO, EL.ID,
          E.FORNECEDOR, F.NOME, F.CNPJ
 ORDER BY EL.NOEMLIQUIDACAO