/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioDetalheDTO;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PatrimonioLocalNiveisModClafRepository {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public PatrimonioLocalNiveisModClafRepository(@Qualifier(value="dataSource") DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public List<PatrimonioDetalheDTO> findByLocalAtualEntidadeAndModelo(String localAtual, Long entidade, String modelo) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT B.DESCRICAO AS DESCRICAONIVEL, ");
        sql.append(" ( SELECT C.DESCRICAO FROM PAT_LOCALCLASSIFICACAO C ");
        sql.append(" WHERE C.ENTIDADE = B.ENTIDADE ");
        sql.append(" AND C.MODELO = B.MODELO ");
        sql.append(" AND C.NIVEL = B.NIVEL ");
        sql.append(" AND (SUBSTR(C.CLASSIFICACAO, 1, ( SELECT SUM(X.TAMANHO) FROM PAT_LOCALNIVEISMODCLAF X ");
        sql.append(" WHERE X.ENTIDADE = B.ENTIDADE ");
        sql.append(" AND X.MODELO = B.MODELO ");
        sql.append("  AND X.NIVEL <= B.NIVEL ))) = ");
        sql.append(" (SUBSTR('");
        sql.append(localAtual);
        sql.append("', 1, ( SELECT SUM(X.TAMANHO) FROM PAT_LOCALNIVEISMODCLAF X ");
        sql.append(" WHERE X.ENTIDADE = B.ENTIDADE ");
        sql.append(" AND X.MODELO = B.MODELO ");
        sql.append(" AND X.NIVEL <= B.NIVEL )))) AS DESCRICAOLOCAL ");
        sql.append(" FROM PAT_LOCALNIVEISMODCLAF B WHERE B.ENTIDADE = ");
        sql.append(entidade);
        sql.append(" AND B.MODELO = ");
        sql.append(modelo);
        sql.append(" ORDER BY B.NIVEL ");
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new BeanPropertyRowMapper(PatrimonioDetalheDTO.class));
    }
}

