/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.portaltransparencia.contabportal.domain.Veiculo;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoListDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.PatrimonioBemToDTO;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;

public class VeiculoToDTO
implements Converter<Veiculo, VeiculoListDTO>,
Function<Veiculo, VeiculoListDTO> {
    public VeiculoListDTO convert(Veiculo veiculo) {
        VeiculoListDTO veiculoDto = new VeiculoListDTO();
        if (Objects.nonNull(veiculo.getCentroCusto())) {
            veiculoDto.setCentroCusto(veiculo.getCentroCusto().getDescricao());
        }
        veiculoDto.setChassi(veiculo.getChassi());
        veiculoDto.setDescricao(veiculo.getDescricao());
        veiculoDto.setChapa(veiculo.getId().getChapa());
        veiculoDto.setDataAquisicao(veiculo.getDataAquisicao());
        if (Objects.nonNull(veiculo.getLetraPlaca()) && Objects.nonNull(veiculo.getNumeroPlaca())) {
            veiculoDto.setPlaca(veiculo.getLetraPlaca() + veiculo.getNumeroPlaca());
        }
        veiculoDto.setRenavan(veiculo.getRenavan());
        if (Objects.nonNull(veiculo.getId())) {
            veiculoDto.setVeiculo(veiculo.getId().getBem());
        }
        if (Objects.nonNull(veiculo.getBem())) {
            veiculoDto.setBem(new PatrimonioBemToDTO().convert(veiculo.getBem()));
        }
        return veiculoDto;
    }

    @Override
    public VeiculoListDTO apply(Veiculo veiculo) {
        return this.convert(veiculo);
    }
}

