/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.admportal.service.TemplateService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidade;
import br.com.elotech.portaltransparencia.contabportal.domain.QPortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MenuDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoGrupoEntidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.enums.MenuEnum;
import br.com.elotech.portaltransparencia.enums.MenuItem;
import br.com.elotech.portaltransparencia.enums.MenuItemImpl;
import br.com.elotech.portaltransparencia.enums.TipoAcessoInformacao;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private static final Long ZERO = 0L;
    private static final String WEBSERVICE = "1";
    private final PublicacaoGrupoEntidadeRepository publicacaoGrupoEntidadeRepository;
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeContabilidadeService entidadeContabilidadeService;
    private final TemplateService templateService;
    private List<PortalParametroContabil> listParametro = new ArrayList();
    private Long idMenuDTO = ZERO;
    private Boolean menuTemplate;
    @Value(value="${elotech.sistemaSaude.enabled:false}")
    private Boolean sistemaSaude;

    @Autowired
    public MenuService(PublicacaoGrupoEntidadeRepository publicacaoGrupoEntidadeRepository, PortalParametroRepository portalParametroRepository, EntidadeContabilidadeService entidadeContabilidadeService, TemplateService templateService) {
        this.entidadeContabilidadeService = entidadeContabilidadeService;
        this.portalParametroRepository = portalParametroRepository;
        this.publicacaoGrupoEntidadeRepository = publicacaoGrupoEntidadeRepository;
        this.templateService = templateService;
    }

    private MenuDTO getMontaMenu(Long idMenu, MenuItem menuEnum, Boolean flagParam) {
        MenuDTO menuDTO = new MenuDTO();
        this.idMenuDTO = this.idMenuDTO + 1L;
        menuDTO.setId(this.idMenuDTO);
        menuDTO.setTitle(menuEnum.getTitulo());
        menuDTO.setSubtitle(menuEnum.getSubTitulo());
        menuDTO.setRoute(menuEnum.getRota());
        menuDTO.setImage(menuEnum.getIcone());
        menuDTO.setAtalho(menuEnum.getAtalho());
        if (Objects.nonNull(menuEnum.getParametroLink())) {
            PortalParametroContabil link = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, menuEnum.getParametroLink());
            menuDTO.setLink(this.safeGetValueParametro(link));
        }
        if (ZERO.equals(idMenu)) {
            return menuDTO;
        }
        PortalParametroContabil portalParametro = this.listParametro.stream().filter(p -> p.getIdParametro().equals(idMenu)).findFirst().orElse(null);
        if (flagParam.booleanValue() || SimNao.SIM.getSigla().equals(this.safeGetValueParametro(portalParametro)) || idMenu.equals(Parametros.PARAM_WEBSERVICE_MARINGA) && WEBSERVICE.equals(this.safeGetValueParametro(portalParametro))) {
            return menuDTO;
        }
        return null;
    }

    private MenuDTO getMontaMenu(Long idMenu, MenuItem menuEnum) {
        return this.getMontaMenu(idMenu, menuEnum, Boolean.valueOf(false));
    }

    private MenuDTO addMenu(List<MenuDTO> menu, Long idMenu, MenuItem menuEnum) {
        MenuDTO menuDTO = this.getMontaMenu(idMenu, menuEnum);
        if (menuDTO != null) {
            menu.add(menuDTO);
        }
        return menuDTO;
    }

    public List<MenuDTO> getMenu(Long entidade, Long exercicio) {
        BooleanExpression parametroNoExercicio = QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)entidade).and((Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)exercicio));
        Iterable list = this.portalParametroRepository.findAll((Predicate)parametroNoExercicio.or((Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)ZERO)));
        this.listParametro = Lists.newArrayList((Iterable)list);
        Entidade entidadeObj = this.entidadeContabilidadeService.findOne(entidade);
        List pubGrupos = this.publicacaoGrupoEntidadeRepository.findByIdEntidadeIdAndMostraAcessoRapidoAndMostraWeb(entidade);
        this.idMenuDTO = ZERO;
        ArrayList<MenuDTO> menu = new ArrayList();
        this.buildMenuAcessoInformacao(menu);
        this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.DASHBOARD);
        this.buildMenuPessoal(menu);
        this.buildMenuCovid(menu, exercicio);
        this.buildMenuLicitacoesAdministracao(menu);
        this.buildMenuFornecedores(menu);
        this.buildMenuExecucaoDespesa(menu, entidadeObj);
        this.buildMenuExecucaoReceita(menu, entidadeObj, exercicio);
        this.buildMenuLeisAtos(menu, entidadeObj);
        this.buildMenuPublicacoes(menu, pubGrupos);
        this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.LEIS_REGEM_PORTAL);
        this.addMenu(menu, Parametros.PARAM_PLANEJAMENTOS, (MenuItem)MenuEnum.ORCAMENTO);
        this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.ORGANOGRAMA);
        this.addMenu(menu, Parametros.PARAM_PERGUNTASFREQUENTES, (MenuItem)MenuEnum.PERGUNTAS_FREQUENTES);
        this.addMenu(menu, Parametros.PARAM_LINKS_UTEIS, (MenuItem)MenuEnum.LINKS_UTEIS);
        this.addMenu(menu, Parametros.PARAM_AVALIACAO_PPA, (MenuItem)MenuEnum.AVALIACAO_PPA);
        this.addMenu(menu, Parametros.PARAM_MOSTRA_SUBVENCOES, (MenuItem)MenuEnum.SUBVENCAO);
        this.buildMenuSaude(menu);
        menu = this.limpaSubMenusSemItens(menu);
        if (this.menuTemplate.booleanValue()) {
            return this.templateService.generateTemplateByEntidadeExercicio(entidade, exercicio, menu);
        }
        return menu;
    }

    private void buildMenuAcessoInformacao(List<MenuDTO> menu) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.ACESSO_INFORMACAO);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        PortalParametroContabil parametroContato = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_FORMULARIO_MENSAGEM);
        List subMenuDto = menuDTO.getSubMenu();
        if (TipoAcessoInformacao.PROTOCOLO_WEB.getValue().equals(this.safeGetValueParametro(parametroContato))) {
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.ESIC);
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.ESIC_ESTATISTICA);
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.SIC_CONSULTA);
        } else if (TipoAcessoInformacao.ESIC_PROPRIO.getValue().equals(this.safeGetValueParametro(parametroContato))) {
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.ESIC_PROPRIO);
        }
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.SIC_FISICO);
    }

    private void buildMenuPessoal(List<MenuDTO> menu) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.PESSOAL);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_SERVIDORES, (MenuItem)MenuEnum.PESSOAL_SERVIDORES);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.PESSOAL_SERVIDORES_APOSENTADOS);
        this.addMenu(subMenuDto, Parametros.PARAM_CEDIDOS, (MenuItem)MenuEnum.PESSOAL_CEDIDOS);
        this.addMenu(subMenuDto, Parametros.PARAM_DIARIAS, (MenuItem)MenuEnum.PESSOAL_DIARIAS);
        this.addMenu(subMenuDto, Parametros.PARAM_ADIANTAMENTO, (MenuItem)MenuEnum.PESSOAL_ADIANTAMENTO_REEMBOLSO);
        this.addMenu(subMenuDto, Parametros.PARAM_CARGOS, (MenuItem)MenuEnum.PESSOAL_CARGOS);
        this.addMenu(subMenuDto, Parametros.PARAM_AJUDA_CUSTO, (MenuItem)MenuEnum.PESSOAL_AJUDA_CUSTO);
        this.addMenu(subMenuDto, Parametros.PARAM_LEISEATOS, (MenuItem)MenuEnum.LEIS_ATOS_PESSOAL);
        this.addMenu(subMenuDto, Parametros.PARAM_WEBSERVICE_MARINGA, (MenuItem)MenuEnum.PESSOAL_HORA_EXTRA);
        this.addMenu(subMenuDto, Parametros.PARAM_WEBSERVICE_MARINGA, (MenuItem)MenuEnum.PESSOAL_SERVIDORES_PERMUTA);
    }

    private void buildMenuCovid(List<MenuDTO> menu, Long exercicio) {
        PortalParametroContabil parametroPublicacaoCovid;
        PortalParametroContabil parametroExecucaoDespesaCovid;
        PortalParametroContabil parametroReceitasCovid;
        PortalParametroContabil parametroContatoAtasCovid;
        PortalParametroContabil parametroLicitacaoCovid;
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.COVID19);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        PortalParametroContabil parametroServidoresCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_SERVIDORES_COVID);
        if (this.safeGetValueParametro(parametroServidoresCovid).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_SERVIDORES_COVID, (MenuItem)MenuEnum.COVID19_SERVIDORES);
        }
        if (this.safeGetValueParametro(parametroLicitacaoCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_LICITACAO_COVID)).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_LICITACAO_COVID, (MenuItem)MenuEnum.COVID19_LICITACOES);
        }
        if (this.safeGetValueParametro(parametroContatoAtasCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_CONTRATO_ATAS_COVID)).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_CONTRATO_ATAS_COVID, (MenuItem)MenuEnum.COVID19_CONTRATOS_ATAS);
        }
        if (this.safeGetValueParametro(parametroReceitasCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_RECEITAS_COVID)).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_RECEITAS_COVID, (MenuItem)MenuEnum.COVID19_RECEITAS);
        }
        if (this.safeGetValueParametro(parametroExecucaoDespesaCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_EXECUCAO_DESPESA_COVID)).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_EXECUCAO_DESPESA_COVID, (MenuItem)MenuEnum.COVID19_EMPENHADAS);
            this.addMenu(subMenuDto, Parametros.PARAM_EXECUCAO_DESPESA_COVID, (MenuItem)MenuEnum.COVID19_LIQUIDADAS);
            this.addMenu(subMenuDto, Parametros.PARAM_EXECUCAO_DESPESA_COVID, (MenuItem)MenuEnum.COVID19_PAGAS);
        }
        if (this.safeGetValueParametro(parametroPublicacaoCovid = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, exercicio, Parametros.PARAM_PUBLICACAO_COVID)).equals("S")) {
            this.addMenu(subMenuDto, Parametros.PARAM_PUBLICACAO_COVID, (MenuItem)MenuEnum.COVID19_PUBLICACOES);
        }
    }

    private void buildMenuLicitacoesAdministracao(List<MenuDTO> menu) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_LICITACOES, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_LICITACOES);
        this.addMenu(subMenuDto, Parametros.PARAM_CONVENIOS, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_CONVENIOS);
        this.addMenu(subMenuDto, Parametros.PARAM_CONTRATOS, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_CONTRATOS_ATAS);
        this.addMenu(subMenuDto, Parametros.PARAM_PATRIMONIO, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_PATRIMONIO);
        this.addMenu(subMenuDto, Parametros.PARAM_OBRASPUBLICAS, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_OBRAS_PUBLICAS);
        this.addMenu(subMenuDto, Parametros.PARAM_ALMOXARIFADO_POSICAO, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_ALMOXARIFADO_POSICAO);
        this.addMenu(subMenuDto, Parametros.PARAM_ALMOXARIFADO_CONSUMO, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_ALMOXARIFADO_CONSUMO);
        this.addMenu(subMenuDto, Parametros.PARAM_VEICULOS, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_VEICULOS);
        this.addMenu(subMenuDto, Parametros.PARAM_MOVIMENTACAO_GARAGEM, (MenuItem)MenuEnum.LICITACOES_ADMINISTRACAO_GARAGEM);
        this.addMenu(subMenuDto, Parametros.PARAM_LICITACOES_PARTICIPANTES, (MenuItem)MenuEnum.LICITACOES_PARTICIPANTES);
    }

    private void buildMenuFornecedores(List<MenuDTO> menu) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.FORNECEDORES);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.FORNECEDORES_EMPENHO);
        this.addMenu(subMenuDto, Parametros.PARAM_EM_LIQUIDACAO, (MenuItem)MenuEnum.EM_LIQUIDACAO);
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.LIQUIDACOES);
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.LIQUIDACOES_PAGAS);
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.FORNECEDORES_A_PAGAR);
        this.addMenu(subMenuDto, Parametros.PARAM_COMPRASDIRETAS, (MenuItem)MenuEnum.COMPRAS_DIRETAS_FORNECEDOR);
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.APTOS_PAGAMENTOS);
        this.addMenu(subMenuDto, Parametros.PARAM_AGENDA_PREVISAO_PAGAMENTO, (MenuItem)MenuEnum.AGENDA_PREVISAO_PAGAMENTO);
        this.addMenu(subMenuDto, Parametros.PARAM_NOTAS_EXTRAS, (MenuItem)MenuEnum.NOTAS_EXTRAORCAMENTARIAS);
    }

    private void buildMenuExecucaoDespesa(List<MenuDTO> menu, Entidade entidadeObj) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_EXECUCAO_DESPESA, (MenuItem)MenuEnum.EXECUCAO_DESPESA);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_COMPRASDIRETAS, (MenuItem)MenuEnum.COMPRAS_DIRETA_ITENS);
        this.addMenu(subMenuDto, Parametros.PARAM_EMPENHOS, (MenuItem)MenuEnum.SUPRIMENTOS_FUNDOS);
        this.addMenu(subMenuDto, Parametros.PARAM_REPASSES, (MenuItem)MenuEnum.EXECUCAO_DESPESA_REPASSES);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESAS);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_ORGAO);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_FUNCAO);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_PROGRAMA);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_PROJETO);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_ELEMENTO);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_FONTE_RECURSO);
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_DESPESA_POR_ESFERA_ADMINISTRATIVA);
        if (Objects.nonNull(entidadeObj) && !EntidadeTipo.LEGISLATIVO.getValue().equals(entidadeObj.getTipo().getValue())) {
            this.addMenu(subMenuDto, Parametros.PARAM_LEI_ATOS_CONTABIL, (MenuItem)MenuEnum.LEIS_ATOS_DESPESA);
        }
    }

    private void buildMenuExecucaoReceita(List<MenuDTO> menu, Entidade entidadeObj, Long exercicio) {
        if (Objects.nonNull(entidadeObj)) {
            PortalParametroContabil parametroMedidasAdotadas;
            MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_EXECUCAO_RECEITA, (MenuItem)MenuEnum.EXECUCAO_RECEITA);
            if (Objects.isNull(menuDTO)) {
                return;
            }
            List subMenuDto = menuDTO.getSubMenu();
            this.addMenu(subMenuDto, Parametros.PARAM_DIVIDAATIVA, (MenuItem)MenuEnum.EXECUCAO_RECEITA_DIVIDA_ATIVA);
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_RECEITA_RECEITA);
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_RECEITA_DETALHADA);
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.EXECUCAO_RECEITA_POR_FONTE_RECURSO);
            this.addMenu(subMenuDto, Parametros.PARAM_REPASSES, (MenuItem)MenuEnum.EXECUCAO_RECEITA_REPASSES);
            if (!EntidadeTipo.LEGISLATIVO.getValue().equals(entidadeObj.getTipo().getValue())) {
                this.addMenu(subMenuDto, Parametros.PARAM_LEI_ATOS_CONTABIL, (MenuItem)MenuEnum.LEIS_ATOS_RECEITA);
            }
            if (StringUtils.isNotBlank((String)this.safeGetValueParametro(parametroMedidasAdotadas = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidadeObj.getId(), exercicio, Parametros.PARAM_IDARQUIVO_MEDIDAS_ADOTADAS)))) {
                this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.MEDIDAS_ADOTADAS_COBRANCA);
            }
            this.addMenu(subMenuDto, Parametros.PARAM_MOSTRA_ALVARAS, (MenuItem)MenuEnum.ALVARAS);
        }
    }

    private void buildMenuLeisAtos(List<MenuDTO> menu, Entidade entidadeObj) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.LEIS_ATOS);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_LEISEATOS, (MenuItem)MenuEnum.LEIS_ATOS_GERAIS);
        if (Objects.nonNull(entidadeObj) && !EntidadeTipo.LEGISLATIVO.getValue().equals(entidadeObj.getTipo().getValue())) {
            this.addMenu(subMenuDto, Parametros.PARAM_LEI_ATOS_CONTABIL, (MenuItem)MenuEnum.LEIS_ATOS_DESPESA);
            this.addMenu(subMenuDto, Parametros.PARAM_LEI_ATOS_CONTABIL, (MenuItem)MenuEnum.LEIS_ATOS_RECEITA);
        }
        this.addMenu(subMenuDto, Parametros.PARAM_LEISEATOS, (MenuItem)MenuEnum.LEIS_ATOS_PESSOAL);
        this.addMenu(subMenuDto, Parametros.PARAM_LEI_ATOS_CONTABIL, (MenuItem)MenuEnum.LEIS_ATOS_CREDITOSADICIONAIS);
    }

    private void buildMenuPublicacoes(List<MenuDTO> menu, List<PublicacaoGrupoEntidade> pubGrupos) {
        MenuDTO menuDTO = this.addMenu(menu, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.PUBLICACOES);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        List subMenuDto = menuDTO.getSubMenu();
        this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)MenuEnum.PUBLICACOES);
        for (PublicacaoGrupoEntidade pubGrupo : pubGrupos) {
            PublicacaoGrupo grupo = pubGrupo.getId().getGrupo();
            String rota = String.format("/publicacoes/%d", grupo.getId());
            String descricao = grupo.getDescricao();
            MenuItemImpl menuItem = new MenuItemImpl(descricao, descricao, rota, "fa fa-newspaper-o", "");
            this.addMenu(subMenuDto, Parametros.PARAM_GERAL, (MenuItem)menuItem);
        }
    }

    private void buildMenuSaude(List<MenuDTO> menu) {
        MenuDTO menuDTO = this.getMontaMenu(Parametros.NAO_USA_PARAMETRO, (MenuItem)MenuEnum.SAUDE, this.sistemaSaude);
        if (Objects.isNull(menuDTO)) {
            return;
        }
        menu.add(menuDTO);
        List subMenuDto = menuDTO.getSubMenu();
        menuDTO = this.getMontaMenu(Parametros.NAO_USA_PARAMETRO, (MenuItem)MenuEnum.SAUDE_FILA_ESPERA_ATENDIMENTO, this.sistemaSaude);
        if (Objects.nonNull(menuDTO)) {
            subMenuDto.add(menuDTO);
        }
    }

    private List<MenuDTO> limpaSubMenusSemItens(List<MenuDTO> menu) {
        ArrayList<MenuDTO> menuAux = new ArrayList<MenuDTO>();
        for (MenuDTO menuDTO : menu) {
            if (menuDTO.getRoute().equals("/") && menuDTO.getSubMenu().isEmpty()) continue;
            menuAux.add(menuDTO);
        }
        return menuAux;
    }

    public Boolean getMenuTemplate() {
        return this.menuTemplate;
    }

    @Value(value="${elotech.menuTemplate.enabled:false}")
    public void setMenuTemplate(Boolean menuTemplate) {
        this.menuTemplate = menuTemplate;
    }

    private String safeGetValueParametro(PortalParametroContabil parametro) {
        if (Objects.isNull(parametro)) {
            return "";
        }
        return parametro.getValor();
    }
}

