/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.admportal.domain.Orcamento;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PortalOrcamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PortalOrcamentoParams;
import br.com.elotech.portaltransparencia.contabportal.service.PortalOrcamentoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/orcamentos", "/admin/orcamentos"})
public class PortalOrcamentoResource {
    private final PortalOrcamentoService portalOrcamentoService;

    public PortalOrcamentoResource(PortalOrcamentoService portalOrcamentoService) {
        this.portalOrcamentoService = portalOrcamentoService;
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<PortalOrcamentoDTO>> findOrcamentos(PortalOrcamentoParams params) {
        return ResponseEntity.ok((Object)this.portalOrcamentoService.findOrcamentos(params));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Orcamento> findOne(@PathVariable Long id) {
        Orcamento found = this.portalOrcamentoService.findOne(id);
        if (Objects.isNull(found)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)found);
    }

    private Page<Orcamento> getOrcamentos(PortalOrcamentoParams params, Pageable pageable) {
        if (params.getExercicio().isPresent()) {
            return this.portalOrcamentoService.findByEntidadeIdAndExercicio(params, pageable);
        }
        return this.portalOrcamentoService.findByEntidadeId((Long)params.getEntidade().get(), pageable);
    }

    @GetMapping(params={"entidade"})
    public ResponseEntity<Page<Orcamento>> findByEntidade(PortalOrcamentoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.getOrcamentos(params, pageable));
    }

    @PostMapping
    public ResponseEntity<Orcamento> save(@RequestBody Orcamento orcamento) throws URISyntaxException {
        return ResponseEntity.created((URI)new URI("")).body((Object)this.portalOrcamentoService.save(orcamento));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Orcamento> update(@RequestBody Orcamento orcamento, @PathVariable Long id) {
        Orcamento orcamentoFound = this.portalOrcamentoService.findOne(id);
        if (Objects.isNull(orcamentoFound)) {
            throw RestException.notFound();
        }
        return ResponseEntity.ok((Object)this.portalOrcamentoService.save(orcamento));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        Orcamento orcamento = this.portalOrcamentoService.findOne(id);
        if (Objects.isNull(orcamento)) {
            return ResponseEntity.notFound().build();
        }
        this.portalOrcamentoService.remove(orcamento);
        return ResponseEntity.ok().build();
    }
}

