/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.QuadroPessoalService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/quadro-pessoal"})
public class QuadroPessoalResource {
    private final IntegracaoOxyFolhaPagamentoService integracaoOxyFolhaPagamentoService;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;
    private final QuadroPessoalService quadroPessoalService;

    public QuadroPessoalResource(IntegracaoOxyFolhaPagamentoService integracaoOxyFolhaPagamentoService, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, BaseExport baseExport, QuadroPessoalService quadroPessoalService) {
        this.integracaoOxyFolhaPagamentoService = integracaoOxyFolhaPagamentoService;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.baseExport = baseExport;
        this.quadroPessoalService = quadroPessoalService;
    }

    @GetMapping(params={"competencia"})
    public ResponseEntity<List<QuadroPessoalDTO>> findQuadroPessoal(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.integracaoOxyFolhaPagamentoService.findQuadroPessoal(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findLeisAtosExport(HttpServletRequest request, HttpServletResponse response, @Valid CargoParams params, Pageable pageable) throws Throwable {
        params.setExercicio(params.getExercicio());
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page quadrosPessoal = this.quadroPessoalService.findQuadrosPessoal(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Quadro de Pessoal");
        reportParam.setClazzDTO(QuadroPessoalDTO.class);
        reportParam.setHeaderFields("Tipo Cargo,Vagas Criadas,Vagas Ocupadas,Vagas Dispon\u00edveis");
        reportParam.setFields("tipoCargo,vagasCriadas,vagasOcupadas,vagasDisponiveis");
        float[] fieldsPerc = new float[]{1.0f, 0.7f, 0.5f, 2.0f, 0.7f, 1.0f, 2.8f, 1.3f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{30, 10, 10, 500, 15, 50, 1000, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(quadrosPessoal.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

