/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CedidoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/cedidos"})
@CrossOrigin
public class CedidoResource {
    private final CedidoService service;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public CedidoResource(CedidoService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.service = service;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<CedidoDTO>> findCedidos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid FindCedidoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findCedidos(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findCedidosExport(HttpServletRequest request, HttpServletResponse response, @Valid FindCedidoParams params, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.service.findCedidos(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Servidores %s", this.getDescricaoTipo(params.getTipoMovimentacao(), params.getCedenteFinalizado())));
        reportParam.setClazzDTO(CedidoDTO.class);
        reportParam.setHeaderFields("Matricula,Nome,Entidade,N\u00famero do Ato,Ano do Ato,Tipo do Ato");
        reportParam.setFields("matricula,nome,localCedido,numeroAto,anoAto,tipoAto");
        float[] fieldsPerc = new float[]{2.0f, 4.0f, 4.0f, 2.0f, 2.0f, 4.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 100, 100, 20, 20, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private String getDescricaoTipo(Long tipoMovimentacao, Boolean finalizados) {
        Long cedidosDE = 90L;
        if (cedidosDE.equals(tipoMovimentacao) && !finalizados.booleanValue()) {
            return "Cedidos DE";
        }
        Long cedidosPARA = 23L;
        if (cedidosPARA.equals(tipoMovimentacao) && !finalizados.booleanValue()) {
            return "Cedidos PARA";
        }
        if (cedidosDE.equals(tipoMovimentacao)) {
            return "Cedidos DE (Finalizados)";
        }
        if (cedidosPARA.equals(tipoMovimentacao)) {
            return "Cedidos PARA (Finalizados)";
        }
        return "Cedidos";
    }
}

