/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.domain.dto;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosFinanceirosDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class EstagiarioDTO {
    private static final String TIME_FORMAT = "HH:mm";
    private static final String HORARIO_ZERADO = "00:00";
    private static final String HORARIO_NULO = "--:--";
    private Long entidade;
    private String nome;
    private Long codigo;
    private String lotacao;
    private String localTrabalho;
    private LocalDateTime horarioEntrada;
    private LocalDateTime horarioSaidaIntervalo;
    private LocalDateTime horarioEntradaIntervalo;
    private LocalDateTime horarioSaida;
    private String cargo;
    private BigDecimal horasSemanais;
    private String faixa;
    private LocalDate inicioContrato;
    private LocalDate terminoContrato;
    private String horarioTrabalho;
    private List<ServidorDadosFinanceirosDTO> dadosFinanceiros;
    private BigDecimal valorFaixa;
    private Long matricula;
    private String descricaoCargo;
    private String descricaoClasse;
    private String descricaoNatureza;
    private String descricaoLotacao;
    private String situacao;
    private String vinculo;
    private LocalDate dataAdmissao;
    private LocalDate dataDemissao;
    private String postoTrabalho;
    private String planoSalarial;
    private BigDecimal cargaHorariaMensal = BigDecimal.ZERO;
    private BigDecimal salarioBase;
    private LocalDate dataFimContrato;

    public String getHorarioEntradaFormated() {
        if (Objects.nonNull(this.horarioEntrada)) {
            return this.horarioEntrada.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioSaidaIntervaloFormated() {
        if (Objects.nonNull(this.horarioSaidaIntervalo)) {
            return this.horarioSaidaIntervalo.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioEntradaIntervaloFormated() {
        if (Objects.nonNull(this.horarioEntradaIntervalo)) {
            return this.horarioEntradaIntervalo.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioSaidaFormated() {
        if (Objects.nonNull(this.horarioSaida)) {
            return this.horarioSaida.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioTrabalho() {
        if (Objects.isNull(this.horarioEntrada) && Objects.isNull(this.horarioSaidaIntervalo) && Objects.isNull(this.horarioEntradaIntervalo) && Objects.isNull(this.horarioSaida)) {
            return this.horarioTrabalho;
        }
        if ((this.getHorarioEntradaIntervaloFormated().equals(HORARIO_ZERADO) || this.getHorarioEntradaIntervaloFormated().equals(HORARIO_NULO)) && (this.getHorarioSaidaFormated().equals(HORARIO_ZERADO) || this.getHorarioSaidaFormated().equals(HORARIO_NULO))) {
            return String.format("%s \u00e0s %s", this.getHorarioEntradaFormated(), this.getHorarioSaidaIntervaloFormated());
        }
        return String.format("%s \u00e0s %s - %s \u00e0s %s", this.getHorarioEntradaFormated(), this.getHorarioSaidaIntervaloFormated(), this.getHorarioEntradaIntervaloFormated(), this.getHorarioSaidaFormated());
    }

    public Long getCodigo() {
        return Optional.ofNullable(this.codigo).orElse(this.matricula);
    }

    public String getCargo() {
        return Optional.ofNullable(this.cargo).orElse(this.descricaoCargo);
    }

    public String getLotacao() {
        return Optional.ofNullable(this.lotacao).orElse(this.descricaoLotacao);
    }

    public LocalDate getInicioContrato() {
        return Optional.ofNullable(this.inicioContrato).orElse(this.dataAdmissao);
    }

    public LocalDate getDataDemissao() {
        return this.dataFimContrato;
    }

    public LocalDate getTerminoContrato() {
        return Optional.ofNullable(this.terminoContrato).orElse(this.dataFimContrato);
    }

    public BigDecimal getValorFaixa() {
        if (Objects.nonNull(this.valorFaixa) && this.valorFaixa.compareTo(BigDecimal.ZERO) > 0) {
            return this.valorFaixa;
        }
        return Optional.ofNullable(this.salarioBase).orElse(BigDecimal.ZERO);
    }

    @Generated
    public static EstagiarioDTOBuilder builder() {
        return new EstagiarioDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    @Generated
    public LocalDateTime getHorarioEntrada() {
        return this.horarioEntrada;
    }

    @Generated
    public LocalDateTime getHorarioSaidaIntervalo() {
        return this.horarioSaidaIntervalo;
    }

    @Generated
    public LocalDateTime getHorarioEntradaIntervalo() {
        return this.horarioEntradaIntervalo;
    }

    @Generated
    public LocalDateTime getHorarioSaida() {
        return this.horarioSaida;
    }

    @Generated
    public BigDecimal getHorasSemanais() {
        return this.horasSemanais;
    }

    @Generated
    public String getFaixa() {
        return this.faixa;
    }

    @Generated
    public List<ServidorDadosFinanceirosDTO> getDadosFinanceiros() {
        return this.dadosFinanceiros;
    }

    @Generated
    public Long getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getDescricaoCargo() {
        return this.descricaoCargo;
    }

    @Generated
    public String getDescricaoClasse() {
        return this.descricaoClasse;
    }

    @Generated
    public String getDescricaoNatureza() {
        return this.descricaoNatureza;
    }

    @Generated
    public String getDescricaoLotacao() {
        return this.descricaoLotacao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getVinculo() {
        return this.vinculo;
    }

    @Generated
    public LocalDate getDataAdmissao() {
        return this.dataAdmissao;
    }

    @Generated
    public String getPostoTrabalho() {
        return this.postoTrabalho;
    }

    @Generated
    public String getPlanoSalarial() {
        return this.planoSalarial;
    }

    @Generated
    public BigDecimal getCargaHorariaMensal() {
        return this.cargaHorariaMensal;
    }

    @Generated
    public BigDecimal getSalarioBase() {
        return this.salarioBase;
    }

    @Generated
    public LocalDate getDataFimContrato() {
        return this.dataFimContrato;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Generated
    public void setLocalTrabalho(String localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    @Generated
    public void setHorarioEntrada(LocalDateTime horarioEntrada) {
        this.horarioEntrada = horarioEntrada;
    }

    @Generated
    public void setHorarioSaidaIntervalo(LocalDateTime horarioSaidaIntervalo) {
        this.horarioSaidaIntervalo = horarioSaidaIntervalo;
    }

    @Generated
    public void setHorarioEntradaIntervalo(LocalDateTime horarioEntradaIntervalo) {
        this.horarioEntradaIntervalo = horarioEntradaIntervalo;
    }

    @Generated
    public void setHorarioSaida(LocalDateTime horarioSaida) {
        this.horarioSaida = horarioSaida;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setHorasSemanais(BigDecimal horasSemanais) {
        this.horasSemanais = horasSemanais;
    }

    @Generated
    public void setFaixa(String faixa) {
        this.faixa = faixa;
    }

    @Generated
    public void setInicioContrato(LocalDate inicioContrato) {
        this.inicioContrato = inicioContrato;
    }

    @Generated
    public void setTerminoContrato(LocalDate terminoContrato) {
        this.terminoContrato = terminoContrato;
    }

    @Generated
    public void setHorarioTrabalho(String horarioTrabalho) {
        this.horarioTrabalho = horarioTrabalho;
    }

    @Generated
    public void setDadosFinanceiros(List<ServidorDadosFinanceirosDTO> dadosFinanceiros) {
        this.dadosFinanceiros = dadosFinanceiros;
    }

    @Generated
    public void setValorFaixa(BigDecimal valorFaixa) {
        this.valorFaixa = valorFaixa;
    }

    @Generated
    public void setMatricula(Long matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setDescricaoCargo(String descricaoCargo) {
        this.descricaoCargo = descricaoCargo;
    }

    @Generated
    public void setDescricaoClasse(String descricaoClasse) {
        this.descricaoClasse = descricaoClasse;
    }

    @Generated
    public void setDescricaoNatureza(String descricaoNatureza) {
        this.descricaoNatureza = descricaoNatureza;
    }

    @Generated
    public void setDescricaoLotacao(String descricaoLotacao) {
        this.descricaoLotacao = descricaoLotacao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setVinculo(String vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setDataAdmissao(LocalDate dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    @Generated
    public void setDataDemissao(LocalDate dataDemissao) {
        this.dataDemissao = dataDemissao;
    }

    @Generated
    public void setPostoTrabalho(String postoTrabalho) {
        this.postoTrabalho = postoTrabalho;
    }

    @Generated
    public void setPlanoSalarial(String planoSalarial) {
        this.planoSalarial = planoSalarial;
    }

    @Generated
    public void setCargaHorariaMensal(BigDecimal cargaHorariaMensal) {
        this.cargaHorariaMensal = cargaHorariaMensal;
    }

    @Generated
    public void setSalarioBase(BigDecimal salarioBase) {
        this.salarioBase = salarioBase;
    }

    @Generated
    public void setDataFimContrato(LocalDate dataFimContrato) {
        this.dataFimContrato = dataFimContrato;
    }

    @Generated
    public EstagiarioDTO(Long entidade, String nome, Long codigo, String lotacao, String localTrabalho, LocalDateTime horarioEntrada, LocalDateTime horarioSaidaIntervalo, LocalDateTime horarioEntradaIntervalo, LocalDateTime horarioSaida, String cargo, BigDecimal horasSemanais, String faixa, LocalDate inicioContrato, LocalDate terminoContrato, String horarioTrabalho, List<ServidorDadosFinanceirosDTO> dadosFinanceiros, BigDecimal valorFaixa, Long matricula, String descricaoCargo, String descricaoClasse, String descricaoNatureza, String descricaoLotacao, String situacao, String vinculo, LocalDate dataAdmissao, LocalDate dataDemissao, String postoTrabalho, String planoSalarial, BigDecimal cargaHorariaMensal, BigDecimal salarioBase, LocalDate dataFimContrato) {
        this.entidade = entidade;
        this.nome = nome;
        this.codigo = codigo;
        this.lotacao = lotacao;
        this.localTrabalho = localTrabalho;
        this.horarioEntrada = horarioEntrada;
        this.horarioSaidaIntervalo = horarioSaidaIntervalo;
        this.horarioEntradaIntervalo = horarioEntradaIntervalo;
        this.horarioSaida = horarioSaida;
        this.cargo = cargo;
        this.horasSemanais = horasSemanais;
        this.faixa = faixa;
        this.inicioContrato = inicioContrato;
        this.terminoContrato = terminoContrato;
        this.horarioTrabalho = horarioTrabalho;
        this.dadosFinanceiros = dadosFinanceiros;
        this.valorFaixa = valorFaixa;
        this.matricula = matricula;
        this.descricaoCargo = descricaoCargo;
        this.descricaoClasse = descricaoClasse;
        this.descricaoNatureza = descricaoNatureza;
        this.descricaoLotacao = descricaoLotacao;
        this.situacao = situacao;
        this.vinculo = vinculo;
        this.dataAdmissao = dataAdmissao;
        this.dataDemissao = dataDemissao;
        this.postoTrabalho = postoTrabalho;
        this.planoSalarial = planoSalarial;
        this.cargaHorariaMensal = cargaHorariaMensal;
        this.salarioBase = salarioBase;
        this.dataFimContrato = dataFimContrato;
    }

    @Generated
    public EstagiarioDTO() {
    }

    @Generated
    public String toString() {
        return "EstagiarioDTO(nome=" + this.getNome() + ", codigo=" + this.getCodigo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstagiarioDTO)) {
            return false;
        }
        EstagiarioDTO other = (EstagiarioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EstagiarioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

