/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.contabilidade.client.RealizacaoReceitaFeignClient;
import br.com.elotech.contabilidade.client.ReceitaFeignClient;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.orcamento.client.PPAFeignClient;
import br.com.elotech.orcamento.client.dto.ReceitaPadraoTCEDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.dto.ReceitaSaldoLoadedDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;

public class ReceitaOxyRepositoryImpl
implements ReceitaRepository {
    private static final String PR = "PR";
    private static final Long TIPO_OPERACAO_RECEITA = 1L;
    private final PPAFeignClient ppaFeignClient;
    private final ReceitaFeignClient receitaFeignClient;
    private final RealizacaoReceitaFeignClient realizacaoReecitaFeignClient;

    public List<ReceitaDTO> findReceitas(FindReceitaParams params) {
        return this.createReceitaByNivel(params, this.sumValores());
    }

    public List<ReceitaDTO> findReceitasDetalhada(FindReceitaParams params) {
        return this.createReceitaByNivel(params, this.sumValoresDetalhado());
    }

    public List<ReceitaDTO> findReceitasPorFonteRecurso(FindReceitaParams params) {
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio());
        ArrayList receitasDTO = new ArrayList();
        saldos.forEach(saldo -> {
            ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getReceita().equals(saldo.getFonteRecurso().getCodigo())).findFirst().orElseGet(() -> {
                ReceitaDTO newDTO = new ReceitaDTO();
                newDTO.setReceita(saldo.getFonteRecurso().getCodigo());
                newDTO.setDescricao(saldo.getFonteRecurso().getDescricao());
                receitasDTO.add(newDTO);
                return newDTO;
            });
            this.sumValores().apply(saldo, receita);
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    public List<ReceitaDTO> findDetalheReceitasPorFonteRecurso(FindReceitaParams params) {
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio());
        ArrayList receitasDTO = new ArrayList();
        saldos.stream().filter(s -> s.getFonteRecurso().getCodigo().equals(((Long)params.getFonteRecurso().get()).toString())).forEach(saldo -> {
            ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getReceita().equals(saldo.getReceita().getFormattedCodigoWithoutZeros())).findFirst().orElseGet(() -> {
                ReceitaDTO newDTO = new ReceitaDTO();
                newDTO.setReceita(saldo.getReceita().getFormattedCodigoWithoutZeros());
                newDTO.setDescricao(saldo.getReceita().getDescricao());
                receitasDTO.add(newDTO);
                return newDTO;
            });
            this.sumValores().apply(saldo, receita);
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    public List<ReceitaDTO> findReceitaValoresDia(FindReceitaParams params) {
        List<ReceitaSaldoLoadedDTO> saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio()).stream().filter(s -> s.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).collect(Collectors.toList());
        ArrayList receitasDTO = new ArrayList();
        saldos.forEach(saldo -> {
            params.getDataFinal().ifPresent(dataFinal -> saldo.setReceitaSaldoDatas(saldo.getReceitaSaldoDatas().stream().filter(s -> DateUtils.isBeforeOrEquals((LocalDate)s.getData(), (LocalDate)dataFinal)).collect(Collectors.toList())));
            params.getDataInicial().ifPresent(dataInicial -> saldo.setReceitaSaldoDatas(saldo.getReceitaSaldoDatas().stream().filter(s -> DateUtils.isAfterOrEquals((LocalDate)s.getData(), (LocalDate)dataInicial)).collect(Collectors.toList())));
            saldo.getReceitaSaldoDatas().forEach(saldoData -> {
                ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getData().equals(saldoData.getData())).findFirst().orElseGet(() -> {
                    ReceitaDTO newDTO = new ReceitaDTO();
                    newDTO.setData(saldoData.getData());
                    receitasDTO.add(newDTO);
                    return newDTO;
                });
                receita.setValorArrecadado(receita.getValorArrecadado().add(saldoData.getValores().getRealizado()));
            });
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    public List<RealizacaoReceitaDTO> findReceitaValoresRazao(FindReceitaParams params) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List realizoesReceitas = this.realizacaoReecitaFeignClient.findAllRealizacaoReceitaByDate(params.getEntidade(), params.getExercicio(), LocalDate.parse(params.getData(), dtf), LocalDate.parse(params.getData(), dtf));
        ArrayList<RealizacaoReceitaDTO> receitasDTO = new ArrayList<RealizacaoReceitaDTO>();
        realizoesReceitas.forEach(r -> r.getItens().stream().filter(rFilter -> rFilter.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).forEach(item -> {
            RealizacaoReceitaDTO receita = new RealizacaoReceitaDTO();
            receita.setLancamento(r.getEventoLancamento().getId());
            receita.setData(r.getData());
            receita.setDescricao(item.getEventoConfig().getDescricao());
            receita.setBanco(r.getContaBancaria().getAgencia().getBanco().getCodigo());
            receita.setAgencia(r.getContaBancaria().getAgencia().getCodigo());
            receita.setConta(r.getContaBancaria().getConta());
            if (TIPO_OPERACAO_RECEITA.equals(item.getReceita().getTipoOperacaoReceita().getId())) {
                receita.setValor(item.getValor());
            } else {
                receita.setValor(item.getValor().multiply(BigDecimal.valueOf(-1L)));
            }
            receitasDTO.add(receita);
        }));
        return receitasDTO;
    }

    public Optional<ReceitaDTO> findReceita(FindReceitaParams params) {
        ReceitaSaldoLoadedDTO saldo = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio()).stream().filter(s -> s.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).findFirst().orElse(new ReceitaSaldoLoadedDTO());
        br.com.elotech.contabilidade.client.dto.ReceitaDTO receiaDTO = Optional.ofNullable(saldo.getReceita()).orElse(new br.com.elotech.contabilidade.client.dto.ReceitaDTO());
        ReceitaDTO newDTO = new ReceitaDTO();
        newDTO.setReceita(receiaDTO.getCodigo());
        newDTO.setDescricao(receiaDTO.getDescricao());
        return Optional.of(newDTO);
    }

    public List<ReceitaDTO> findReceitaValorMes(FindReceitaParams params) {
        return Collections.emptyList();
    }

    private List<ReceitaDTO> createReceitaByNivel(FindReceitaParams params, BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValores) {
        List receitasTCE = this.ppaFeignClient.findAllReceitasPadraoByUfAndDataBetween(PR, DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)params.getExercicio().intValue()), DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)params.getExercicio().intValue()));
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio());
        ArrayList receitasDTO = new ArrayList();
        saldos.forEach(saldo -> {
            List<String> niveisReceita = Arrays.asList(saldo.getReceita().getFormattedCodigoWithoutZeros().split("\\."));
            StringBuilder codigo = new StringBuilder();
            for (int i = 0; i < niveisReceita.size(); ++i) {
                Long nivelReceita = i + 1;
                codigo.append(niveisReceita.get(i));
                ReceitaDTO receitaDTO = receitasDTO.stream().filter(r -> nivelReceita.equals(r.getNivel()) && r.getReceita().startsWith(codigo.toString())).findFirst().orElseGet(() -> {
                    ReceitaPadraoTCEDTO receitaTCE = receitasTCE.stream().filter(tce -> tce.getNivel().equals(nivelReceita) && tce.getCodigo().startsWith(codigo.toString())).findFirst().orElse(new ReceitaPadraoTCEDTO());
                    ReceitaDTO newDTO = ReceitaDTO.ofReceitaTCE((ReceitaPadraoTCEDTO)receitaTCE, (String)codigo.toString());
                    receitasDTO.add(newDTO);
                    return newDTO;
                });
                sumValores.apply((ReceitaSaldoLoadedDTO)saldo, receitaDTO);
            }
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    private BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValores() {
        return (saldo, receita) -> {
            receita.setValorArrecadado(receita.getValorArrecadado().add(saldo.getValorArrecadado()));
            receita.setValorAtualizado(receita.getValorAtualizado().add(saldo.getValorAtualizado()));
            receita.setValorOrcado(receita.getValorOrcado().add(saldo.getValorOrcado()));
            return null;
        };
    }

    private BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValoresDetalhado() {
        return (saldo, receita) -> {
            if (TIPO_OPERACAO_RECEITA.equals(saldo.getReceita().getTipoOperacaoReceita().getId())) {
                receita.setValorOrcado(receita.getValorOrcado().add(saldo.getValorOrcado()));
                receita.setValorAtualizado(receita.getValorAtualizado().add(saldo.getValorAtualizado()));
                receita.setValorArrecadado(receita.getValorArrecadado().add(saldo.getValorArrecadado()));
                receita.setValorRealizadoLiquido(receita.getValorRealizadoLiquido().add(saldo.getValorArrecadado()));
            } else {
                receita.setValorDeducaoInicial(receita.getValorDeducaoInicial().add(saldo.getValorOrcado()));
                receita.setValorAtualizado(receita.getValorAtualizado().subtract(saldo.getValorAtualizado()));
                receita.setValorDeducao(receita.getValorDeducao().add(saldo.getValorArrecadado()));
                receita.setValorRealizadoLiquido(receita.getValorRealizadoLiquido().add(saldo.getValorArrecadado()));
            }
            return null;
        };
    }

    @Generated
    public ReceitaOxyRepositoryImpl(PPAFeignClient ppaFeignClient, ReceitaFeignClient receitaFeignClient, RealizacaoReceitaFeignClient realizacaoReecitaFeignClient) {
        this.ppaFeignClient = ppaFeignClient;
        this.receitaFeignClient = receitaFeignClient;
        this.realizacaoReecitaFeignClient = realizacaoReecitaFeignClient;
    }
}

