/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.orcamento.client.dto.ReceitaPadraoTCEDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class ReceitaDTO {
    private String receita = "";
    private String descricao;
    private Long nivel;
    private Long inicio;
    private Long tamanho;
    private Integer mes;
    private String aceitaMovimentacao;
    private BigDecimal valorOrcado = BigDecimal.ZERO;
    private BigDecimal valorAtualizado = BigDecimal.ZERO;
    private BigDecimal valorArrecadado = BigDecimal.ZERO;
    private BigDecimal valorEmpenhado = BigDecimal.ZERO;
    private LocalDate data;
    private BigDecimal repasseRecebido = BigDecimal.ZERO;
    private BigDecimal repasseConcedido = BigDecimal.ZERO;
    private BigDecimal valorDeducaoInicial = BigDecimal.ZERO;
    private BigDecimal valorDeducao = BigDecimal.ZERO;
    private BigDecimal valorRealizadoLiquido = BigDecimal.ZERO;

    public static ReceitaDTO ofReceitaTCE(ReceitaPadraoTCEDTO receitaTCE, String codigo) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setReceita(codigo);
        receita.setDescricao(receitaTCE.getDescricao());
        receita.setAceitaMovimentacao(SimNao.fromBoolean((Boolean)receitaTCE.getAdmiteMovimento()));
        receita.setNivel(receitaTCE.getNivel());
        return receita;
    }

    public BigDecimal getValorOrcado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorOrcado);
    }

    public BigDecimal getValorAtualizado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorAtualizado);
    }

    public BigDecimal getValorArrecadado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorArrecadado);
    }

    public BigDecimal getValorEmpenhado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorEmpenhado);
    }

    public BigDecimal getValorDeducaoInicial() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorDeducaoInicial);
    }

    public BigDecimal getValorDeducao() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorDeducao);
    }

    public BigDecimal getValorRealizadoLiquido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorRealizadoLiquido);
    }

    @Generated
    public ReceitaDTO() {
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getNivel() {
        return this.nivel;
    }

    @Generated
    public Long getInicio() {
        return this.inicio;
    }

    @Generated
    public Long getTamanho() {
        return this.tamanho;
    }

    @Generated
    public Integer getMes() {
        return this.mes;
    }

    @Generated
    public String getAceitaMovimentacao() {
        return this.aceitaMovimentacao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public BigDecimal getRepasseRecebido() {
        return this.repasseRecebido;
    }

    @Generated
    public BigDecimal getRepasseConcedido() {
        return this.repasseConcedido;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setNivel(Long nivel) {
        this.nivel = nivel;
    }

    @Generated
    public void setInicio(Long inicio) {
        this.inicio = inicio;
    }

    @Generated
    public void setTamanho(Long tamanho) {
        this.tamanho = tamanho;
    }

    @Generated
    public void setMes(Integer mes) {
        this.mes = mes;
    }

    @Generated
    public void setAceitaMovimentacao(String aceitaMovimentacao) {
        this.aceitaMovimentacao = aceitaMovimentacao;
    }

    @Generated
    public void setValorOrcado(BigDecimal valorOrcado) {
        this.valorOrcado = valorOrcado;
    }

    @Generated
    public void setValorAtualizado(BigDecimal valorAtualizado) {
        this.valorAtualizado = valorAtualizado;
    }

    @Generated
    public void setValorArrecadado(BigDecimal valorArrecadado) {
        this.valorArrecadado = valorArrecadado;
    }

    @Generated
    public void setValorEmpenhado(BigDecimal valorEmpenhado) {
        this.valorEmpenhado = valorEmpenhado;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setRepasseRecebido(BigDecimal repasseRecebido) {
        this.repasseRecebido = repasseRecebido;
    }

    @Generated
    public void setRepasseConcedido(BigDecimal repasseConcedido) {
        this.repasseConcedido = repasseConcedido;
    }

    @Generated
    public void setValorDeducaoInicial(BigDecimal valorDeducaoInicial) {
        this.valorDeducaoInicial = valorDeducaoInicial;
    }

    @Generated
    public void setValorDeducao(BigDecimal valorDeducao) {
        this.valorDeducao = valorDeducao;
    }

    @Generated
    public void setValorRealizadoLiquido(BigDecimal valorRealizadoLiquido) {
        this.valorRealizadoLiquido = valorRealizadoLiquido;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceitaDTO)) {
            return false;
        }
        ReceitaDTO other = (ReceitaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !this$receita.equals(other$receita)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        Long this$nivel = this.getNivel();
        Long other$nivel = other.getNivel();
        if (this$nivel == null ? other$nivel != null : !((Object)this$nivel).equals(other$nivel)) {
            return false;
        }
        Long this$inicio = this.getInicio();
        Long other$inicio = other.getInicio();
        if (this$inicio == null ? other$inicio != null : !((Object)this$inicio).equals(other$inicio)) {
            return false;
        }
        Long this$tamanho = this.getTamanho();
        Long other$tamanho = other.getTamanho();
        if (this$tamanho == null ? other$tamanho != null : !((Object)this$tamanho).equals(other$tamanho)) {
            return false;
        }
        Integer this$mes = this.getMes();
        Integer other$mes = other.getMes();
        if (this$mes == null ? other$mes != null : !((Object)this$mes).equals(other$mes)) {
            return false;
        }
        String this$aceitaMovimentacao = this.getAceitaMovimentacao();
        String other$aceitaMovimentacao = other.getAceitaMovimentacao();
        if (this$aceitaMovimentacao == null ? other$aceitaMovimentacao != null : !this$aceitaMovimentacao.equals(other$aceitaMovimentacao)) {
            return false;
        }
        BigDecimal this$valorOrcado = this.getValorOrcado();
        BigDecimal other$valorOrcado = other.getValorOrcado();
        if (this$valorOrcado == null ? other$valorOrcado != null : !((Object)this$valorOrcado).equals(other$valorOrcado)) {
            return false;
        }
        BigDecimal this$valorAtualizado = this.getValorAtualizado();
        BigDecimal other$valorAtualizado = other.getValorAtualizado();
        if (this$valorAtualizado == null ? other$valorAtualizado != null : !((Object)this$valorAtualizado).equals(other$valorAtualizado)) {
            return false;
        }
        BigDecimal this$valorArrecadado = this.getValorArrecadado();
        BigDecimal other$valorArrecadado = other.getValorArrecadado();
        if (this$valorArrecadado == null ? other$valorArrecadado != null : !((Object)this$valorArrecadado).equals(other$valorArrecadado)) {
            return false;
        }
        BigDecimal this$valorEmpenhado = this.getValorEmpenhado();
        BigDecimal other$valorEmpenhado = other.getValorEmpenhado();
        if (this$valorEmpenhado == null ? other$valorEmpenhado != null : !((Object)this$valorEmpenhado).equals(other$valorEmpenhado)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        BigDecimal this$repasseRecebido = this.getRepasseRecebido();
        BigDecimal other$repasseRecebido = other.getRepasseRecebido();
        if (this$repasseRecebido == null ? other$repasseRecebido != null : !((Object)this$repasseRecebido).equals(other$repasseRecebido)) {
            return false;
        }
        BigDecimal this$repasseConcedido = this.getRepasseConcedido();
        BigDecimal other$repasseConcedido = other.getRepasseConcedido();
        if (this$repasseConcedido == null ? other$repasseConcedido != null : !((Object)this$repasseConcedido).equals(other$repasseConcedido)) {
            return false;
        }
        BigDecimal this$valorDeducaoInicial = this.getValorDeducaoInicial();
        BigDecimal other$valorDeducaoInicial = other.getValorDeducaoInicial();
        if (this$valorDeducaoInicial == null ? other$valorDeducaoInicial != null : !((Object)this$valorDeducaoInicial).equals(other$valorDeducaoInicial)) {
            return false;
        }
        BigDecimal this$valorDeducao = this.getValorDeducao();
        BigDecimal other$valorDeducao = other.getValorDeducao();
        if (this$valorDeducao == null ? other$valorDeducao != null : !((Object)this$valorDeducao).equals(other$valorDeducao)) {
            return false;
        }
        BigDecimal this$valorRealizadoLiquido = this.getValorRealizadoLiquido();
        BigDecimal other$valorRealizadoLiquido = other.getValorRealizadoLiquido();
        return !(this$valorRealizadoLiquido == null ? other$valorRealizadoLiquido != null : !((Object)this$valorRealizadoLiquido).equals(other$valorRealizadoLiquido));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceitaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        Long $nivel = this.getNivel();
        result = result * 59 + ($nivel == null ? 43 : ((Object)$nivel).hashCode());
        Long $inicio = this.getInicio();
        result = result * 59 + ($inicio == null ? 43 : ((Object)$inicio).hashCode());
        Long $tamanho = this.getTamanho();
        result = result * 59 + ($tamanho == null ? 43 : ((Object)$tamanho).hashCode());
        Integer $mes = this.getMes();
        result = result * 59 + ($mes == null ? 43 : ((Object)$mes).hashCode());
        String $aceitaMovimentacao = this.getAceitaMovimentacao();
        result = result * 59 + ($aceitaMovimentacao == null ? 43 : $aceitaMovimentacao.hashCode());
        BigDecimal $valorOrcado = this.getValorOrcado();
        result = result * 59 + ($valorOrcado == null ? 43 : ((Object)$valorOrcado).hashCode());
        BigDecimal $valorAtualizado = this.getValorAtualizado();
        result = result * 59 + ($valorAtualizado == null ? 43 : ((Object)$valorAtualizado).hashCode());
        BigDecimal $valorArrecadado = this.getValorArrecadado();
        result = result * 59 + ($valorArrecadado == null ? 43 : ((Object)$valorArrecadado).hashCode());
        BigDecimal $valorEmpenhado = this.getValorEmpenhado();
        result = result * 59 + ($valorEmpenhado == null ? 43 : ((Object)$valorEmpenhado).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        BigDecimal $repasseRecebido = this.getRepasseRecebido();
        result = result * 59 + ($repasseRecebido == null ? 43 : ((Object)$repasseRecebido).hashCode());
        BigDecimal $repasseConcedido = this.getRepasseConcedido();
        result = result * 59 + ($repasseConcedido == null ? 43 : ((Object)$repasseConcedido).hashCode());
        BigDecimal $valorDeducaoInicial = this.getValorDeducaoInicial();
        result = result * 59 + ($valorDeducaoInicial == null ? 43 : ((Object)$valorDeducaoInicial).hashCode());
        BigDecimal $valorDeducao = this.getValorDeducao();
        result = result * 59 + ($valorDeducao == null ? 43 : ((Object)$valorDeducao).hashCode());
        BigDecimal $valorRealizadoLiquido = this.getValorRealizadoLiquido();
        result = result * 59 + ($valorRealizadoLiquido == null ? 43 : ((Object)$valorRealizadoLiquido).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReceitaDTO(receita=" + this.getReceita() + ", descricao=" + this.getDescricao() + ", nivel=" + this.getNivel() + ", inicio=" + this.getInicio() + ", tamanho=" + this.getTamanho() + ", mes=" + this.getMes() + ", aceitaMovimentacao=" + this.getAceitaMovimentacao() + ", valorOrcado=" + this.getValorOrcado() + ", valorAtualizado=" + this.getValorAtualizado() + ", valorArrecadado=" + this.getValorArrecadado() + ", valorEmpenhado=" + this.getValorEmpenhado() + ", data=" + this.getData() + ", repasseRecebido=" + this.getRepasseRecebido() + ", repasseConcedido=" + this.getRepasseConcedido() + ", valorDeducaoInicial=" + this.getValorDeducaoInicial() + ", valorDeducao=" + this.getValorDeducao() + ", valorRealizadoLiquido=" + this.getValorRealizadoLiquido() + ")";
    }
}

