/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.DespesaDTO;
import br.com.elotech.contabilidade.client.dto.DotacaoDTO;
import br.com.elotech.contabilidade.client.dto.FonteRecursoDTO;
import br.com.elotech.contabilidade.client.dto.FuncaoDTO;
import br.com.elotech.contabilidade.client.dto.ProgramaDTO;
import br.com.elotech.contabilidade.client.dto.ProjetoAtividadeDTO;
import br.com.elotech.contabilidade.client.dto.UnidadeDTO;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.dto.DotacaoSaldoLoadedDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class DespesaPorNivelDTO {
    public static final String ESFERA_ADMINISTRATIVA = "EA";
    public static final String FONTE_RECURSO = "FR";
    private static final String NATUREZA_DESPESA = "N";
    private static final String PROJETO_ATIVIDADE = "PA";
    private static final String PROGRAMA = "P";
    private static final String ORGAO = "O";
    private static final String FUNCAO = "F";
    private String codigo;
    private String descricao;
    private BigDecimal valorOrcado;
    private BigDecimal valorEmpenhado;
    private BigDecimal valorLiquidado;
    private BigDecimal valorRetido;
    private BigDecimal valorPago;

    public static DespesaPorNivelDTO ofDTO(DotacaoSaldoLoadedDTO dto, String tipo) {
        DespesaPorNivelDTO despesa = new DespesaPorNivelDTO();
        despesa.setDescricao(DespesaPorNivelDTO.getDescricaoByNivelProgramatica((DotacaoSaldoLoadedDTO)dto, (String)tipo));
        despesa.setCodigo(DespesaPorNivelDTO.getCodigoByNivelProgramatica((DotacaoSaldoLoadedDTO)dto, (String)tipo));
        return despesa;
    }

    public static String getCodigoByNivelProgramatica(DotacaoSaldoLoadedDTO dotacaoSaldo, String tipo) {
        DotacaoDTO dotacao = Optional.ofNullable(dotacaoSaldo.getDotacao()).orElse(new DotacaoDTO());
        if ("F".equals(tipo)) {
            return Optional.ofNullable(dotacao.getFuncao()).orElse(new FuncaoDTO()).getCodigo();
        }
        if ("O".equals(tipo)) {
            return Optional.ofNullable(Optional.ofNullable(dotacao.getUnidade()).orElse(new UnidadeDTO()).getUnidadeSuperior()).orElse(new UnidadeDTO()).getCodigo();
        }
        if ("P".equals(tipo)) {
            return Optional.ofNullable(dotacao.getPrograma()).orElse(new ProgramaDTO()).getCodigo();
        }
        if ("PA".equals(tipo)) {
            return Optional.ofNullable(dotacao.getProjetoAtividade()).orElse(new ProjetoAtividadeDTO()).getCodigo();
        }
        if ("N".equals(tipo)) {
            return Optional.ofNullable(dotacao.getDespesa()).orElse(new DespesaDTO()).getFormattedCodigo();
        }
        if ("FR".equals(tipo)) {
            return Optional.ofNullable(dotacaoSaldo.getFonteRecurso()).orElse(new FonteRecursoDTO()).getCodigo();
        }
        return "";
    }

    public static String getDescricaoByNivelProgramatica(DotacaoSaldoLoadedDTO dotacaoSaldo, String tipo) {
        DotacaoDTO dotacao = Optional.ofNullable(dotacaoSaldo.getDotacao()).orElse(new DotacaoDTO());
        if ("F".equals(tipo)) {
            return Optional.ofNullable(dotacao.getFuncao()).orElse(new FuncaoDTO()).getDescricao();
        }
        if ("O".equals(tipo)) {
            return Optional.ofNullable(Optional.ofNullable(dotacao.getUnidade()).orElse(new UnidadeDTO()).getUnidadeSuperior()).orElse(new UnidadeDTO()).getDescricao();
        }
        if ("P".equals(tipo)) {
            return Optional.ofNullable(dotacao.getPrograma()).orElse(new ProgramaDTO()).getDescricao();
        }
        if ("PA".equals(tipo)) {
            return Optional.ofNullable(dotacao.getProjetoAtividade()).orElse(new ProjetoAtividadeDTO()).getDescricao();
        }
        if ("N".equals(tipo)) {
            return Optional.ofNullable(dotacao.getDescricao()).orElse("");
        }
        if ("FR".equals(tipo)) {
            return Optional.ofNullable(dotacaoSaldo.getFonteRecurso()).orElse(new FonteRecursoDTO()).getDescricao();
        }
        if ("EA".equals(tipo) && Objects.nonNull(dotacao.getEsfera())) {
            return dotacao.getEsfera().getDescricao();
        }
        return "";
    }

    @JsonIgnore
    public Long getCodigoLong() {
        if (!this.codigo.isEmpty()) {
            return Long.valueOf(this.codigo);
        }
        return 0L;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getValorOrcado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorOrcado);
    }

    public void setValorOrcado(BigDecimal valorOrcado) {
        this.valorOrcado = valorOrcado;
    }

    public BigDecimal getValorEmpenhado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorEmpenhado);
    }

    public void setValorEmpenhado(BigDecimal valorEmpenhado) {
        this.valorEmpenhado = valorEmpenhado;
    }

    public BigDecimal getValorLiquidado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorLiquidado);
    }

    public void setValorLiquidado(BigDecimal valorLiquidado) {
        this.valorLiquidado = valorLiquidado;
    }

    public BigDecimal getValorRetido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorRetido);
    }

    public void setValorRetido(BigDecimal valorRetido) {
        this.valorRetido = valorRetido;
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorPago);
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }
}

