SELECT A.ENTIDADE,
       A.ANODOCORIGEM AS EXERCICIO,
       A.NODOCORIGEM AS EMPENHO,
       A.UNIDADEDOCORIGEM AS UNIDADEORCAMENTARIA,
       PAG.EXERCICIO AS EXERCICIOPAGAMENTO,
       PAG.NOPAGAMENTO,
       A.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       PAG.DATA,
       A.VALOR,
       OP.CANCELADO AS SITUACAO,
       CASE WHEN CB.BANCO IS NULL THEN CB1.BANCO ELSE CB.BANCO END AS BANCO,
       CASE WHEN CB.AGENCIA IS NULL THEN CB1.AGENCIA ELSE CB.AGENCIA END AS AGENCIA,
       CASE WHEN CB.CONTA IS NULL THEN CB1.CONTA ELSE CB.CONTA END AS CONTA,
       TD.DESCRICAO AS TIPODOCUMENTO,
       PAG.NRODOCUMENTO
 FROM PAGAMENTO PAG
 LEFT OUTER JOIN ORDEMPAGAMENTO_LIQUIDACAO A
   ON A.ENTIDADE = PAG.ENTIDADE
  AND A.EXERCICIO = PAG.ANOORDEMPAGAMENTO
  AND A.NOORDEM = PAG.NOORDEMPAGAMENTO
 LEFT OUTER JOIN ORDEMPAGAMENTO OP
   ON A.ENTIDADE = OP.ENTIDADE
  AND A.EXERCICIO = OP.EXERCICIO
  AND A.NOORDEM = OP.NOORDEM
 LEFT OUTER JOIN TIPODOCUMENTO TD
   ON PAG.TIPO = TD.TIPODOCUMENTO

 LEFT OUTER JOIN CONTACORRENTE CC
   ON PAG.ENTIDADE = CC.ENTIDADE
  AND PAG.IDCONTACORRENTE = CC.IDCONTACORRENTE
 LEFT OUTER JOIN CONTABANCARIAVINCULO CBV
   ON CC.ENTIDADE = CBV.ENTIDADE
  AND CC.IDCONTABANCARIAVINCULO = CBV.ID
 LEFT OUTER JOIN CONTABANCARIA CB1
   ON PAG.ENTIDADE = CB1.ENTIDADE
  AND CBV.REDUZIDO = CB1.REDUZIDO

 LEFT OUTER JOIN PLANO P
   ON PAG.ENTIDADE = P.ENTIDADE
  AND PAG.EXERCICIO = P.EXERCICIO
  AND PAG.CONTADEBITO = P.CONTA
 LEFT OUTER JOIN CONTABILCONTABANCO CCB
   ON P.ENTIDADE = CCB.ENTIDADE
  AND P.EXERCICIO = CCB.EXERCICIO
  AND P.CONTA = CCB.CONTACONTABIL
 LEFT OUTER JOIN CONTABANCARIA CB
   ON CCB.ENTIDADE = CB.ENTIDADE
  AND CCB.REDUZIDO = CB.REDUZIDO

LEFT OUTER JOIN EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA  