/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.utils;

import br.com.elotech.core.utils.NumberUtils;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SqlUtils {
    private static final String ORACLE = "ORACLE";
    private static final String H2 = "H2";
    private static final String POSTGRES = "POSTGRES";

    private SqlUtils() {
    }

    public static String toSqlLike(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            String trimed = str.trim().replaceAll("  ", " ");
            StringBuilder sqlLike = new StringBuilder().append("%").append(trimed.replace(' ', '%')).append("%");
            return sqlLike.toString();
        }
        return null;
    }

    public static String aplicaPaginacao(Pageable pageable, String sql, String platform) {
        StringBuilder query = new StringBuilder();
        if (pageable.getPageSize() > 0 && pageable.getPageNumber() > -1) {
            if (SqlUtils.isPostgres((String)platform) || SqlUtils.isH2((String)platform)) {
                query.append(sql).append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
            } else if (SqlUtils.isOracle((String)platform)) {
                long fim = pageable.getOffset() + (long)pageable.getPageSize();
                query.append("SELECT * FROM (SELECT R.*, ROWNUM AS RN FROM (").append(sql).append(String.format(") R WHERE ROWNUM <= %d) v WHERE V.RN > %d", fim, pageable.getOffset()));
            }
        }
        return query.toString();
    }

    public static String aplicaOrdenacao(Pageable pageable, String sql, String defaultOrderBy) {
        StringBuilder query = new StringBuilder();
        query.append(sql);
        if (pageable.getSort() != null && pageable.getSort().stream().findFirst().isPresent()) {
            String orderBy = SqlUtils.getOrderBy((Sort.Order)((Sort.Order)pageable.getSort().stream().findFirst().get()), (String)defaultOrderBy);
            query.append(orderBy);
            return query.toString();
        }
        query.append(' ').append(defaultOrderBy);
        return query.toString();
    }

    private static String getOrderBy(Sort.Order order, String defaultOrderBy) {
        StringBuilder orderBy = new StringBuilder();
        String property = order.getProperty();
        Sort.Direction direction = order.getDirection();
        Boolean isValidProperty = property != null && property.matches("^([a-zA-Z]+(,)?)+(asc|desc|ASC|DESC)?$");
        if (isValidProperty.booleanValue()) {
            orderBy.append(" ORDER BY ").append(property.toUpperCase(LocaleContextHolder.getLocale())).append(' ').append(direction.toString());
            return orderBy.toString();
        }
        orderBy.append(' ').append(defaultOrderBy);
        return orderBy.toString();
    }

    public static boolean isOracle(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("ORACLE");
    }

    public static boolean isH2(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("H2");
    }

    public static boolean isPostgres(String platform) {
        return platform.toUpperCase(Locale.getDefault()).contains("POSTGRES");
    }

    public static String like(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format("tiraacento(UPPER(%s)) like tiraacento(UPPER('%%%s%%'))", coluna, filtro.replace(" ", "%"));
    }

    public static String andLike(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND " + SqlUtils.like((String)coluna, (String)filtro);
    }

    public static String andEqual(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND" + SqlUtils.equalsTo((String)coluna, (String)filtro);
    }

    public static String andEqual(String coluna, Long filtro) {
        if (Objects.isNull(filtro)) {
            return "";
        }
        return String.format(" AND %s = %s ", coluna, filtro);
    }

    public static String equalsTo(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format(" tiraacento(UPPER(%s)) = tiraacento(UPPER('%s')) ", coluna, filtro);
    }

    public static String beginsWith(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return String.format("tiraacento(UPPER(%s)) like tiraacento(UPPER('%s%%'))", coluna, filtro.replace(" ", "%"));
    }

    public static String andBeginsWith(String coluna, String filtro) {
        if (StringUtils.isBlank((String)filtro)) {
            return "";
        }
        return " AND " + SqlUtils.beginsWith((String)coluna, (String)filtro);
    }

    public static String regExpReplace(String source, String pattern, String replacementString, String platform) {
        String regExpression = SqlUtils.isPostgres((String)platform) ? "REGEXP_REPLACE(%s, %s, %s, 'g')" : "REGEXP_REPLACE(%s, %s, %s)";
        return String.format(regExpression, source, pattern, replacementString);
    }

    public static String andEqualNumbers(String coluna, String filtro, String platform) {
        if (Objects.isNull(filtro)) {
            return "";
        }
        return String.format(" AND %s = %s ", SqlUtils.regExpReplace((String)coluna, (String)"'\\D+'", (String)"''", (String)platform), SqlUtils.regExpReplace((String)filtro, (String)"'\\D+'", (String)"''", (String)platform));
    }

    public static String createSQLUltimaAtualizacaoByTableAndColumn(String table, String column, Long entidade) {
        String where = "";
        if (NumberUtils.isBiggerThanZero((Number)entidade).booleanValue()) {
            where = String.format(" WHERE ENTIDADE = %d", entidade);
        }
        return String.format("SELECT MAX(%s) AS ULTIMOACESSO, '0' AS MODULO FROM %s%s", column, table, where);
    }

    public static String createSQLCount(String sql) {
        return "SELECT COUNT(1) TOTAL FROM (" + sql + ") T";
    }
}

