/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.TipoSubvencao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoAditivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoRemuneracaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoSituacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.SubvencaoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.TipoSubvencaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AditivoParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PrestacaoContasParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.SubvencaoParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SubvencaoService {
    private final SubvencaoRepository repository;
    private final TipoSubvencaoRepository tipoSubvencaoRepository;

    @Autowired
    public SubvencaoService(SubvencaoRepository repository, TipoSubvencaoRepository tipoSubvencaoRepository) {
        this.repository = repository;
        this.tipoSubvencaoRepository = tipoSubvencaoRepository;
    }

    public Page<SubvencaoDTO> findSubvencoes(SubvencaoParams params, Pageable pageable) {
        return this.repository.findSubvencoes(params, pageable);
    }

    public SubvencaoDTO findSubvencao(SubvencaoParams params) {
        return this.repository.findSubvencao(params);
    }

    public List<EmpenhoDTO> findValoresLiberados(SubvencaoParams params) {
        return this.repository.findValoresLiberados(params);
    }

    public SubvencaoSituacaoDTO findPrestacaoContas(PrestacaoContasParams params) {
        return this.repository.findPrestacaoContas(params);
    }

    public List<SubvencaoSituacaoDTO> findPrestacoesContas(SubvencaoParams params) {
        return this.repository.findPrestacoesContas(params);
    }

    public List<ArquivoDTO> findPrestacaoContasAnexo(PrestacaoContasParams params) {
        return this.repository.findPrestacaoContasAnexo(params);
    }

    public List<SubvencaoAditivoDTO> findAditivos(SubvencaoParams params) {
        return this.repository.findAditivos(params);
    }

    public SubvencaoAditivoDTO findAditivo(AditivoParams params) {
        return this.repository.findAditivo(params);
    }

    public List<ArquivoDTO> findAditivoAnexos(AditivoParams params) {
        return this.repository.findAditivoAnexos(params);
    }

    public List<SubvencaoRemuneracaoDTO> findRemuneracoes(SubvencaoParams params) {
        return this.repository.findRemuneracoes(params);
    }

    public List<ArquivoDTO> findSubvencaoAnexo(SubvencaoParams params) {
        return this.repository.findSubvencaoAnexo(params);
    }

    public List<ArquivoDTO> findCertidaoAnexo(SubvencaoParams params) {
        return this.repository.findCertidaoAnexo(params);
    }

    public List<TipoSubvencao> findTipoSubvencao() {
        return this.tipoSubvencaoRepository.findAll();
    }
}

