/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.TipoSubvencao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoAditivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoRemuneracaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoSituacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AditivoParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PrestacaoContasParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.SubvencaoParams;
import br.com.elotech.portaltransparencia.contabportal.service.SubvencaoService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/subvencoes"})
public class SubvencaoResource {
    private final SubvencaoService service;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public SubvencaoResource(SubvencaoService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.service = service;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<SubvencaoDTO>> findSubvencoes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params, Pageable pageable) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findSubvencoes(params, pageable));
    }

    @GetMapping(value={"/detalhe"})
    public ResponseEntity<SubvencaoDTO> findSubvencao(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findSubvencao(params));
    }

    @GetMapping(value={"/valores-liberados"})
    public ResponseEntity<List<EmpenhoDTO>> findValoresLiberados(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findValoresLiberados(params));
    }

    @GetMapping(value={"/prestacao-contas"})
    public ResponseEntity<List<SubvencaoSituacaoDTO>> findPrestacaoContas(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findPrestacoesContas(params));
    }

    @GetMapping(value={"/prestacao-contas/detalhe"})
    public ResponseEntity<SubvencaoSituacaoDTO> findPrestacaoContas(PrestacaoContasParams params) {
        return ResponseEntity.ok((Object)this.service.findPrestacaoContas(params));
    }

    @GetMapping(value={"/prestacao-contas/arquivos"})
    public ResponseEntity<List<ArquivoDTO>> findPrestacaoContasAnexos(PrestacaoContasParams params) {
        return ResponseEntity.ok((Object)this.service.findPrestacaoContasAnexo(params));
    }

    @GetMapping(value={"/aditivos"})
    public ResponseEntity<List<SubvencaoAditivoDTO>> findAditivos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findAditivos(params));
    }

    @GetMapping(value={"/aditivo/detalhe"})
    public ResponseEntity<SubvencaoAditivoDTO> findAditivo(AditivoParams params) {
        return ResponseEntity.ok((Object)this.service.findAditivo(params));
    }

    @GetMapping(value={"/aditivo/arquivos"})
    public ResponseEntity<List<ArquivoDTO>> findAditivoAnexos(AditivoParams params) {
        return ResponseEntity.ok((Object)this.service.findAditivoAnexos(params));
    }

    @GetMapping(value={"/remuneracoes"})
    public ResponseEntity<List<SubvencaoRemuneracaoDTO>> findRemuneracoes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findRemuneracoes(params));
    }

    @GetMapping(value={"/anexos"})
    public ResponseEntity<List<ArquivoDTO>> findAnexos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findSubvencaoAnexo(params));
    }

    @GetMapping(value={"/certidao-anexos"})
    public ResponseEntity<List<ArquivoDTO>> findCertidaoAnexos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, SubvencaoParams params) {
        this.setEntidadeExercicio(params, entidade, exercicio);
        return ResponseEntity.ok((Object)this.service.findCertidaoAnexo(params));
    }

    @GetMapping(value={"/tipoSubvencao"})
    public ResponseEntity<List<TipoSubvencao>> findTipoSubvencao() {
        return ResponseEntity.ok((Object)this.service.findTipoSubvencao());
    }

    @GetMapping(value={"/report"})
    public ModelAndView getSubvencoesExport(HttpServletRequest request, HttpServletResponse response, Pageable pageable, SubvencaoParams params) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.service.findSubvencoes(params, (Pageable)page);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidade.getNome());
        reportParam.setReportTitle("Listagem de Subven\u00e7\u00f5es");
        reportParam.setClazzDTO(SubvencaoDTO.class);
        reportParam.setHeaderFields("Subven\u00e7\u00e3o,Identifica\u00e7\u00e3o da Parceria,Data Assinatura,Nome da Organiza\u00e7\u00e3o Social Civil,CNPJ,Valor Total,Valores Liberados");
        reportParam.setFields("subvencao,tipoSubvencao,dataInicioConvenio,nomeBeneficiario,cnpj,valorPrevisto,valorLiberado");
        float[] fieldsPerc = new float[]{0.7f, 0.9f, 0.9f, 1.8f, 0.9f, 0.8f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{6, 11, 50, 300, 15, 13, 13};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valorPrevisto");
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private void setEntidadeExercicio(SubvencaoParams params, Long entidade, Long exercicio) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
    }
}

