/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.Despesa;
import br.com.elotech.portaltransparencia.contabportal.domain.EmpenhoPK;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.domain.ItemEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.TiposLicitacaoApice;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="EMPENHO")
public class Empenho
implements EloEntity<EmpenhoPK> {
    @EmbeddedId
    private EmpenhoPK id;
    @ManyToOne
    @JoinColumn(name="FORNECEDOR")
    private Fornecedor fornecedor;
    @Column(name="DATA")
    private LocalDate data;
    private LocalDate dataEntrega;
    @Column(name="HISTORICONAD", length=2000)
    private String historico;
    @Column(name="VALOR")
    private BigDecimal valor;
    @Column(name="PROGRAMATICA")
    private String programatica;
    @ManyToOne
    @JoinColumn(name="TIPOLICITACAO", referencedColumnName="CONTABILIDADE")
    @NotFound(action=NotFoundAction.IGNORE)
    private TiposLicitacaoApice tipoLicitacao;
    @Column(name="ANOLICITACAO")
    private Long anoLicitacao;
    @Column(name="NOLICITACAO")
    private String noLicitacao;
    @Column(name="DESDOBRADESP")
    private String desdobramento;
    @Column(name="SUBDESDOBRAMENTO")
    private String subDesdobramento;
    @Column(name="CONTABILIZADO")
    private String contabilizado;
    @Column(name="NOPROCESSO")
    private String numeroProcesso;
    @Column(name="ANOPROCESSO")
    private String anoProcesso;
    @Column(name="CONTRATO")
    private String contrato;
    @Column(name="ANOCONTRATO")
    private Long anoContrato;
    @Column(name="FONTERECURSO")
    private Long fonteRecurso;
    @Column(name="MPCOVID19")
    private String mpCovid19;
    @OneToMany(mappedBy="id.empenho")
    private List<ItemEmpenho> items;
    @OneToMany(mappedBy="id.empenho")
    private List<FichaEmpenho> fichasEmpenho;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", insertable=false, updatable=false), @JoinColumn(name="programatica", referencedColumnName="programatica", insertable=false, updatable=false), @JoinColumn(name="fonteRecurso", referencedColumnName="fonteRecurso", insertable=false, updatable=false)})
    private Despesa despesa;

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Empenho)) {
            return false;
        }
        Empenho other = (Empenho)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EmpenhoPK this$id = this.getId();
        EmpenhoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Empenho;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EmpenhoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public Empenho() {
    }

    @Generated
    public EmpenhoPK getId() {
        return this.id;
    }

    @Generated
    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataEntrega() {
        return this.dataEntrega;
    }

    @Generated
    public String getHistorico() {
        return this.historico;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getProgramatica() {
        return this.programatica;
    }

    @Generated
    public TiposLicitacaoApice getTipoLicitacao() {
        return this.tipoLicitacao;
    }

    @Generated
    public Long getAnoLicitacao() {
        return this.anoLicitacao;
    }

    @Generated
    public String getNoLicitacao() {
        return this.noLicitacao;
    }

    @Generated
    public String getDesdobramento() {
        return this.desdobramento;
    }

    @Generated
    public String getSubDesdobramento() {
        return this.subDesdobramento;
    }

    @Generated
    public String getContabilizado() {
        return this.contabilizado;
    }

    @Generated
    public String getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public String getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public String getContrato() {
        return this.contrato;
    }

    @Generated
    public Long getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public Long getFonteRecurso() {
        return this.fonteRecurso;
    }

    @Generated
    public String getMpCovid19() {
        return this.mpCovid19;
    }

    @Generated
    public List<ItemEmpenho> getItems() {
        return this.items;
    }

    @Generated
    public List<FichaEmpenho> getFichasEmpenho() {
        return this.fichasEmpenho;
    }

    @Generated
    public Despesa getDespesa() {
        return this.despesa;
    }

    @Generated
    public void setId(EmpenhoPK id) {
        this.id = id;
    }

    @Generated
    public void setFornecedor(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataEntrega(LocalDate dataEntrega) {
        this.dataEntrega = dataEntrega;
    }

    @Generated
    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setProgramatica(String programatica) {
        this.programatica = programatica;
    }

    @Generated
    public void setTipoLicitacao(TiposLicitacaoApice tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setAnoLicitacao(Long anoLicitacao) {
        this.anoLicitacao = anoLicitacao;
    }

    @Generated
    public void setNoLicitacao(String noLicitacao) {
        this.noLicitacao = noLicitacao;
    }

    @Generated
    public void setDesdobramento(String desdobramento) {
        this.desdobramento = desdobramento;
    }

    @Generated
    public void setSubDesdobramento(String subDesdobramento) {
        this.subDesdobramento = subDesdobramento;
    }

    @Generated
    public void setContabilizado(String contabilizado) {
        this.contabilizado = contabilizado;
    }

    @Generated
    public void setNumeroProcesso(String numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setAnoProcesso(String anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setContrato(String contrato) {
        this.contrato = contrato;
    }

    @Generated
    public void setAnoContrato(Long anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public void setFonteRecurso(Long fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setMpCovid19(String mpCovid19) {
        this.mpCovid19 = mpCovid19;
    }

    @Generated
    public void setItems(List<ItemEmpenho> items) {
        this.items = items;
    }

    @Generated
    public void setFichasEmpenho(List<FichaEmpenho> fichasEmpenho) {
        this.fichasEmpenho = fichasEmpenho;
    }

    @Generated
    public void setDespesa(Despesa despesa) {
        this.despesa = despesa;
    }

    @Generated
    public String toString() {
        return "Empenho(id=" + this.getId() + ", fornecedor=" + this.getFornecedor() + ", data=" + this.getData() + ", dataEntrega=" + this.getDataEntrega() + ", historico=" + this.getHistorico() + ", valor=" + this.getValor() + ", programatica=" + this.getProgramatica() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", anoLicitacao=" + this.getAnoLicitacao() + ", noLicitacao=" + this.getNoLicitacao() + ", desdobramento=" + this.getDesdobramento() + ", subDesdobramento=" + this.getSubDesdobramento() + ", contabilizado=" + this.getContabilizado() + ", numeroProcesso=" + this.getNumeroProcesso() + ", anoProcesso=" + this.getAnoProcesso() + ", contrato=" + this.getContrato() + ", anoContrato=" + this.getAnoContrato() + ", fonteRecurso=" + this.getFonteRecurso() + ", mpCovid19=" + this.getMpCovid19() + ", items=" + this.getItems() + ", fichasEmpenho=" + this.getFichasEmpenho() + ", despesa=" + this.getDespesa() + ")";
    }
}

