/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorarioFlexivelDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosFinanceirosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.enums.SituacaoServidor;
import br.com.elotech.portaltransparencia.aiseportal.repository.ServidorRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ServidorRepositoryImpl
implements ServidorRepository {
    private static final String APOSENTADOS_PENSIONISTAS_SQL = "db/sql/aise/aposentados.sql";
    private static final String SERVIDORES_SQL = "db/sql/aise/servidores.sql";
    private static final String SERVIDOR_DETALHE_SQL = "db/sql/aise/servidor-detalhe.sql";
    private static final String SERVIDOR_DADOS_PENSAO_SQL = "db/sql/aise/servidorDadosPensao.sql";
    private static final String SERVIDOR_DADOS_FINANCEIROS_SQL = "db/sql/aise/servidor-dados-financeiros.sql";
    private static final String SERVIDOR_VENCIMENTOS_DESCONTOS_SQL = "db/sql/aise/servidor-vencimentos-descontos.sql";
    private static final String DESCONTO = "D";
    private static final String PROVENTOS = "P";
    private static final String OUTROS_PROVENTOS = "O";
    private static final String SERVIDORES_ALIAS = "XX";
    private static final String SERVIDORES_RESUMO_NATUREZA_SQL = "db/sql/aise/servidores_resumo_natureza.sql";
    private static final String SERVIDOR_ANOTACOES_SQL = "db/sql/aise/servidor-anotacoes.sql";
    private static final String SERVIDOR_HORARIO_FLEXIVEL_SQL = "db/sql/aise/servidor-horario-flexivel.sql";
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeAiseService entidadeAiseService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServidorRepositoryImpl.class);
    private final DatasourceWrapper datasourceWrapper;

    public ServidorRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper, PortalParametroRepository portalParametroRepository, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.portalParametroRepository = portalParametroRepository;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SERVIDORES_SQL));
        sql.append(this.getSqlComplementar(params, Boolean.TRUE));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List servidores = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDTO.class));
        return new PageImpl(servidores, pageable, this.getQuantidadeServidores(sql.toString(), parameter).longValue());
    }

    public Page<ServidorDTO> loadAposentadosPensionistas(ServidorParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)APOSENTADOS_PENSIONISTAS_SQL));
        sql.append(this.getSqlComplementar(params, Boolean.FALSE));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List servidores = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDTO.class));
        return new PageImpl(servidores, pageable, this.getQuantidadeServidores(sql.toString(), parameter).longValue());
    }

    private Long getQuantidadeServidores(String query, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }

    private void addFilterSalarioSqlComplementar(StringBuilder sql, BigDecimal valor, String filtro) {
        if (Objects.nonNull(valor)) {
            sql.append(filtro);
            sql.append(valor);
        }
    }

    private String getSqlComplementar(ServidorParams params, Boolean servidoresQuery) {
        Long naturezaSecretario = 14L;
        String sf = "SF";
        String rdc = "RDC";
        String p = PROVENTOS;
        String f = "F";
        if (servidoresQuery.booleanValue()) {
            sf = SERVIDORES_ALIAS;
            rdc = SERVIDORES_ALIAS;
            p = SERVIDORES_ALIAS;
            f = SERVIDORES_ALIAS;
        }
        StringBuilder sqlComplementar = new StringBuilder();
        if (SituacaoServidor.fromDescricao((String)params.getSituacao()) != null) {
            sqlComplementar.append(SqlUtils.andBeginsWith((String)(sf + ".SITUACAO"), (String)SituacaoServidor.fromDescricao((String)params.getSituacao()).name()));
        }
        if (Objects.nonNull(params.getNatureza())) {
            if (!params.getNatureza().equals(naturezaSecretario)) {
                sqlComplementar.append(SqlUtils.andEqual((String)(rdc + ".DEFINICAO"), (Long)params.getNatureza()));
            } else {
                sqlComplementar.append(" AND ((" + rdc + ".DEFINICAO = 14) OR ");
                sqlComplementar.append("     (EXISTS(SELECT 1 ");
                sqlComplementar.append("               FROM RHMOVIMENTACAOPESSOAL MPN ");
                sqlComplementar.append("               JOIN RHMOVIMENTACAOOUTROS MPNO ");
                sqlComplementar.append("                 ON MPN.ENTIDADE = MPNO.ENTIDADE ");
                sqlComplementar.append("                AND MPN.MATRICULA = MPNO.MATRICULA ");
                sqlComplementar.append("                AND MPN.MOVIMENTACAO = MPNO.MOVIMENTACAO ");
                sqlComplementar.append("               JOIN RHCARGO CN ");
                sqlComplementar.append("                 ON MPNO.ENTIDADE = CN.ENTIDADE ");
                sqlComplementar.append("                AND MPNO.CARGO = CN.CARGO ");
                sqlComplementar.append("              WHERE MPN.ENTIDADE = " + f + ".ENTIDADE ");
                sqlComplementar.append("                AND MPN.MATRICULA = " + f + ".MATRICULA ");
                sqlComplementar.append("                AND MPN.TIPOMOVIMENTACAO = 99 ");
                sqlComplementar.append("                AND MPNO.DATAINICIO <= FIMCOMPETENCIA(:exercicio, :mesCompetencia) ");
                sqlComplementar.append("                AND (MPNO.DATAFIM >= INICIOCOMPETENCIA(:exercicio, :mesCompetencia) ");
                sqlComplementar.append("                     OR MPNO.DATAFIM IS NULL) ");
                sqlComplementar.append("                AND CN.CARGOGENERICO = 4))) ");
            }
        }
        sqlComplementar.append(SqlUtils.andLike((String)(p + ".NOME"), (String)params.getNomeServidor()));
        if (servidoresQuery.booleanValue()) {
            sqlComplementar.append(SqlUtils.andLike((String)"XX.DESCRICAOCARGO", (String)params.getCargo()));
            sqlComplementar.append(SqlUtils.andLike((String)"XX.DESCRICAOLOTACAO", (String)params.getLotacao()));
            sqlComplementar.append(SqlUtils.andLike((String)"XX.DESCRICAOCLASSE", (String)params.getClasse()));
        } else {
            sqlComplementar.append(SqlUtils.andLike((String)"C.DESCRICAO", (String)params.getCargo()));
            sqlComplementar.append(SqlUtils.andLike((String)"RL.DESCRICAO", (String)params.getLotacao()));
            sqlComplementar.append(SqlUtils.andLike((String)"CL.DESCRICAO", (String)params.getClasse()));
        }
        params.setMesCompetencia(Long.valueOf(LocalDate.now().getMonthValue()));
        this.addFilterSalarioSqlComplementar(sqlComplementar, params.getValorSalarioInicial(), " AND fnc_getsalariofuncportal(" + f + ".entidade, " + f + ".matricula, :mesCompetencia, " + " :exercicio, fnc_gettipofolhaprincipal(" + f + ".entidade), :dataAtual) >= ");
        this.addFilterSalarioSqlComplementar(sqlComplementar, params.getValorSalarioFinal(), " AND fnc_getsalariofuncportal(" + f + ".entidade, " + f + ".matricula, :mesCompetencia, " + " :exercicio, fnc_gettipofolhaprincipal(" + f + ".entidade), :dataAtual) <= ");
        sqlComplementar.append(SqlUtils.andEqual((String)(p + ".CNPJ_CPF"), (String)params.getCpf()));
        if (Boolean.TRUE.equals(params.getAdmissaoExcepcional())) {
            sqlComplementar.append(SqlUtils.andEqual((String)(f + ".ADMISSAOEXCEPCIONAL"), (String)SimNao.SIM.getSigla()));
        }
        return sqlComplementar.toString();
    }

    public List<ServidorDadosFinanceirosDTO> findDadosFinanceirosServidor(ServidorParams params) {
        String filtro = "$[FILTRO]";
        String sql = FileUtils.readResourceAsString((String)SERVIDOR_DADOS_FINANCEIROS_SQL);
        PortalParametroContabil paramDescontos = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_APENAS_DESCONTOS_OFICIAIS);
        PortalParametroContabil paramRedutor = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_MOSTRA_REDUTOR_CONSTITUCIONAL);
        if (Objects.nonNull(paramDescontos) && SimNao.toBoolean((String)paramDescontos.getValor(), (Boolean)Boolean.FALSE).booleanValue()) {
            sql = sql.replace("$[FILTRO]", " AND EVP.DEFINICAO IN (17,20,36,50,53) ");
        } else if (Objects.nonNull(paramRedutor) && SimNao.toBoolean((String)paramRedutor.getValor(), (Boolean)Boolean.FALSE).booleanValue()) {
            sql = sql.replace("$[FILTRO]", " AND EVP.DEFINICAO <> 83 ");
        }
        sql = sql.replace("$[FILTRO]", "");
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDadosFinanceirosDTO.class));
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String sql = FileUtils.readResourceAsString((String)SERVIDOR_VENCIMENTOS_DESCONTOS_SQL);
        PortalParametroContabil parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_IRRF_PREVIDENCIA);
        PortalParametroContabil paramRedutor = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_MOSTRA_REDUTOR_CONSTITUCIONAL);
        if (params.getTipoEvento().equals(DESCONTO) && Objects.nonNull(parametro) && SimNao.toBoolean((String)parametro.getValor(), (Boolean)Boolean.FALSE).booleanValue()) {
            sql = sql.concat(" AND EV.DEFINICAO IN (17,20,36,50,53) ");
        } else if (params.getTipoEvento().equals(OUTROS_PROVENTOS)) {
            params.setTipoEvento(PROVENTOS);
            sql = sql.concat(" AND EV.DEFINICAO <> 1 ");
        } else if (Objects.nonNull(paramRedutor) && SimNao.toBoolean((String)paramRedutor.getValor(), (Boolean)Boolean.FALSE).booleanValue()) {
            sql = sql.concat(" AND EV.DEFINICAO <> 83 ");
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ServidorVencimentosDescontosDTO.class));
    }

    public List<ServidorResumoNaturezaDTO> loadServidoresResumoNatureza(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder descricaoNatureza = new StringBuilder().append(" (CASE WHEN MCV.MATRICULA IS NOT NULL THEN 'Cedido (Vindo de Outra Entidade)' ").append(" WHEN MCO.MATRICULA IS NOT NULL THEN 'Cedido (Para Outra Entidade)' ").append(" ELSE RDC.DESCRICAO END) ");
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SERVIDORES_RESUMO_NATUREZA_SQL));
        String sqlComplementar = this.getSqlComplementar(params, Boolean.FALSE);
        sql.append(sqlComplementar).append(" GROUP BY ").append((CharSequence)descricaoNatureza).append(" ORDER BY TRIM ").append((CharSequence)descricaoNatureza);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ServidorResumoNaturezaDTO.class));
    }

    public Optional<ServidorDadosPensaoDTO> loadPensaoServidor(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SERVIDOR_DADOS_PENSAO_SQL)).append(" WHERE mp.tipomovimentacao = 67 ").append(" AND mp.entidade = :entidade").append(" AND mp.matricula = :matricula");
        LOGGER.debug(sql.toString());
        LOGGER.debug(params.toString());
        List dadosPensao = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDadosPensaoDTO.class));
        return dadosPensao.stream().findFirst();
    }

    public Optional<ServidorDTO> loadServidor(ServidorParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SERVIDOR_DETALHE_SQL));
        sql.append(this.getSqlComplementar(params, Boolean.FALSE));
        sql.append(SqlUtils.andEqual((String)"F.MATRICULA", (String)params.getMatricula().toString()));
        List servidores = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDTO.class));
        return servidores.stream().findFirst();
    }

    public List<String> findAnotacoesServidor(ServidorParams params) {
        String sql = FileUtils.readResourceAsString((String)SERVIDOR_ANOTACOES_SQL);
        return this.datasourceWrapper.getJdbcTemplate().queryForList(sql, (SqlParameterSource)params.toJdbcParameter(), String.class);
    }

    public List<HorarioFlexivelDTO> findHorarioFlexivel(ServidorParams params) {
        String sql = FileUtils.readResourceAsString((String)SERVIDOR_HORARIO_FLEXIVEL_SQL);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(HorarioFlexivelDTO.class));
    }
}

