Select d.numero,
       d.entidade,
       d.centrocusto centroCustoOrigem,
       d.centrocustoconsumo centroCustoDestino,
       d.data,
       sum(case when d.sinal = '-' then (coalesce(d1.valorTotal,0) * -1)
                else coalesce(d1.valorTotal,0)
            end) as valorTotal,
       co.descricao centroCustoOrigemDescricao,
       cd.descricao centroCustoDestinoDescricao
  from est_movimentacao d
 inner join est_movimentacao_itens d1
    on d.entidade = d1.entidade
   and d.exercicio = d1.exercicio
   and d.numero = d1.numero
   and d.sequencia = d1.sequencia
inner join est_centrocusto co
   on co.entidade = d.entidade
  and co.centrocusto = d.centrocusto
inner join est_centrocusto cd
   on cd.entidade = d.entidade
  and cd.centrocusto = d.centrocustoconsumo
 where d.saldoatualizado = 'S'
   AND d.ENTIDADE = :entidade
   AND d.exercicio = :exercicio
   AND (:centroCustoOrigem = -99 OR d.CENTROCUSTO = :centroCustoOrigem)
   AND d.CENTROCUSTOCONSUMO = :centroCustoDestino
   AND d.tipomov = 'S'
   AND d.DATA >= :dataInicio
   AND d.DATA <= :dataFinal
 group by d.numero, d.entidade, d.centrocusto, d.centrocustoconsumo, d.data, co.descricao, cd.descricao
