/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.mapper;

import br.com.elotech.portaltransparencia.protocportal.domain.Escolaridade;
import br.com.elotech.portaltransparencia.protocportal.domain.Funcao;
import br.com.elotech.portaltransparencia.protocportal.domain.Processo;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoArquivo;
import br.com.elotech.portaltransparencia.protocportal.domain.Tramite;
import br.com.elotech.portaltransparencia.protocportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.TramitacaoDTO;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;

public class ProcessoToDTO
implements Converter<Processo, ProcessoDTO> {
    public ProcessoDTO convert(Processo entity) {
        ProcessoDTO dto = new ProcessoDTO();
        dto.setProcesso(entity.getId().getNumero().toString());
        dto.setDigitacao(entity.getDigitacao());
        dto.setEntidade(entity.getId().getEntidade().getId().toString());
        dto.setExercicio(entity.getId().getAno().toString());
        dto.setTipo(entity.getId().getTipo().getId().toString());
        dto.setAssunto(entity.getAssunto());
        dto.setData(entity.getDataOrigem().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
        dto.setSenha(entity.getSenha());
        dto.setProcessoReferencia(entity.getProcessoReferencia());
        dto.setEmail(entity.getEmail());
        dto.setEscolaridade(Optional.ofNullable(entity.getEscolaridade()).orElse(new Escolaridade()).getId());
        if (Objects.nonNull(entity.getSexo())) {
            dto.setSexo(entity.getSexo().getValue());
        }
        dto.setDataNascimento(entity.getDataNascimento());
        if (Objects.nonNull(entity.getPessoa())) {
            dto.setRequerente(entity.getPessoa().getNome());
            if (Objects.nonNull(entity.getPessoa().getContato())) {
                dto.setCpf(entity.getPessoa().getCnpjCpf());
                dto.setEmail(entity.getPessoa().getContato().getEmail());
            }
        }
        if (Objects.nonNull(entity.getSituacao())) {
            dto.setSituacao(entity.getSituacao().getDescricao());
        }
        dto.getTramitacoes().addAll(this.convertTramites(entity.getTramites()));
        Collections.sort(dto.getTramitacoes(), Comparator.comparing(TramitacaoDTO::getSequencia));
        dto.getArquivos().addAll(this.convertArquivos(entity.getArquivos()));
        dto.setBairroAux(entity.getBairroAux());
        dto.setCidadeAux(entity.getCidadeAux());
        dto.setComplemento(entity.getComplemento());
        dto.setNumeroEndereco(entity.getNumeroEndereco());
        dto.setCep(entity.getCep());
        dto.setEndereco(entity.getEndereco());
        return dto;
    }

    public ProcessoDTO convert(Processo entity, Long codigoSituacaoCancelado) {
        ProcessoDTO convert = this.convert(entity);
        convert.setPermiteCriarReferencia(Boolean.valueOf(convert.getTramitacoes().stream().anyMatch(t -> t.getIdSituacao().equals(codigoSituacaoCancelado))));
        return convert;
    }

    protected List<TramitacaoDTO> convertTramites(List<Tramite> tramites) {
        ArrayList<TramitacaoDTO> resultado = new ArrayList<TramitacaoDTO>();
        for (Tramite tramite : tramites) {
            TramitacaoDTO tramitacaoDTO = new TramitacaoDTO();
            tramitacaoDTO.setData(tramite.getData().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            if (Objects.nonNull(tramite.getLocal())) {
                tramitacaoDTO.setLocal(tramite.getLocal().getDescricao());
            }
            if (Objects.nonNull(tramite.getSituacao())) {
                tramitacaoDTO.setIdSituacao(tramite.getSituacao().getId());
                tramitacaoDTO.setSituacao(tramite.getSituacao().getDescricao());
            }
            if (Objects.nonNull(tramite.getFuncao())) {
                tramitacaoDTO.setFuncao(Funcao.fromStatus((String)tramite.getFuncao()));
            }
            tramitacaoDTO.setSequencia(tramite.getId().getSequencia());
            tramitacaoDTO.setParecer(tramite.getParecer());
            resultado.add(tramitacaoDTO);
        }
        return resultado;
    }

    protected List<ArquivoDTO> convertArquivos(List<ProcessoArquivo> arquivos) {
        ArrayList<ArquivoDTO> resultado = new ArrayList<ArquivoDTO>();
        for (ProcessoArquivo arquivo : arquivos) {
            ArquivoDTO arquivoDTO = new ArquivoDTO();
            arquivoDTO.setId(arquivo.getId().getSequencia());
            arquivoDTO.setNomeArquivo(arquivo.getNomeArquivo());
            arquivoDTO.setIdArquivo(arquivo.getIdArquivo());
            resultado.add(arquivoDTO);
        }
        return resultado;
    }
}

