/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.legislacaoportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.legislacaoportal.domain.DiarioOficial;
import br.com.elotech.portaltransparencia.legislacaoportal.domain.DiarioOficialParams;
import br.com.elotech.portaltransparencia.legislacaoportal.repository.DiarioOficialRepository;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DiarioOficialRepositoryImpl
implements DiarioOficialRepository {
    private final DatasourceWrapper datasourceWrapper;
    private static final String DIARIO_OFICIAL = "db/sql/compras/diarioOficial.sql";

    public DiarioOficialRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<DiarioOficial> findAllDiariosOficiais(DiarioOficialParams params, Pageable pageable) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)DIARIO_OFICIAL));
        params.getNumero().ifPresent(numero -> query.append(" AND DD.NUMERO = :numero "));
        params.getTipo().ifPresent(tipo -> query.append(" AND DD.TIPO = :tipo "));
        params.getMesPublicacao().ifPresent(mesPublicacao -> query.append(" AND EXTRACT(MONTH from DD.DATAPUBLICACAO) = :mesPublicacao "));
        params.getAnoPublicacao().ifPresent(anoPublicacao -> query.append(" AND EXTRACT(YEAR from DD.DATAPUBLICACAO) = :anoPublicacao "));
        params.getPalavraChave().ifPresent(palavraChave -> {
            query.append(" AND ( UPPER(DOC.TEXTOVARCHAR)) LIKE UPPER(:palavraChave)");
            query.append(" OR UPPER(TDOC.DESCRICAO) LIKE UPPER(:palavraChave) ");
        });
        params.getDataInicio().ifPresent(dataInicio -> query.append(" AND DD.DATAPUBLICACAO >= :dataInicio"));
        params.getDataFim().ifPresent(dataInicio -> query.append(" AND DD.DATAPUBLICACAO <= :dataFim"));
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY DD.DATAPUBLICACAO DESC");
        String sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List diariosOficiais = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DiarioOficial.class));
        StringBuilder sqlCount = new StringBuilder("SELECT COUNT(1) TOTAL FROM ( ");
        sqlCount.append(queryOrder);
        sqlCount.append(") T");
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(diariosOficiais, pageable, total.longValue());
    }
}

