/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.service;

import br.com.elotech.core.utils.GeraImagemCodigoBarras;
import br.com.elotech.report.CustomSqlRowSetResultSetExtractor;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.serial.SerialBlob;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodigoBarrasGeneratorRowSetExtractor
extends CustomSqlRowSetResultSetExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodigoBarrasGeneratorRowSetExtractor.class);
    private final String subreportName;
    private static final int TAMANHO_IMAGEM_QRCODE = 300;

    public CodigoBarrasGeneratorRowSetExtractor(String subreportName) {
        this.subreportName = subreportName;
    }

    protected CachedRowSet modifySqlRowSet(CachedRowSet rowSet) throws SQLException {
        boolean existsQrCodePix = this.existsFieldQrCodePix(rowSet);
        boolean existsCodigoBarras = this.existsFieldCodigoBarras(rowSet);
        if (log.isTraceEnabled()) {
            ResultSetMetaData metaData = rowSet.getMetaData();
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < metaData.getColumnCount(); ++i) {
                builder.append(metaData.getColumnName(i)).append(" - ");
            }
            log.trace("Colunas do rowset que est\u00e1 sendo processado: {}", (Object)builder);
        }
        log.trace("Possui codigo de barras: {}, possui qrcode: {}", (Object)existsCodigoBarras, (Object)existsQrCodePix);
        if (!existsCodigoBarras && !existsQrCodePix) {
            return super.modifySqlRowSet(rowSet);
        }
        while (rowSet.next()) {
            String textoqrcodepix;
            String codigoBarras;
            byte[] imagem;
            if (existsCodigoBarras && Objects.nonNull(imagem = GeraImagemCodigoBarras.getImagemAsBMP((String)(codigoBarras = rowSet.getString("codigobarras"))))) {
                log.trace("A imagem do codigo de barras foi gerada");
                SerialBlob blobImagem = new SerialBlob(imagem);
                rowSet.updateBlob("codigobarrasimagem", (Blob)blobImagem);
                log.trace("A imagem do codigo de barras foi inserida no rowset");
            }
            if (existsQrCodePix && Objects.nonNull(imagem = this.gerarImagemQrCodePix(textoqrcodepix = rowSet.getString("textoqrcode")))) {
                log.trace("A imagem do qr code pix foi gerada");
                SerialBlob blobImagem = new SerialBlob(imagem);
                rowSet.updateBlob("codigoqrcode", (Blob)blobImagem);
                log.trace("A imagem do qr code pix foi inserida no rowset");
            }
            rowSet.updateRow();
        }
        return super.modifySqlRowSet(rowSet);
    }

    private byte[] gerarImagemQrCodePix(String textoqrcodepix) {
        byte[] byArray;
        if (StringUtils.isEmpty((CharSequence)textoqrcodepix)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            BitMatrix matrix = new MultiFormatWriter().encode(textoqrcodepix, BarcodeFormat.QR_CODE, 300, 300, hintMap);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"bmp", (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WriterException | IOException e) {
                log.error("Erro ao gerar a imagem do qrcode pix, {}", (Object)this.subreportName, (Object)e);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    private boolean existsFieldQrCodePix(CachedRowSet rowSet) {
        try {
            rowSet.findColumn("textoqrcode");
            return true;
        }
        catch (SQLException e) {
            log.error("Campo textoqrcode n\u00e3o encontrado no sql do subrelat\u00f3rio {}", (Object)this.subreportName, (Object)e);
            return false;
        }
    }

    private boolean existsFieldCodigoBarras(CachedRowSet rowSet) {
        try {
            rowSet.findColumn("CodigoBarrasImagem");
            rowSet.findColumn("CodigoBarras");
            return true;
        }
        catch (SQLException e) {
            log.error("Campos CodigoBarras e CodigoBarrasImagem n\u00e3o encontrados no sql do subrelat\u00f3rio {}", (Object)this.subreportName, (Object)e);
            return false;
        }
    }
}

