/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeradorQrCodeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeradorQrCodeUtil.class);
    private static final int TAMANHO_IMAGEM_QRCODE = 300;

    private GeradorQrCodeUtil() {
    }

    public static byte[] gerarImagemQrCode(String textoqrcode, String reportName) {
        byte[] byArray;
        if (StringUtils.isEmpty((CharSequence)textoqrcode)) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            EnumMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new EnumMap<EncodeHintType, ErrorCorrectionLevel>(EncodeHintType.class);
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            BitMatrix matrix = new MultiFormatWriter().encode(textoqrcode, BarcodeFormat.QR_CODE, 300, 300, hintMap);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"bmp", (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Erro ao gerar a imagem do qrcode, {}", (Object)reportName, (Object)e);
                return new byte[0];
            }
        }
        out.close();
        return byArray;
    }
}

