/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.service.impl;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.ReportDatasourceBuilder;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.report.CustomSqlRowSetResultSetExtractor;
import br.com.elotech.report.EloReport;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.dataset.DatasetPackage;
import br.com.elotech.report.server.domain.RelatorioArquivo;
import br.com.elotech.report.server.dto.ImprimeRelatorioDTO;
import br.com.elotech.report.server.dto.ParametroDTO;
import br.com.elotech.report.server.dto.SubRelatorioDTO;
import br.com.elotech.report.server.dto.TipoSql;
import br.com.elotech.report.server.exception.RptNotFoundException;
import br.com.elotech.report.server.report.ReportExecutionResult;
import br.com.elotech.report.server.service.CodigoBarrasGeneratorRowSetExtractor;
import br.com.elotech.report.server.service.QrCodeDocumentoGeneratorRowSetExtractor;
import br.com.elotech.report.server.service.ReportExecutor;
import br.com.elotech.report.server.service.impl.ReportExecutorAise;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;

@Service
public class ReportExecutorAise
implements ReportExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportExecutorAise.class);
    private final EntityManager em;
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;

    public ReportExecutorAise(EntityManager em, DataSource dataSource, ObjectMapper objectMapper) {
        this.em = em;
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportExecutionResult execute(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        byte[] bytes;
        ReportDatasourceBuilder builder = ReportDatasource.builder().params(datasets -> this.loadParams(imprimeRelatorioDTO));
        String paramQrCodeDocumento = this.extraiParametroQrCodeDocumento(imprimeRelatorioDTO);
        for (SubRelatorioDTO subRelatorioDTO : imprimeRelatorioDTO.getSubRelatorios()) {
            if (BooleanUtils.isTrue((Boolean)subRelatorioDTO.getInternalData())) {
                try {
                    DatasetPackage datasetPackage = (DatasetPackage)this.objectMapper.readValue(subRelatorioDTO.getData(), DatasetPackage.class);
                    1 loader = new /* Unavailable Anonymous Inner Class!! */;
                    builder.add(subRelatorioDTO.getTableName(), subRelatorioDTO.getSubReportName(), (ReportDataLoader)loader);
                }
                catch (IOException e) {
                    log.error("Erro ao carregar o DatasetPackage para o subrelat\u00f3rio {}", (Object)subRelatorioDTO.getSubReportName(), (Object)e);
                }
                continue;
            }
            if (TipoSql.PARAMETRO.equals((Object)subRelatorioDTO.getTipoSql())) {
                builder.params(x -> this.loadSubReportParameter(subRelatorioDTO));
                continue;
            }
            CustomSqlRowSetResultSetExtractor rowsetExtractor = new CustomSqlRowSetResultSetExtractor();
            if (this.isSubRelatorioBloqueto(subRelatorioDTO) || this.isSubRelatorioBloquetoAgrupado(subRelatorioDTO)) {
                log.trace("Usando row set extractor do codigo de barras.");
                rowsetExtractor = new CodigoBarrasGeneratorRowSetExtractor(subRelatorioDTO.getSubReportName());
            }
            if (Objects.nonNull(paramQrCodeDocumento) && Boolean.TRUE.equals(subRelatorioDTO.getPrincipal())) {
                log.trace("Usando row set extractor do QrCode de Documentos.");
                rowsetExtractor = new QrCodeDocumentoGeneratorRowSetExtractor(subRelatorioDTO.getSubReportName(), paramQrCodeDocumento);
            }
            builder.add(subRelatorioDTO.getTableName(), subRelatorioDTO.getSubReportName(), (ReportDataLoader)DatasetLoaders.jdbc((String)subRelatorioDTO.getSqlText(), Collections.emptyMap(), (DataSource)this.dataSource, (ResultSetExtractor)rowsetExtractor));
        }
        log.trace("montando data source");
        ReportDatasource datasource = builder.build();
        log.trace("finalizou datasource: {}", (Object)datasource);
        Path file = this.createTempReportFile(imprimeRelatorioDTO);
        log.trace("criou arquivo temporario");
        try {
            EloReport eloReport = EloReportFactory.crystal().reportFile(() -> file.toFile()).setReportDatasource(datasource).build();
            log.trace("montou eloReport");
            bytes = eloReport.exportToPdf();
            log.trace("exportou o pdf para bytes");
        }
        finally {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                log.error("Erro ao remover arquivo tempor\u00e1rio {}", (Object)file, (Object)e);
            }
        }
        if (bytes == null) {
            throw new EloValidationException("Foi gerado um relat\u00f3rio vazio.");
        }
        return ReportExecutionResult.builder().content(bytes).fileName(this.getFileName(imprimeRelatorioDTO)).build();
    }

    private String extraiParametroQrCodeDocumento(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        return imprimeRelatorioDTO.getParametros().stream().filter(param -> param.getNome().equals("PUrlQRCode")).map(ParametroDTO::getValor).findFirst().orElse(null);
    }

    private boolean isSubRelatorioBloqueto(SubRelatorioDTO subRelatorioDTO) {
        String tableName = subRelatorioDTO.getTableName();
        return "Bloqueto".equalsIgnoreCase(tableName);
    }

    private boolean isSubRelatorioBloquetoAgrupado(SubRelatorioDTO subRelatorioDTO) {
        String tableName = subRelatorioDTO.getTableName();
        return "Bloqueto_Agrupado".equalsIgnoreCase(tableName);
    }

    private String getFileName(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        String fileName = imprimeRelatorioDTO.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = UUID.randomUUID().toString();
        }
        if (!fileName.endsWith(".pdf")) {
            return String.format("%s.pdf", fileName);
        }
        log.trace("File name resolvido: {}", (Object)fileName);
        return fileName;
    }

    private Set<Param> loadParams(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        return imprimeRelatorioDTO.getParametros().stream().map(ParametroDTO::toCrystalParam).collect(Collectors.toSet());
    }

    private Path createTempReportFile(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        RelatorioArquivo relatorioArquivo;
        StringBuilder sql = new StringBuilder().append("       Select arq.modulo, arq.tiporelatorio, arq.relatorio, arq.arquivo, arq.path, arq.rpt, arq.dataarquivo ").append("    from RelArquivo arq").append("      left outer join RelRelatorioAgrupar sequencia").append("        on arq.Modulo = sequencia.Modulo and").append("           arq.TipoRelatorio = sequencia.TipoRelatorio and").append("           arq.Relatorio = sequencia.Relatorio and").append("           arq.Arquivo = sequencia.arquivo").append("      Where arq.Modulo = :modulo").append("        and arq.TipoRelatorio = :tiporelatorio").append("        and arq.Relatorio = :relatorio");
        if (this.hasSequenciaEmissao(imprimeRelatorioDTO)) {
            sql.append(" and sequencia.sequencia = :sequencia");
        }
        sql.append(" Order by arq.arquivo");
        Query query = this.em.createNativeQuery(sql.toString(), RelatorioArquivo.class).setParameter("modulo", (Object)imprimeRelatorioDTO.getModulo()).setParameter("tiporelatorio", (Object)imprimeRelatorioDTO.getTipoRelatorio().getCodigo()).setParameter("relatorio", (Object)imprimeRelatorioDTO.getRelatorio()).setMaxResults(1);
        if (this.hasSequenciaEmissao(imprimeRelatorioDTO)) {
            query.setParameter("sequencia", (Object)imprimeRelatorioDTO.getSequenciaTipoEmissao());
        }
        try {
            relatorioArquivo = (RelatorioArquivo)query.getSingleResult();
        }
        catch (NoResultException e) {
            throw new RptNotFoundException("Arquivo RTP n\u00e3o encontrado.", (Exception)((Object)e));
        }
        byte[] rpt = relatorioArquivo.getRpt();
        Path baseDir = Paths.get("rpts", new String[0]);
        if (!Files.exists(baseDir, new LinkOption[0])) {
            baseDir = Files.createDirectory(baseDir, new FileAttribute[0]);
        }
        Path file = Files.createTempFile(baseDir, "", ".rpt", new FileAttribute[0]);
        Files.write(file, rpt, new OpenOption[0]);
        return file;
    }

    private boolean hasSequenciaEmissao(ImprimeRelatorioDTO dto) {
        return Objects.nonNull(dto.getSequenciaTipoEmissao()) && dto.getSequenciaTipoEmissao() > 0;
    }

    private Set<Param> loadSubReportParameter(SubRelatorioDTO subRelatorioDTO) {
        String[] fields = subRelatorioDTO.getParams().split(";");
        Object result = this.em.createNativeQuery(subRelatorioDTO.getSqlText()).getSingleResult();
        Object[] values = result.getClass().isArray() ? (Object[])result : new Object[]{result};
        if (fields.length != values.length) {
            if (log.isErrorEnabled()) {
                log.error(String.format("Erro ao executar query do SubReport de Par\u00e2metro: %s. N\u00famero de campos parametrizados: %d. N\u00famero de campos retornados do select: %d", subRelatorioDTO.getSubReportName(), fields.length, values.length));
            }
            throw new IllegalArgumentException(String.format("SubReport de Par\u00e2metro inconsistente: %s. N\u00famero de campos parametrizados: %d. N\u00famero de campos retornados do select: %d", subRelatorioDTO.getSubReportName(), fields.length, values.length));
        }
        HashSet<Param> params = new HashSet<Param>();
        for (int i = 0; i < fields.length; ++i) {
            params.add(Param.of((String)fields[i], (Object)values[i]));
        }
        return params;
    }
}

