/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.service;

import br.com.elotech.report.CustomSqlRowSetResultSetExtractor;
import br.com.elotech.report.server.util.GeradorQrCodeUtil;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.serial.SerialBlob;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeDocumentoGeneratorRowSetExtractor
extends CustomSqlRowSetResultSetExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QrCodeDocumentoGeneratorRowSetExtractor.class);
    private static final String QRCODE_DOCUMENTO_COLUMN = "qrcode_documento";
    private static final String CODIGOVALIDACAO_COLUMN = "codigovalidacao";
    private final String subreportName;
    private final String urlParametro;

    public QrCodeDocumentoGeneratorRowSetExtractor(String subreportName, String urlParametro) {
        this.subreportName = subreportName;
        this.urlParametro = urlParametro;
    }

    protected CachedRowSet modifySqlRowSet(CachedRowSet rowSet) throws SQLException {
        boolean existsFieldCodigoValidacaoAndQrCode;
        boolean bl = existsFieldCodigoValidacaoAndQrCode = this.existsField(rowSet, CODIGOVALIDACAO_COLUMN) && this.existsField(rowSet, QRCODE_DOCUMENTO_COLUMN);
        while (rowSet.next()) {
            String textoQrCode;
            byte[] imagem;
            if (existsFieldCodigoValidacaoAndQrCode && (imagem = GeradorQrCodeUtil.gerarImagemQrCode((String)(textoQrCode = this.urlParametro.concat(rowSet.getString(CODIGOVALIDACAO_COLUMN))), (String)this.subreportName)).length > 0) {
                log.debug("A imagem do QrCode foi gerada");
                SerialBlob blobImagem = new SerialBlob(imagem);
                rowSet.updateBlob(QRCODE_DOCUMENTO_COLUMN, (Blob)blobImagem);
                log.debug("A imagem do QrCode foi inserida no rowset");
            }
            rowSet.updateRow();
        }
        return super.modifySqlRowSet(rowSet);
    }

    private boolean existsField(CachedRowSet rowSet, String column) {
        try {
            rowSet.findColumn(column);
            return true;
        }
        catch (SQLException e) {
            log.error("Campo {} n\u00e3o encontrado no sql do subrelat\u00f3rio {}", new Object[]{column, this.subreportName, e});
            return false;
        }
    }
}

