/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.resource;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.report.server.dto.ImprimeRelatorioDTO;
import br.com.elotech.report.server.exception.ReportExecutionException;
import br.com.elotech.report.server.exception.RptNotFoundException;
import br.com.elotech.report.server.report.ReportExecutionResult;
import br.com.elotech.report.server.service.ReportExecutor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping
@RestController
public class ReportResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportResource.class);
    private final ReportExecutor reportExecutor;
    private final ObjectMapper objectMapper;
    private final EntityManager entityManager;

    private ReportExecutionResult executeReport(byte[] content, HttpServletResponse response) {
        ImprimeRelatorioDTO dto;
        try {
            dto = (ImprimeRelatorioDTO)this.objectMapper.readValue(content, ImprimeRelatorioDTO.class);
            log.debug(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)dto));
        }
        catch (IOException e) {
            log.error("Erro durante o parse do json", (Throwable)e);
            throw new ReportExecutionException("Erro durante o parse do json", new String(content), (Throwable)e);
        }
        try {
            ReportExecutionResult executionResult = this.reportExecutor.execute(dto);
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])executionResult.getContent(), (String)executionResult.getFileName());
            return executionResult;
        }
        catch (RptNotFoundException e) {
            log.error("Erro na gera\u00e7\u00e3o do relat\u00f3rio", (Throwable)e);
            throw new ReportExecutionException(e.getMessage(), new String(content), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro na gera\u00e7\u00e3o do relat\u00f3rio", (Throwable)e);
            throw new ReportExecutionException("Erro na gera\u00e7\u00e3o do relat\u00f3rio", new String(content), (Throwable)e);
        }
    }

    @PostMapping(value={"api/report"})
    public void executeReportAsPDF(@RequestBody byte[] content, HttpServletResponse response) {
        this.executeReport(content, response);
    }

    @PostMapping(value={"api/report"}, consumes={"multipart/form-data"})
    public void executeReportAsPDFMultiPartGzipped(@RequestParam(value="dto") MultipartFile file, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.executeReport(file.getBytes(), response);
    }

    @GetMapping(value={"/api/report/count"})
    public ResponseEntity<Object> count() {
        log.info("Buscando relat\u00f3rios do banco de dados.");
        Object count = this.entityManager.createNativeQuery("select count(*) from relrelatorio").getSingleResult();
        String body = Optional.ofNullable(count).map(v -> String.format("Foram encontrados %s relat\u00f3rios.", v)).orElse("Nenhum relat\u00f3rio encontrado!");
        return ResponseEntity.ok((Object)body);
    }

    @Generated
    public ReportResource(ReportExecutor reportExecutor, ObjectMapper objectMapper, EntityManager entityManager) {
        this.reportExecutor = reportExecutor;
        this.objectMapper = objectMapper;
        this.entityManager = entityManager;
    }
}

