/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.service.impl;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.ReportDatasourceBuilder;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.report.CustomSqlRowSetResultSetExtractor;
import br.com.elotech.report.EloReport;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.dataset.DatasetPackage;
import br.com.elotech.report.server.domain.RelatorioArquivo;
import br.com.elotech.report.server.dto.ImprimeRelatorioDTO;
import br.com.elotech.report.server.dto.ParametroDTO;
import br.com.elotech.report.server.dto.SubRelatorioDTO;
import br.com.elotech.report.server.exception.RptNotFoundException;
import br.com.elotech.report.server.report.ReportExecutionResult;
import br.com.elotech.report.server.service.CodigoBarrasGeneratorRowSetExtractor;
import br.com.elotech.report.server.service.ReportExecutor;
import br.com.elotech.report.server.service.impl.ReportExecutorAise;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;

@Service
public class ReportExecutorAise
implements ReportExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExecutorAise.class);
    private final EntityManager em;
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;

    public ReportExecutorAise(EntityManager em, DataSource dataSource, ObjectMapper objectMapper) {
        this.em = em;
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportExecutionResult execute(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        byte[] bytes;
        ReportDatasourceBuilder builder = ReportDatasource.builder().params(datasets -> this.loadParams(imprimeRelatorioDTO));
        for (SubRelatorioDTO subRelatorioDTO : imprimeRelatorioDTO.getSubRelatorios()) {
            if (BooleanUtils.isTrue((Boolean)subRelatorioDTO.getInternalData())) {
                try {
                    DatasetPackage datasetPackage = (DatasetPackage)this.objectMapper.readValue(subRelatorioDTO.getData(), DatasetPackage.class);
                    1 loader = new /* Unavailable Anonymous Inner Class!! */;
                    builder.add(subRelatorioDTO.getTableName(), subRelatorioDTO.getSubReportName(), (ReportDataLoader)loader);
                }
                catch (IOException e) {
                    LOG.error("Erro ao carregar o DatasetPackage para o subrelat\u00f3rio {}", (Object)subRelatorioDTO.getSubReportName(), (Object)e);
                }
                continue;
            }
            CustomSqlRowSetResultSetExtractor rowsetExtractor = new CustomSqlRowSetResultSetExtractor();
            if (this.hasCodigoBarras(subRelatorioDTO)) {
                rowsetExtractor = new CodigoBarrasGeneratorRowSetExtractor(subRelatorioDTO.getSubReportName());
            }
            builder.add(subRelatorioDTO.getTableName(), subRelatorioDTO.getSubReportName(), (ReportDataLoader)DatasetLoaders.jdbc((String)subRelatorioDTO.getSqlText(), Collections.emptyMap(), (DataSource)this.dataSource, (ResultSetExtractor)rowsetExtractor));
        }
        ReportDatasource datasource = builder.build();
        Path file = this.createTempReportFile(imprimeRelatorioDTO);
        try {
            EloReport eloReport = EloReportFactory.crystal().reportFile(() -> file.toFile()).setReportDatasource(datasource).build();
            bytes = eloReport.exportToPdf();
        }
        finally {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                LOG.error("Erro ao remover arquivo tempor\u00e1rio {}", (Object)file, (Object)e);
            }
        }
        return ReportExecutionResult.builder().content(bytes).fileName(this.getFileName(imprimeRelatorioDTO)).build();
    }

    private boolean hasCodigoBarras(SubRelatorioDTO subRelatorioDTO) {
        String tableName = subRelatorioDTO.getTableName();
        return "Bloqueto".equalsIgnoreCase(tableName) || "Capa_CodigoBarras".equalsIgnoreCase(tableName);
    }

    private String getFileName(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        String fileName = imprimeRelatorioDTO.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = UUID.randomUUID().toString();
        }
        if (!fileName.endsWith(".pdf")) {
            return String.format("%s.pdf", fileName);
        }
        return fileName;
    }

    private Set<Param> loadParams(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        return imprimeRelatorioDTO.getParametros().stream().map(ParametroDTO::toCrystalParam).collect(Collectors.toSet());
    }

    private Path createTempReportFile(ImprimeRelatorioDTO imprimeRelatorioDTO) {
        RelatorioArquivo relatorioArquivo;
        StringBuilder sql = new StringBuilder().append("       Select arq.modulo, arq.tiporelatorio, arq.relatorio, arq.arquivo, arq.path, arq.rpt, arq.dataarquivo ").append("    from RelArquivo arq").append("      left outer join RelRelatorioAgrupar sequencia").append("        on arq.Modulo = sequencia.Modulo and").append("           arq.TipoRelatorio = sequencia.TipoRelatorio and").append("           arq.Relatorio = sequencia.Relatorio and").append("           arq.Arquivo = sequencia.arquivo").append("      Where arq.Modulo = :modulo").append("        and arq.TipoRelatorio = :tiporelatorio").append("        and arq.Relatorio = :relatorio");
        if (this.hasSequenciaEmissao(imprimeRelatorioDTO)) {
            sql.append(" and sequencia.sequencia = :sequencia");
        }
        sql.append(" Order by arq.arquivo");
        Query query = this.em.createNativeQuery(sql.toString(), RelatorioArquivo.class).setParameter("modulo", (Object)imprimeRelatorioDTO.getModulo()).setParameter("tiporelatorio", (Object)imprimeRelatorioDTO.getTipoRelatorio().getCodigo()).setParameter("relatorio", (Object)imprimeRelatorioDTO.getRelatorio()).setMaxResults(1);
        if (this.hasSequenciaEmissao(imprimeRelatorioDTO)) {
            query.setParameter("sequencia", (Object)imprimeRelatorioDTO.getSequenciaTipoEmissao());
        }
        try {
            relatorioArquivo = (RelatorioArquivo)query.getSingleResult();
        }
        catch (NoResultException e) {
            throw new RptNotFoundException("Arquivo RTP n\u00e3o encontrado.", (Exception)((Object)e));
        }
        byte[] rpt = relatorioArquivo.getRpt();
        Path baseDir = Paths.get("rpts", new String[0]);
        if (!Files.exists(baseDir, new LinkOption[0])) {
            baseDir = Files.createDirectory(baseDir, new FileAttribute[0]);
        }
        Path file = Files.createTempFile(baseDir, "", ".rpt", new FileAttribute[0]);
        Files.write(file, rpt, new OpenOption[0]);
        return file;
    }

    private boolean hasSequenciaEmissao(ImprimeRelatorioDTO dto) {
        return Objects.nonNull(dto.getSequenciaTipoEmissao()) && dto.getSequenciaTipoEmissao() > 0;
    }
}

