/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.report.server.service;

import br.com.elotech.core.utils.GeraImagemCodigoBarras;
import br.com.elotech.report.CustomSqlRowSetResultSetExtractor;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.serial.SerialBlob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodigoBarrasGeneratorRowSetExtractor
extends CustomSqlRowSetResultSetExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CodigoBarrasGeneratorRowSetExtractor.class);
    private final String subreportName;

    public CodigoBarrasGeneratorRowSetExtractor(String subreportName) {
        this.subreportName = subreportName;
    }

    protected CachedRowSet modifySqlRowSet(CachedRowSet rowSet) throws SQLException {
        if (this.existsFieldCodigoBarras(rowSet)) {
            while (rowSet.next()) {
                String codigoBarras = rowSet.getString("codigobarras");
                byte[] imagem = GeraImagemCodigoBarras.getImagemAsBMP((String)codigoBarras);
                SerialBlob blobImagem = new SerialBlob(imagem);
                rowSet.updateBlob("codigobarrasimagem", (Blob)blobImagem);
                rowSet.updateRow();
            }
        }
        return super.modifySqlRowSet(rowSet);
    }

    private boolean existsFieldCodigoBarras(CachedRowSet rowSet) {
        try {
            rowSet.findColumn("CodigoBarrasImagem");
            rowSet.findColumn("CodigoBarras");
            return true;
        }
        catch (SQLException e) {
            LOG.error("Campos CodigoBarras e CodigoBarrasImagem n\u00e3o encontrados no sql do subrelat\u00f3rio {}", (Object)this.subreportName, (Object)e);
            return false;
        }
    }
}

