ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(e,t,n){"use strict";var i=e("../virtual_renderer").VirtualRenderer,o=e("../editor").Editor,r=e("../range").Range,s=e("../lib/event"),a=e("../lib/lang"),c=e("../lib/dom"),p=e("../config").nls,l=e("./../lib/useragent"),h=function(e){return"suggest-aria-id:".concat(e)},u=l.isSafari?"menu":"listbox",d=l.isSafari?"menuitem":"option",f=l.isSafari?"aria-current":"aria-selected",m=function(e){var t=new i(e);t.$maxLines=4;var n=new o(t);return n.setHighlightActiveLine(!1),n.setShowPrintMargin(!1),n.renderer.setShowGutter(!1),n.renderer.setHighlightGutterLine(!1),n.$mouseHandler.$focusTimeout=0,n.$highlightTagPending=!0,n},g=function(e){var t=c.createElement("div"),n=m(t);e&&e.appendChild(t),t.style.display="none",n.renderer.content.style.cursor="default",n.renderer.setStyle("ace_autocomplete"),n.renderer.$textLayer.element.setAttribute("role",u),n.renderer.$textLayer.element.setAttribute("aria-roledescription",p("autocomplete.popup.aria-roledescription","Autocomplete suggestions")),n.renderer.$textLayer.element.setAttribute("aria-label",p("autocomplete.popup.aria-label","Autocomplete suggestions")),n.renderer.textarea.setAttribute("aria-hidden","true"),n.setOption("displayIndentGuides",!1),n.setOption("dragDelay",150);var i,o=function(){};n.focus=o,n.$isFocused=!0,n.renderer.$cursorLayer.restartTimer=o,n.renderer.$cursorLayer.element.style.opacity="0",n.renderer.$maxLines=8,n.renderer.$keepTextAreaAtCursor=!1,n.setHighlightActiveLine(!1),n.session.highlight(""),n.session.$searchHighlight.clazz="ace_highlight-marker",n.on("mousedown",function(e){var t=e.getDocumentPosition();n.selection.moveToPosition(t),g.start.row=g.end.row=t.row,e.stop()});var l=new r(-1,0,-1,1/0),g=new r(-1,0,-1,1/0);g.id=n.session.addMarker(g,"ace_active-line","fullLine"),n.setSelectOnHover=function(e){e?l.id&&(n.session.removeMarker(l.id),l.id=null):l.id=n.session.addMarker(l,"ace_line-hover","fullLine")},n.setSelectOnHover(!1),n.on("mousemove",function(e){if(i){if(i.x!=e.x||i.y!=e.y){(i=e).scrollTop=n.renderer.scrollTop,n.isMouseOver=!0;var t=i.getDocumentPosition().row;l.start.row!=t&&(l.id||n.setRow(t),b(t))}}else i=e}),n.renderer.on("beforeRender",function(){if(i&&-1!=l.start.row){i.$pos=null;var e=i.getDocumentPosition().row;l.id||n.setRow(e),b(e,!0)}}),n.renderer.on("afterRender",function(){for(var e=n.renderer.$textLayer,t=e.config.firstRow,i=e.config.lastRow;t<=i;t++){var o=e.element.childNodes[t-e.config.firstRow];o.setAttribute("role",d),o.setAttribute("aria-roledescription",p("autocomplete.popup.item.aria-roledescription","item")),o.setAttribute("aria-setsize",n.data.length),o.setAttribute("aria-describedby","doc-tooltip"),o.setAttribute("aria-posinset",t+1);var r=n.getData(t);if(r){var s="".concat(r.caption||r.value).concat(r.meta?", ".concat(r.meta):"");o.setAttribute("aria-label",s)}o.querySelectorAll(".ace_completion-highlight").forEach(function(e){e.setAttribute("role","mark")})}}),n.renderer.on("afterRender",function(){var e=n.getRow(),t=n.renderer.$textLayer,i=t.element.childNodes[e-t.config.firstRow],o=document.activeElement;if(i!==n.selectedNode&&n.selectedNode&&(c.removeCssClass(n.selectedNode,"ace_selected"),n.selectedNode.removeAttribute(f),n.selectedNode.removeAttribute("id")),o.removeAttribute("aria-activedescendant"),n.selectedNode=i,i){var r=h(e);c.addCssClass(i,"ace_selected"),i.id=r,t.element.setAttribute("aria-activedescendant",r),o.setAttribute("aria-activedescendant",r),i.setAttribute(f,"true")}});var v=function(){b(-1)},b=function(e,t){e!==l.start.row&&(l.start.row=l.end.row=e,t||n.session._emit("changeBackMarker"),n._emit("changeHoverMarker"))};n.getHoveredRow=function(){return l.start.row},s.addListener(n.container,"mouseout",function(){n.isMouseOver=!1,v()}),n.on("hide",v),n.on("changeSelection",v),n.session.doc.getLength=function(){return n.data.length},n.session.doc.getLine=function(e){var t=n.data[e];return"string"==typeof t?t:t&&t.value||""};var x=n.session.bgTokenizer;return x.$tokenizeRow=function(e){var t=n.data[e],i=[];if(!t)return i;"string"==typeof t&&(t={value:t});var o=t.caption||t.value||t.name;function r(e,n){e&&i.push({type:(t.className||"")+(n||""),value:e})}for(var s=o.toLowerCase(),a=(n.filterText||"").toLowerCase(),c=0,p=0,l=0;l<=a.length;l++)if(l!=p&&(t.matchMask&1<<l||l==a.length)){var h=a.slice(p,l);p=l;var u=s.indexOf(h,c);if(-1==u)continue;r(o.slice(c,u),""),c=u+h.length,r(o.slice(u,c),"completion-highlight")}return r(o.slice(c,o.length),""),i.push({type:"completion-spacer",value:" "}),t.meta&&i.push({type:"completion-meta",value:t.meta}),t.message&&i.push({type:"completion-message",value:t.message}),i},x.$updateOnChange=o,x.start=o,n.session.$computeWidth=function(){return this.screenWidth=0},n.isOpen=!1,n.isTopdown=!1,n.autoSelect=!0,n.filterText="",n.isMouseOver=!1,n.data=[],n.setData=function(e,t){n.filterText=t||"",n.setValue(a.stringRepeat("\n",e.length),-1),n.data=e||[],n.setRow(0)},n.getData=function(e){return n.data[e]},n.getRow=function(){return g.start.row},n.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,e)),g.start.row!=e&&(n.selection.clearSelection(),g.start.row=g.end.row=e||0,n.session._emit("changeBackMarker"),n.moveCursorTo(e||0,0),n.isOpen&&n._signal("select"))},n.on("changeSelection",function(){n.isOpen&&n.setRow(n.selection.lead.row),n.renderer.scrollCursorIntoView()}),n.hide=function(){this.container.style.display="none",n.anchorPos=null,n.anchor=null,n.isOpen&&(n.isOpen=!1,this._signal("hide"))},n.tryShow=function(e,t,o,r){if(!r&&n.isOpen&&n.anchorPos&&n.anchor&&n.anchorPos.top===e.top&&n.anchorPos.left===e.left&&n.anchor===o)return!0;var s=this.container,a=this.renderer.scrollBar.width||10,c=window.innerHeight-a,p=window.innerWidth-a,l=this.renderer,h=l.$maxLines*t*1.4,u={top:0,bottom:0,left:0},d=c-e.top-3*this.$borderSize-t,f=e.top-3*this.$borderSize;o||(o=f<=d||d>=h?"bottom":"top"),"top"===o?(u.bottom=e.top-this.$borderSize,u.top=u.bottom-h):"bottom"===o&&(u.top=e.top+t+this.$borderSize,u.bottom=u.top+h);var m=u.top>=0&&u.bottom<=c;if(!r&&!m)return!1;l.$maxPixelHeight=m?null:"top"===o?f:d,s.style.display="";var g=s.offsetParent&&s.offsetParent.getBoundingClientRect();"top"===o?(s.style.top="",s.style.bottom=c+a-u.bottom-(g?c+a-g.bottom:0)+"px",n.isTopdown=!1):(s.style.top=u.top-(g?g.top:0)+"px",s.style.bottom="",n.isTopdown=!0);var v=e.left;return v+s.offsetWidth>p&&(v=p-s.offsetWidth),s.style.left=v-(g?g.left:0)+"px",s.style.right="",n.isOpen||(n.isOpen=!0,this._signal("show"),i=null),n.anchorPos=e,n.anchor=o,!0},n.show=function(e,t,n){this.tryShow(e,t,n?"bottom":void 0,!0)},n.goTo=function(e){var t=this.getRow(),n=this.session.getLength()-1;switch(e){case"up":t=t<=0?n:t-1;break;case"down":t=t>=n?-1:t+1;break;case"start":t=0;break;case"end":t=n}this.setRow(t)},n.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},n.$imageSize=0,n.$borderSize=1,n};c.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: absolute;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),t.AcePopup=g,t.$singleLineEditor=m,t.getAriaId=h}),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(e,t,n){"use strict";var i=e("./lib/dom"),o=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,s=e("./lib/lang"),a=e("./range").Range,c=e("./range_list").RangeList,p=e("./keyboard/hash_handler").HashHandler,l=e("./tokenizer").Tokenizer,h=e("./clipboard"),u={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,n){var i=e.session.getTextRange();return n?i.replace(/\n\r?([ \t]*\S)/g,"\n"+n+"$1"):i},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return h.getText&&h.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:d.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:d.bind(null,{year:"2-digit"}),CURRENT_MONTH:d.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:d.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:d.bind(null,{month:"short"}),CURRENT_DATE:d.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:d.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:d.bind(null,{weekday:"short"}),CURRENT_HOUR:d.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:d.bind(null,{minute:"2-digit"}),CURRENT_SECOND:d.bind(null,{second:"2-digit"})};function d(e){var t=(new Date).toLocaleString("en-us",e);return 1==t.length?"0"+t:t}u.SELECTED_TEXT=u.SELECTION;var f=function(){function e(){this.snippetMap={},this.snippetNameMap={},this.variables=u}return e.prototype.getTokenizer=function(){return e.$tokenizer||this.createTokenizer()},e.prototype.createTokenizer=function(){function t(e){return e=e.substr(1),/^\d+$/.test(e)?[{tabstopId:parseInt(e,10)}]:[{text:e}]}function n(e){return"(?:[^\\\\"+e+"]|\\\\.)"}var i={regex:"/("+n("/")+"+)/",onMatch:function(e,t,n){var i=n[0];return i.fmtString=!0,i.guard=e.slice(1,-1),i.flag="",""},next:"formatString"};return e.$tokenizer=new l({start:[{regex:/\\./,onMatch:function(e,t,n){var i=e[1];return("}"==i&&n.length||-1!="`$\\".indexOf(i))&&(e=i),[e]}},{regex:/}/,onMatch:function(e,t,n){return[n.length?n.shift():e]}},{regex:/\$(?:\d+|\w+)/,onMatch:t},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(e,n,i){var o=t(e.substr(1));return i.unshift(o[0]),o},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+n("\\|")+"*\\|",onMatch:function(e,t,n){var i=e.slice(1,-1).replace(/\\[,|\\]|,/g,function(e){return 2==e.length?e[1]:"\0"}).split("\0").map(function(e){return{value:e}});return n[0].choices=i,[i[0]]},next:"start"},i,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(e,t,n){return n.length&&n[0].expectElse?(n[0].expectElse=!1,n[0].ifEnd={elseEnd:n[0]},[n[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(e,t,n){var i=e[1];return"}"==i&&n.length||-1!="`$\\".indexOf(i)?e=i:"n"==i?e="\n":"t"==i?e="\t":-1!="ulULE".indexOf(i)&&(e={changeCase:i,local:i>"a"}),[e]}},{regex:"/\\w*}",onMatch:function(e,t,n){var i=n.shift();return i&&(i.flag=e.slice(1,-1)),this.next=i&&i.tabstopId?"start":"",[i||e]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(e,t,n){return[{text:e.slice(1)}]}},{regex:/\${\w+/,onMatch:function(e,t,n){var i={text:e.slice(2)};return n.unshift(i),[i]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(e,t,n){var i=n.shift();return this.next=i&&i.tabstopId?"start":"",[i||e]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(e,t,n){return n[0].formatFunction=e.slice(2,-1),[n.shift()]},next:"formatString"},i,{regex:/:[\?\-+]?/,onMatch:function(e,t,n){"+"==e[1]&&(n[0].ifEnd=n[0]),"?"==e[1]&&(n[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]}),e.$tokenizer},e.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(e){return e.value||e})},e.prototype.getVariableValue=function(e,t,n){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var i=this.variables[t];return"function"==typeof i&&(i=this.variables[t](e,t,n)),null==i?"":i},e.prototype.tmStrFormat=function(e,t,n){if(!t.fmt)return e;var i=t.flag||"",o=t.guard;o=new RegExp(o,i.replace(/[^gim]/g,""));var r="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,s=this,a=e.replace(o,function(){var e=s.variables.__;s.variables.__=[].slice.call(arguments);for(var t=s.resolveVariables(r,n),i="E",o=0;o<t.length;o++){var a=t[o];if("object"==typeof a)if(t[o]="",a.changeCase&&a.local){var c=t[o+1];c&&"string"==typeof c&&("u"==a.changeCase?t[o]=c[0].toUpperCase():t[o]=c[0].toLowerCase(),t[o+1]=c.substr(1))}else a.changeCase&&(i=a.changeCase);else"U"==i?t[o]=a.toUpperCase():"L"==i&&(t[o]=a.toLowerCase())}return s.variables.__=e,t.join("")});return a},e.prototype.tmFormatFunction=function(e,t,n){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},e.prototype.resolveVariables=function(e,t){for(var n=[],i="",o=!0,r=0;r<e.length;r++){var s=e[r];if("string"!=typeof s){if(s){if(o=!1,s.fmtString){var a=e.indexOf(s,r+1);-1==a&&(a=e.length),s.fmt=e.slice(r+1,a),r=a}if(s.text){var c=this.getVariableValue(t,s.text,i)+"";s.fmtString&&(c=this.tmStrFormat(c,s,t)),s.formatFunction&&(c=this.tmFormatFunction(c,s,t)),c&&!s.ifEnd?(n.push(c),p(s)):!c&&s.ifEnd&&p(s.ifEnd)}else s.elseEnd?p(s.elseEnd):(null!=s.tabstopId||null!=s.changeCase)&&n.push(s)}}else n.push(s),"\n"==s?(o=!0,i=""):o&&(i=/^\t*/.exec(s)[0],o=/\S/.test(s))}function p(t){var n=e.indexOf(t,r+1);-1!=n&&(r=n)}return n},e.prototype.getDisplayTextForSnippet=function(e,t){return m.call(this,e,t).text},e.prototype.insertSnippetForSelection=function(e,t,n){void 0===n&&(n={});var i=m.call(this,e,t,n),o=e.getSelectionRange(),r=e.session.replace(o,i.text),s=new g(e),a=e.inVirtualSelectionMode&&e.selection.index;s.addTabstops(i.tabstops,o.start,r,a)},e.prototype.insertSnippet=function(e,t,n){void 0===n&&(n={});var i=this;if(e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,t,n);e.forEachSelection(function(){i.insertSnippetForSelection(e,t,n)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},e.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"!==t||e.session.$mode.inlinePhp||(t="html");var n=e.getCursorPosition(),i=e.session.getState(n.row);"object"===typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?t="javascript":"css-"==i.substring(0,4)?t="css":"php-"==i.substring(0,4)&&(t="php"))}return t},e.prototype.getActiveScopes=function(e){var t=this.$getScope(e),n=[t],i=this.snippetMap;return i[t]&&i[t].includeScopes&&n.push.apply(n,i[t].includeScopes),n.push("_"),n},e.prototype.expandWithTab=function(e,t){var n=this,i=e.forEachSelection(function(){return n.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},e.prototype.expandSnippetForSelection=function(e,t){var n,i=e.getCursorPosition(),o=e.session.getLine(i.row),r=o.substring(0,i.column),s=o.substr(i.column),a=this.snippetMap;return this.getActiveScopes(e).some(function(e){var t=a[e];return t&&(n=this.findMatchingSnippet(t,r,s)),!!n},this),!!n&&(t&&t.dryRun||(e.session.doc.removeInLine(i.row,i.column-n.replaceBefore.length,i.column+n.replaceAfter.length),this.variables.M__=n.matchBefore,this.variables.T__=n.matchAfter,this.insertSnippetForSelection(e,n.content),this.variables.M__=this.variables.T__=null),!0)},e.prototype.findMatchingSnippet=function(e,t,n){for(var i=e.length;i--;){var o=e[i];if((!o.startRe||o.startRe.test(t))&&((!o.endRe||o.endRe.test(n))&&(o.startRe||o.endRe)))return o.matchBefore=o.startRe?o.startRe.exec(t):[""],o.matchAfter=o.endRe?o.endRe.exec(n):[""],o.replaceBefore=o.triggerRe?o.triggerRe.exec(t)[0]:"",o.replaceAfter=o.endTriggerRe?o.endTriggerRe.exec(n)[0]:"",o}},e.prototype.register=function(e,t){var n=this.snippetMap,i=this.snippetNameMap,o=this;function r(e){return e&&!/^\^?\(.*\)\$?$|^\\b$/.test(e)&&(e="(?:"+e+")"),e||""}function a(e,t,n){return e=r(e),t=r(t),n?(e=t+e)&&"$"!=e[e.length-1]&&(e+="$"):(e+=t)&&"^"!=e[0]&&(e="^"+e),new RegExp(e)}function c(e){e.scope||(e.scope=t||"_"),t=e.scope,n[t]||(n[t]=[],i[t]={});var r=i[t];if(e.name){var c=r[e.name];c&&o.unregister(c),r[e.name]=e}n[t].push(e),e.prefix&&(e.tabTrigger=e.prefix),!e.content&&e.body&&(e.content=Array.isArray(e.body)?e.body.join("\n"):e.body),e.tabTrigger&&!e.trigger&&(!e.guard&&/^\w/.test(e.tabTrigger)&&(e.guard="\\b"),e.trigger=s.escapeRegExp(e.tabTrigger)),(e.trigger||e.guard||e.endTrigger||e.endGuard)&&(e.startRe=a(e.trigger,e.guard,!0),e.triggerRe=new RegExp(e.trigger),e.endRe=a(e.endTrigger,e.endGuard,!0),e.endTriggerRe=new RegExp(e.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(c):Object.keys(e).forEach(function(t){c(e[t])}),this._signal("registerSnippets",{scope:t})},e.prototype.unregister=function(e,t){var n=this.snippetMap,i=this.snippetNameMap;function o(e){var o=i[e.scope||t];if(o&&o[e.name]){delete o[e.name];var r=n[e.scope||t],s=r&&r.indexOf(e);s>=0&&r.splice(s,1)}}e.content?o(e):Array.isArray(e)&&e.forEach(o)},e.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var t,n=[],i={},o=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;t=o.exec(e);){if(t[1])try{i=JSON.parse(t[1]),n.push(i)}catch(c){}if(t[4])i.content=t[4].replace(/^\t/gm,""),n.push(i),i={};else{var r=t[2],s=t[3];if("regex"==r){var a=/\/((?:[^\/\\]|\\.)*)|$/g;i.guard=a.exec(s)[1],i.trigger=a.exec(s)[1],i.endTrigger=a.exec(s)[1],i.endGuard=a.exec(s)[1]}else"snippet"==r?(i.tabTrigger=s.match(/^\S*/)[0],i.name||(i.name=s)):r&&(i[r]=s)}}return n},e.prototype.getSnippetByName=function(e,t){var n,i=this.snippetNameMap;return this.getActiveScopes(t).some(function(t){var o=i[t];return o&&(n=o[e]),!!n},this),n},e}();o.implement(f.prototype,r);var m=function(e,t,n){void 0===n&&(n={});var i=e.getCursorPosition(),o=e.session.getLine(i.row),r=e.session.getTabString(),s=o.match(/^\s*/)[0];i.column<s.length&&(s=s.slice(0,i.column)),t=t.replace(/\r/g,"");var a=this.tokenizeTmSnippet(t);a=(a=this.resolveVariables(a,e)).map(function(e){return"\n"!=e||n.excludeExtraIndent?"string"==typeof e?e.replace(/\t/g,r):e:e+s});var c=[];a.forEach(function(e,t){if("object"==typeof e){var n=e.tabstopId,i=c[n];if(i||((i=c[n]=[]).index=n,i.value="",i.parents={}),-1===i.indexOf(e)){e.choices&&!i.choices&&(i.choices=e.choices),i.push(e);var o=a.indexOf(e,t+1);if(-1!==o){var r=a.slice(t+1,o);r.some(function(e){return"object"===typeof e})&&!i.value?i.value=r:!r.length||i.value&&"string"===typeof i.value||(i.value=r.join(""))}}}}),c.forEach(function(e){e.length=0});var p={};function l(e){for(var t=[],n=0;n<e.length;n++){var i=e[n];if("object"==typeof i){if(p[i.tabstopId])continue;i=t[e.lastIndexOf(i,n-1)]||{tabstopId:i.tabstopId}}t[n]=i}return t}for(var h=0;h<a.length;h++){var u=a[h];if("object"==typeof u){var d=u.tabstopId,f=c[d],m=a.indexOf(u,h+1);if(p[d])p[d]===u&&(delete p[d],Object.keys(p).forEach(function(e){f.parents[e]=!0}));else{p[d]=u;var g=f.value;"string"!==typeof g?g=l(g):u.fmt&&(g=this.tmStrFormat(g,u,e)),a.splice.apply(a,[h+1,Math.max(0,m-h)].concat(g,u)),-1===f.indexOf(u)&&f.push(u)}}}var v=0,b=0,x="";return a.forEach(function(e){if("string"===typeof e){var t=e.split("\n");t.length>1?(b=t[t.length-1].length,v+=t.length-1):b+=e.length,x+=e}else e&&(e.start?e.end={row:v,column:b}:e.start={row:v,column:b})}),{text:x,tabstops:c,tokens:a}},g=function(){function e(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=s.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}return e.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},e.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},e.prototype.onChange=function(e){for(var t="r"==e.action[0],n=this.selectedTabstop||{},i=n.parents||{},o=this.tabstops.slice(),r=0;r<o.length;r++){var s=o[r],a=s==n||i[s.index];if(s.rangeList.$bias=a?0:1,"remove"==e.action&&s!==n){var c=s.parents&&s.parents[n.index],p=s.rangeList.pointIndex(e.start,c);p=p<0?-p-1:p+1;var l=s.rangeList.pointIndex(e.end,c);l=l<0?-l-1:l-1;for(var h=s.rangeList.ranges.slice(p,l),u=0;u<h.length;u++)this.removeRange(h[u])}s.rangeList.$onChange(e)}var d=this.session;this.$inChange||!t||1!=d.getLength()||d.getValue()||this.detach()},e.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var n=this.session,i=n.getTextRange(e.firstNonLinked),o=0;o<e.length;o++){var r=e[o];if(r.linked){var s=r.original,a=t.snippetManager.tmStrFormat(i,s,this.editor);n.replace(r,a)}}this.$inChange=!1}},e.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},e.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,n=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var o=this.ranges[i].contains(e.row,e.column),r=n||this.ranges[i].contains(t.row,t.column);if(o&&r)return}this.detach()}},e.prototype.onChangeSession=function(){this.detach()},e.prototype.tabNext=function(e){var t=this.tabstops.length,n=this.index+(e||1);(n=Math.min(Math.max(n,1),t))==t&&(n=0),this.selectTabstop(n),this.updateTabstopMarkers(),0===n&&this.detach()},e.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var n=t.firstNonLinked||t;if(t.choices&&(n.cursor=n.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(n);else{var i=this.editor.multiSelect;i.toSingleRange(n);for(var o=0;o<t.length;o++)t.hasLinkedRanges&&t[o].linked||i.addRange(t[o].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},e.prototype.addTabstops=function(e,t,n){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var o=a.fromPoints(n,n);b(o.start,t),b(o.end,t),e[0]=[o],e[0].index=0}var r=[this.index+1,0],s=this.ranges,p=this.snippetId=(this.snippetId||0)+1;e.forEach(function(e,n){var o=this.$openTabstops[n]||e;o.snippetId=p;for(var l=0;l<e.length;l++){var h=e[l],u=a.fromPoints(h.start,h.end||h.start);v(u.start,t),v(u.end,t),u.original=h,u.tabstop=o,s.push(u),o!=e?o.unshift(u):o[l]=u,h.fmtString||o.firstNonLinked&&i?(u.linked=!0,o.hasLinkedRanges=!0):o.firstNonLinked||(o.firstNonLinked=u)}o.firstNonLinked||(o.hasLinkedRanges=!1),o===e&&(r.push(o),this.$openTabstops[n]=o),this.addTabstopMarkers(o),o.rangeList=o.rangeList||new c,o.rangeList.$bias=0,o.rangeList.addList(o)},this),r.length>2&&(this.tabstops.length&&r.push(r.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,r))},e.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){e.markerId||(e.markerId=t.addMarker(e,"ace_snippet-marker","text"))})},e.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){t.removeMarker(e.markerId),e.markerId=null})},e.prototype.updateTabstopMarkers=function(){if(this.selectedTabstop){var e=this.selectedTabstop.snippetId;0===this.selectedTabstop.index&&e--,this.tabstops.forEach(function(t){t.snippetId===e?this.addTabstopMarkers(t):this.removeTabstopMarkers(t)},this)}},e.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},e}();g.prototype.keyboardHandler=new p,g.prototype.keyboardHandler.bindKeys({Tab:function(e){t.snippetManager&&t.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var v=function(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row},b=function(e,t){e.row==t.row&&(e.column-=t.column),e.row-=t.row};i.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),t.snippetManager=new f;var x=e("./editor").Editor;(function(){this.insertSnippet=function(e,n){return t.snippetManager.insertSnippet(this,e,n)},this.expandSnippet=function(e){return t.snippetManager.expandWithTab(this,e)}}).call(x.prototype)}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(e,t,n){"use strict";var i=function(){function e(e){this.editor=e,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return e.prototype.setScreenReaderContent=function(e){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var e=this.popup.getRow(),t=this.popup.renderer.$textLayer,n=t.element.childNodes[e-t.config.firstRow];if(n){for(var i="doc-tooltip ",o=0;o<this._lines.length;o++)i+="ace-inline-screenreader-line-".concat(o," ");n.setAttribute("aria-describedby",i)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=e.split(/\r\n|\r|\n/);var t=this.createCodeBlock();this.screenReaderDiv.appendChild(t)},e.prototype.destroy=function(){this.screenReaderDiv.remove()},e.prototype.createCodeBlock=function(){var e=document.createElement("pre");e.setAttribute("id","ace-inline-screenreader");for(var t=0;t<this._lines.length;t++){var n=document.createElement("code");n.setAttribute("id","ace-inline-screenreader-line-".concat(t));var i=document.createTextNode(this._lines[t]);n.appendChild(i),e.appendChild(n)}return e},e}();t.AceInlineScreenReader=i}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(e,t,n){"use strict";var i=e("../snippets").snippetManager,o=e("./inline_screenreader").AceInlineScreenReader,r=function(){function e(){this.editor=null}return e.prototype.show=function(e,t,n){if(n=n||"",e&&this.editor&&this.editor!==e&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!e||!t)return!1;this.inlineScreenReader||(this.inlineScreenReader=new o(e));var r=t.snippet?i.getDisplayTextForSnippet(e,t.snippet):t.value;return!(t.hideInlinePreview||!r||!r.startsWith(n))&&(this.editor=e,this.inlineScreenReader.setScreenReaderContent(r),""===(r=r.slice(n.length))?e.removeGhostText():e.setGhostText(r),!0)},e.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},e.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},e.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},e}();t.AceInline=r}),ace.define("ace/autocomplete/util",["require","exports","module"],function(e,t,n){"use strict";t.parForEach=function(e,t,n){var i=0,o=e.length;0===o&&n();for(var r=0;r<o;r++)t(e[r],function(e,t){++i===o&&n(e,t)})};var i=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;t.retrievePrecedingIdentifier=function(e,t,n){n=n||i;for(var o=[],r=t-1;r>=0&&n.test(e[r]);r--)o.push(e[r]);return o.reverse().join("")},t.retrieveFollowingIdentifier=function(e,t,n){n=n||i;for(var o=[],r=t;r<e.length&&n.test(e[r]);r++)o.push(e[r]);return o},t.getCompletionPrefix=function(e){var t,n=e.getCursorPosition(),i=e.session.getLine(n.row);return e.completers.forEach(function(e){e.identifierRegexps&&e.identifierRegexps.forEach(function(e){!t&&e&&(t=this.retrievePrecedingIdentifier(i,n.column,e))}.bind(this))}.bind(this)),t||this.retrievePrecedingIdentifier(i,n.column)},t.triggerAutocomplete=function(e,t){t=null==t?e.session.getPrecedingCharacter():t;return e.completers.some(function(e){if(e.triggerCharacters&&Array.isArray(e.triggerCharacters))return e.triggerCharacters.includes(t)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(e,t,n){"use strict";var i=e("./keyboard/hash_handler").HashHandler,o=e("./autocomplete/popup").AcePopup,r=e("./autocomplete/inline").AceInline,s=e("./autocomplete/popup").getAriaId,a=e("./autocomplete/util"),c=e("./lib/lang"),p=e("./lib/dom"),l=e("./snippets").snippetManager,h=e("./config"),u=e("./lib/event"),d=e("./lib/scroll").preventParentScroll,f=function(e,t){t.completer&&t.completer.destroy()},m=function(){function e(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new i,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.hasSeen=new Set,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=c.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=c.delayedCall(this.updateDocTooltip.bind(this),50),this.popupTimer=c.delayedCall(this.$updatePopupPosition.bind(this),50),this.stickySelectionTimer=c.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=c.delayedCall(function(){var t=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!t||0===this.editor.completers.length||(this.completions=new v(e.completionsForLoading),this.openPopup(this.editor,t.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(e,"completionsForLoading",{get:function(){return[{caption:h.nls("autocomplete.loading","Loading..."),value:""}]},enumerable:!1,configurable:!0}),e.prototype.$init=function(){return this.popup=new o(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(e){this.insertMatch(),e.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),u.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this)),this.popup},e.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new r,this.inlineRenderer},e.prototype.getPopup=function(){return this.popup||this.$init()},e.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.popupTimer.cancel(),this.stickySelection=!1},e.prototype.$seen=function(e){!this.hasSeen.has(e)&&e&&e.completer&&e.completer.onSeen&&"function"===typeof e.completer.onSeen&&(e.completer.onSeen(this.editor,e),this.hasSeen.add(e))},e.prototype.$onPopupChange=function(e){if(this.inlineRenderer&&this.inlineEnabled){var t=e?null:this.popup.getData(this.popup.getRow());if(this.$updateGhostText(t),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null);this.popupTimer.schedule(),this.tooltipTimer.schedule()}else this.popupTimer.call(null,null),this.tooltipTimer.call(null,null)},e.prototype.$updateGhostText=function(e){var t=this.base.row,n=this.base.column,i=this.editor.getCursorPosition().column,o=this.editor.session.getLine(t).slice(n,i);this.inlineRenderer.show(this.editor,e,o)?this.$seen(e):this.inlineRenderer.hide()},e.prototype.$onPopupRender=function(){var e=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&this.completions.filtered.length>0)for(var t=this.popup.getFirstVisibleRow();t<=this.popup.getLastVisibleRow();t++){var n=this.popup.getData(t);!n||e&&!n.hideInlinePreview||this.$seen(n)}},e.prototype.$onPopupShow=function(e){this.$onPopupChange(e),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},e.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var e=this.editor.container.parentNode,t=[];e;)t.push(e),e.addEventListener("scroll",this.onLayoutChange,{passive:!0}),e=e.parentNode;this.$elements=t}},e.prototype.unObserveLayoutChanges=function(){var e=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(t){t.removeEventListener("scroll",e.onLayoutChange,{passive:!0})}),this.$elements=null},e.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},e.prototype.$updatePopupPosition=function(){var e=this.editor,t=e.renderer,n=t.layerConfig.lineHeight,i=t.$cursorLayer.getPixelPosition(this.base,!0);i.left-=this.popup.getTextLeftOffset();var o=e.container.getBoundingClientRect();i.top+=o.top-t.layerConfig.offset,i.left+=o.left-e.renderer.scrollLeft,i.left+=t.gutterWidth;var r={top:i.top,left:i.left};t.$ghostText&&t.$ghostTextWidget&&this.base.row===t.$ghostText.position.row&&(r.top+=t.$ghostTextWidget.el.offsetHeight);var s=e.container.getBoundingClientRect().bottom-n,a=s<r.top?{top:s,left:r.left}:r;this.popup.tryShow(a,n,"bottom")||this.popup.tryShow(i,n,"top")||this.popup.show(i,n)},e.prototype.openPopup=function(e,t,n){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var i,o=this.popup.getRow(),r=this.popup.data[o];this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:s(this.popup.getRow()),inline:this.inlineEnabled}),e.keyBinding.addKeyboardHandler(this.keyboardHandler),this.stickySelection&&(i=this.popup.data.indexOf(r)),i&&-1!==i||(i=0),this.popup.setRow(this.autoSelect?i:-1),i===o&&r!==this.completions.filtered[i]&&this.$onPopupChange();var a=this.inlineRenderer&&this.inlineEnabled;if(i===o&&a){var c=this.popup.getData(this.popup.getRow());this.$updateGhostText(c)}n||(this.popup.setTheme(e.getTheme()),this.popup.setFontSize(e.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},e.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.popup&&this.popup.renderer&&this.popup.renderer.off("afterRender",this.$onPopupRender),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},e.prototype.changeListener=function(e){var t=this.editor.selection.lead;(t.row!=this.base.row||t.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},e.prototype.blurListener=function(e){var t=document.activeElement,n=this.editor.textInput.getElement(),i=e.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(e.relatedTarget),o=this.popup&&this.popup.container;t==n||t.parentNode==o||i||t==this.tooltipNode||e.relatedTarget==n||this.detach()},e.prototype.mousedownListener=function(e){this.detach()},e.prototype.mousewheelListener=function(e){this.popup&&!this.popup.isMouseOver&&this.detach()},e.prototype.mouseOutListener=function(e){this.popup.isOpen&&this.$updatePopupPosition()},e.prototype.goTo=function(e){this.popup.goTo(e)},e.prototype.insertMatch=function(e,t){if(e||(e=this.popup.getData(this.popup.getRow())),!e)return!1;if(""===e.value)return this.detach();var n=this.completions,i=this.getCompletionProvider().insertMatch(this.editor,e,n.filterText,t);return this.completions==n&&this.detach(),i},e.prototype.showPopup=function(e,t){this.editor&&this.detach(),this.activated=!0,this.editor=e,e.completer!=this&&(e.completer&&e.completer.detach(),e.completer=this),e.on("changeSelection",this.changeListener),e.on("blur",this.blurListener),e.on("mousedown",this.mousedownListener),e.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,t)},e.prototype.getCompletionProvider=function(e){return this.completionProvider||(this.completionProvider=new g(e)),this.completionProvider},e.prototype.gatherCompletions=function(e,t){return this.getCompletionProvider().gatherCompletions(e,t)},e.prototype.updateCompletions=function(t,n){if(t&&this.base&&this.completions){var i=this.editor.getCursorPosition();if((r=this.editor.session.getTextRange({start:this.base,end:i}))==this.completions.filterText)return;return this.completions.setFilter(r),this.completions.filtered.length?1!=this.completions.filtered.length||this.completions.filtered[0].value!=r||this.completions.filtered[0].snippet?void this.openPopup(this.editor,r,t):this.detach():this.detach()}if(n&&n.matches){i=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(i.row,i.column),this.base.$insertRight=!0,this.completions=new v(n.matches),this.getCompletionProvider().completions=this.completions,this.openPopup(this.editor,"",t)}var o=this.editor.getSession(),r=(i=this.editor.getCursorPosition(),a.getCompletionPrefix(this.editor));this.base=o.doc.createAnchor(i.row,i.column-r.length),this.base.$insertRight=!0;var s={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:r,pos:i}).provideCompletions(this.editor,s,function(n,i,o){var r=i.filtered,s=a.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),o){if(!r.length){var c=!this.autoShown&&this.emptyMessage;if("function"==typeof c&&(c=this.emptyMessage(s)),c){var p=[{caption:c,value:""}];return this.completions=new v(p),this.openPopup(this.editor,s,t),this.popup.renderer.setStyle("ace_loading",!1),void this.popup.renderer.setStyle("ace_empty-message",!0)}return this.detach()}if(1==r.length&&r[0].value==s&&!r[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==r.length)return this.insertMatch(r[0])}this.completions=!o&&this.showLoadingState?new v(e.completionsForLoading.concat(r),i.filterText):i,this.openPopup(this.editor,s,t),this.popup.renderer.setStyle("ace_empty-message",!1),this.popup.renderer.setStyle("ace_loading",!o)}.bind(this)),!this.showLoadingState||this.autoShown||this.popup&&this.popup.isOpen||this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},e.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},e.prototype.updateDocTooltip=function(){var e=this.popup,t=this.completions&&this.completions.filtered,n=t&&(t[e.getHoveredRow()]||t[e.getRow()]),i=null;if(!n||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var o=this.editor.completers.length,r=0;r<o;r++){var s=this.editor.completers[r];if(s.getDocTooltip&&n.completerId===s.id){i=s.getDocTooltip(n);break}}if(i||"string"==typeof n||(i=n),"string"==typeof i&&(i={docText:i}),!i||!i.docHTML&&!i.docText)return this.hideDocTooltip();this.showDocTooltip(i)},e.prototype.showDocTooltip=function(e){this.tooltipNode||(this.tooltipNode=p.createElement("div"),this.tooltipNode.style.margin="0",this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.style.overscrollBehavior="contain",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"),this.tooltipNode.addEventListener("wheel",d));var t=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(t.isDark?"ace_dark ":"")+(t.cssClass||"");var n=this.tooltipNode;e.docHTML?n.innerHTML=e.docHTML:e.docText&&(n.textContent=e.docText),n.parentNode||this.popup.container.appendChild(this.tooltipNode);var i=this.popup,o=i.container.getBoundingClientRect(),r=400,s=300,a=i.renderer.scrollBar.width||10,c=o.left,l=window.innerWidth-o.right-a,h=i.isTopdown?o.top:window.innerHeight-a-o.bottom,u=[Math.min(l/r,1),Math.min(c/r,1),Math.min(h/s*.9)],f=Math.max.apply(Math,u),m=n.style;m.display="block",f==u[0]?(m.left=o.right+1+"px",m.right="",m.maxWidth=r*f+"px",m.top=o.top+"px",m.bottom="",m.maxHeight=Math.min(window.innerHeight-a-o.top,s)+"px"):f==u[1]?(m.right=window.innerWidth-o.left+"px",m.left="",m.maxWidth=r*f+"px",m.top=o.top+"px",m.bottom="",m.maxHeight=Math.min(window.innerHeight-a-o.top,s)+"px"):f==u[2]&&(m.left=window.innerWidth-o.left+"px",m.maxWidth=Math.min(r,window.innerWidth)+"px",i.isTopdown?(m.top=o.bottom+"px",m.left=o.left+"px",m.right="",m.bottom="",m.maxHeight=Math.min(window.innerHeight-a-o.bottom,s)+"px"):(m.top=i.container.offsetTop-n.offsetHeight+"px",m.left=o.left+"px",m.right="",m.bottom="",m.maxHeight=Math.min(i.container.offsetTop,s)+"px"))},e.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var e=this.tooltipNode;this.editor.isFocused()||document.activeElement!=e||this.editor.focus(),this.tooltipNode=null,e.parentNode&&e.parentNode.removeChild(e)}},e.prototype.onTooltipClick=function(e){for(var t=e.target;t&&t!=this.tooltipNode;){if("A"==t.nodeName&&t.href){t.rel="noreferrer",t.target="_blank";break}t=t.parentNode}},e.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var e=this.popup.container;e&&e.parentNode&&e.parentNode.removeChild(e)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",f),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},e.for=function(t){return t.completer instanceof e||(t.completer&&(t.completer.destroy(),t.completer=null),h.get("sharedPopups")?(e.$sharedInstance||(e.$sharedInstance=new e),t.completer=e.$sharedInstance):(t.completer=new e,t.once("destroy",f))),t.completer},e}();m.prototype.commands={Up:function(e){e.completer.goTo("up")},Down:function(e){e.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end")},Esc:function(e){e.completer.detach()},Return:function(e){return e.completer.insertMatch()},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(e){var t=e.completer.insertMatch();if(t||e.tabstopManager)return t;e.completer.goTo("down")},Backspace:function(e){e.execCommand("backspace"),!a.getCompletionPrefix(e)&&e.completer&&e.completer.detach()},PageUp:function(e){e.completer.popup.gotoPageUp()},PageDown:function(e){e.completer.popup.gotoPageDown()}},m.startCommand={name:"startAutocomplete",exec:function(e,t){var n=m.for(e);n.autoInsert=!1,n.autoSelect=!0,n.autoShown=!1,n.showPopup(e,t),n.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var g=function(){function e(e){this.initialPosition=e,this.active=!0}return e.prototype.insertByIndex=function(e,t,n){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(e,this.completions.filtered[t],n)},e.prototype.insertMatch=function(e,t,n){if(!t)return!1;if(e.startOperation({command:{name:"insertMatch"}}),t.completer&&t.completer.insertMatch)t.completer.insertMatch(e,t);else{if(!this.completions)return!1;var i=this.completions.filterText.length,o=0;if(t.range&&t.range.start.row===t.range.end.row&&(i-=this.initialPosition.prefix.length,i+=this.initialPosition.pos.column-t.range.start.column,o+=t.range.end.column-this.initialPosition.pos.column),i||o){var r;r=e.selection.getAllRanges?e.selection.getAllRanges():[e.getSelectionRange()];for(var s,a=0;s=r[a];a++)s.start.column-=i,s.end.column+=o,e.session.remove(s)}t.snippet?l.insertSnippet(e,t.snippet):this.$insertString(e,t),t.completer&&t.completer.onInsert&&"function"==typeof t.completer.onInsert&&t.completer.onInsert(e,t),t.command&&"startAutocomplete"===t.command&&e.execCommand(t.command)}return e.endOperation(),!0},e.prototype.$insertString=function(e,t){var n=t.value||t;e.execCommand("insertstring",n)},e.prototype.gatherCompletions=function(e,t){var n=e.getSession(),i=e.getCursorPosition(),o=a.getCompletionPrefix(e),r=[];this.completers=e.completers;var s=e.completers.length;return e.completers.forEach(function(c,p){c.getCompletions(e,n,i,o,function(n,i){c.hideInlinePreview&&(i=i.map(function(e){return Object.assign(e,{hideInlinePreview:c.hideInlinePreview})})),!n&&i&&(r=r.concat(i)),t(null,{prefix:a.getCompletionPrefix(e),matches:r,finished:0===--s})})}),!0},e.prototype.provideCompletions=function(e,t,n){var i=function(e){var i=e.prefix,o=e.matches;this.completions=new v(o),t.exactMatch&&(this.completions.exactMatch=!0),t.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(i),(e.finished||this.completions.filtered.length)&&n(null,this.completions,e.finished)}.bind(this),o=!0,r=null;if(this.gatherCompletions(e,function(e,t){this.active&&(e&&(n(e,[],!0),this.detach()),0===t.prefix.indexOf(t.prefix)&&(o?r=t:i(t)))}.bind(this)),o=!1,r){var s=r;r=null,i(s)}},e.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(e){"function"===typeof e.cancel&&e.cancel()})},e}(),v=function(){function e(e,t){this.all=e,this.filtered=e,this.filterText=t||"",this.exactMatch=!1,this.ignoreCaption=!1}return e.prototype.setFilter=function(e){if(e.length>this.filterText&&0===e.lastIndexOf(this.filterText,0))var t=this.filtered;else t=this.all;this.filterText=e,t=(t=this.filterCompletions(t,this.filterText)).sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var n=null;t=t.filter(function(e){var t=e.snippet||e.caption||e.value;return t!==n&&(n=t,!0)}),this.filtered=t},e.prototype.filterCompletions=function(e,t){var n=[],i=t.toUpperCase(),o=t.toLowerCase();e:for(var r,s=0;r=e[s];s++)if(r.skipFilter)r.$score=r.score,n.push(r);else{var a=!this.ignoreCaption&&r.caption||r.value||r.snippet;if(a){var c,p,l=-1,h=0,u=0;if(this.exactMatch){if(t!==a.substr(0,t.length))continue e}else{var d=a.toLowerCase().indexOf(o);if(d>-1)u=d;else for(var f=0;f<t.length;f++){var m=a.indexOf(o[f],l+1),g=a.indexOf(i[f],l+1);if((c=m>=0&&(g<0||m<g)?m:g)<0)continue e;(p=c-l-1)>0&&(-1===l&&(u+=10),u+=p,h|=1<<f),l=c}}r.matchMask=h,r.exactMatch=u?0:1,r.$score=(r.score||0)-u,n.push(r)}}return n},e}();t.Autocomplete=m,t.CompletionProvider=g,t.FilteredList=v}),ace.define("ace/ext/menu_tools/settings_menu.css",["require","exports","module"],function(e,t,n){n.exports="#ace_settingsmenu, #kbshortcutmenu {\n    background-color: #F7F7F7;\n    color: black;\n    box-shadow: -5px 4px 5px rgba(126, 126, 126, 0.55);\n    padding: 1em 0.5em 2em 1em;\n    overflow: auto;\n    position: absolute;\n    margin: 0;\n    bottom: 0;\n    right: 0;\n    top: 0;\n    z-index: 9991;\n    cursor: default;\n}\n\n.ace_dark #ace_settingsmenu, .ace_dark #kbshortcutmenu {\n    box-shadow: -20px 10px 25px rgba(126, 126, 126, 0.25);\n    background-color: rgba(255, 255, 255, 0.6);\n    color: black;\n}\n\n.ace_optionsMenuEntry:hover {\n    background-color: rgba(100, 100, 100, 0.1);\n    transition: all 0.3s\n}\n\n.ace_closeButton {\n    background: rgba(245, 146, 146, 0.5);\n    border: 1px solid #F48A8A;\n    border-radius: 50%;\n    padding: 7px;\n    position: absolute;\n    right: -8px;\n    top: -8px;\n    z-index: 100000;\n}\n.ace_closeButton{\n    background: rgba(245, 146, 146, 0.9);\n}\n.ace_optionsMenuKey {\n    color: darkslateblue;\n    font-weight: bold;\n}\n.ace_optionsMenuCommand {\n    color: darkcyan;\n    font-weight: normal;\n}\n.ace_optionsMenuEntry input, .ace_optionsMenuEntry button {\n    vertical-align: middle;\n}\n\n.ace_optionsMenuEntry button[ace_selected_button=true] {\n    background: #e7e7e7;\n    box-shadow: 1px 0px 2px 0px #adadad inset;\n    border-color: #adadad;\n}\n.ace_optionsMenuEntry button {\n    background: white;\n    border: 1px solid lightgray;\n    margin: 0px;\n}\n.ace_optionsMenuEntry button:hover{\n    background: #f0f0f0;\n}"}),ace.define("ace/ext/menu_tools/overlay_page",["require","exports","module","ace/ext/menu_tools/overlay_page","ace/lib/dom","ace/ext/menu_tools/settings_menu.css"],function(e,t,n){"use strict";var i=e("../../lib/dom"),o=e("./settings_menu.css");i.importCssString(o,"settings_menu.css",!1),n.exports.overlayPage=function(e,t,n){var i=document.createElement("div"),o=!1;function r(e){27===e.keyCode&&s()}function s(){i&&(document.removeEventListener("keydown",r),i.parentNode.removeChild(i),e&&e.focus(),i=null,n&&n())}return i.style.cssText="margin: 0; padding: 0; position: fixed; top:0; bottom:0; left:0; right:0;z-index: 9990; "+(e?"background-color: rgba(0, 0, 0, 0.3);":""),i.addEventListener("click",function(e){o||s()}),document.addEventListener("keydown",r),t.addEventListener("click",function(e){e.stopPropagation()}),i.appendChild(t),document.body.appendChild(i),e&&e.blur(),{close:s,setIgnoreFocusOut:function(e){o=e,e&&(i.style.pointerEvents="none",t.style.pointerEvents="auto")}}}}),ace.define("ace/ext/modelist",["require","exports","module"],function(e,t,n){"use strict";var i=[];var o=function(){function e(e,t,n){var i;this.name=e,this.caption=t,this.mode="ace/mode/"+e,this.extensions=n,i=/\^/.test(n)?n.replace(/\|(\^)?/g,function(e,t){return"$|"+(t?"^":"^.*\\.")})+"$":"\\.("+n+")$",this.extRe=new RegExp(i,"gi")}return e.prototype.supportsFile=function(e){return e.match(this.extRe)},e}(),r={ABAP:["abap"],ABC:["abc"],ActionScript:["as"],ADA:["ada|adb"],Alda:["alda"],Apache_Conf:["^htaccess|^htgroups|^htpasswd|^conf|htaccess|htgroups|htpasswd"],Apex:["apex|cls|trigger|tgr"],AQL:["aql"],AsciiDoc:["asciidoc|adoc"],ASL:["dsl|asl|asl.json"],Assembly_ARM32:["s"],Assembly_x86:["asm|a"],Astro:["astro"],AutoHotKey:["ahk"],Basic:["bas|bak"],BatchFile:["bat|cmd"],BibTeX:["bib"],C_Cpp:["cpp|c|cc|cxx|h|hh|hpp|ino"],C9Search:["c9search_results"],Cirru:["cirru|cr"],Clojure:["clj|cljs"],Clue:["clue"],Cobol:["CBL|COB"],coffee:["coffee|cf|cson|^Cakefile"],ColdFusion:["cfm|cfc"],Crystal:["cr"],CSharp:["cs"],Csound_Document:["csd"],Csound_Orchestra:["orc"],Csound_Score:["sco"],CSS:["css"],CSV:["csv"],Curly:["curly"],Cuttlefish:["conf"],D:["d|di"],Dart:["dart"],Diff:["diff|patch"],Django:["djt|html.djt|dj.html|djhtml"],Dockerfile:["^Dockerfile"],Dot:["dot"],Drools:["drl"],Edifact:["edi"],Eiffel:["e|ge"],EJS:["ejs"],Elixir:["ex|exs"],Elm:["elm"],Erlang:["erl|hrl"],Flix:["flix"],Forth:["frt|fs|ldr|fth|4th"],Fortran:["f|f90"],FSharp:["fsi|fs|ml|mli|fsx|fsscript"],FSL:["fsl"],FTL:["ftl"],Gcode:["gcode"],Gherkin:["feature"],Gitignore:["^.gitignore"],Glsl:["glsl|frag|vert"],Gobstones:["gbs"],golang:["go"],GraphQLSchema:["gql"],Groovy:["groovy"],HAML:["haml"],Handlebars:["hbs|handlebars|tpl|mustache"],Haskell:["hs"],Haskell_Cabal:["cabal"],haXe:["hx"],Hjson:["hjson"],HTML:["html|htm|xhtml|we|wpy"],HTML_Elixir:["eex|html.eex"],HTML_Ruby:["erb|rhtml|html.erb"],INI:["ini|conf|cfg|prefs"],Io:["io"],Ion:["ion"],Jack:["jack"],Jade:["jade|pug"],Java:["java"],JavaScript:["js|jsm|cjs|mjs"],JEXL:["jexl"],JSON:["json"],JSON5:["json5"],JSONiq:["jq"],JSP:["jsp"],JSSM:["jssm|jssm_state"],JSX:["jsx"],Julia:["jl"],Kotlin:["kt|kts"],LaTeX:["tex|latex|ltx|bib"],Latte:["latte"],LESS:["less"],Liquid:["liquid"],Lisp:["lisp"],LiveScript:["ls"],Log:["log"],LogiQL:["logic|lql"],Logtalk:["lgt"],LSL:["lsl"],Lua:["lua"],LuaPage:["lp"],Lucene:["lucene"],Makefile:["^Makefile|^GNUmakefile|^makefile|^OCamlMakefile|make"],Markdown:["md|markdown"],Mask:["mask"],MATLAB:["matlab"],Maze:["mz"],MediaWiki:["wiki|mediawiki"],MEL:["mel"],MIPS:["s|asm"],MIXAL:["mixal"],MUSHCode:["mc|mush"],MySQL:["mysql"],Nasal:["nas"],Nginx:["nginx|conf"],Nim:["nim"],Nix:["nix"],NSIS:["nsi|nsh"],Nunjucks:["nunjucks|nunjs|nj|njk"],ObjectiveC:["m|mm"],OCaml:["ml|mli"],Odin:["odin"],PartiQL:["partiql|pql"],Pascal:["pas|p"],Perl:["pl|pm"],pgSQL:["pgsql"],PHP:["php|inc|phtml|shtml|php3|php4|php5|phps|phpt|aw|ctp|module"],PHP_Laravel_blade:["blade.php"],Pig:["pig"],PLSQL:["plsql"],Powershell:["ps1"],Praat:["praat|praatscript|psc|proc"],Prisma:["prisma"],Prolog:["plg|prolog"],Properties:["properties"],Protobuf:["proto"],PRQL:["prql"],Puppet:["epp|pp"],Python:["py"],QML:["qml"],R:["r"],Raku:["raku|rakumod|rakutest|p6|pl6|pm6"],Razor:["cshtml|asp"],RDoc:["Rd"],Red:["red|reds"],RHTML:["Rhtml"],Robot:["robot|resource"],RST:["rst"],Ruby:["rb|ru|gemspec|rake|^Guardfile|^Rakefile|^Gemfile"],Rust:["rs"],SaC:["sac"],SASS:["sass"],SCAD:["scad"],Scala:["scala|sbt"],Scheme:["scm|sm|rkt|oak|scheme"],Scrypt:["scrypt"],SCSS:["scss"],SH:["sh|bash|^.bashrc"],SJS:["sjs"],Slim:["slim|skim"],Smarty:["smarty|tpl"],Smithy:["smithy"],snippets:["snippets"],Soy_Template:["soy"],Space:["space"],SPARQL:["rq"],SQL:["sql"],SQLServer:["sqlserver"],Stylus:["styl|stylus"],SVG:["svg"],Swift:["swift"],Tcl:["tcl"],Terraform:["tf","tfvars","terragrunt"],Tex:["tex"],Text:["txt"],Textile:["textile"],Toml:["toml"],TSV:["tsv"],TSX:["tsx"],Turtle:["ttl"],Twig:["twig|swig"],Typescript:["ts|mts|cts|typescript|str"],Vala:["vala"],VBScript:["vbs|vb"],Velocity:["vm"],Verilog:["v|vh|sv|svh"],VHDL:["vhd|vhdl"],Visualforce:["vfp|component|page"],Vue:["vue"],Wollok:["wlk|wpgm|wtest"],XML:["xml|rdf|rss|wsdl|xslt|atom|mathml|mml|xul|xbl|xaml"],XQuery:["xq"],YAML:["yaml|yml"],Zeek:["zeek|bro"],Zig:["zig"]},s={ObjectiveC:"Objective-C",CSharp:"C#",golang:"Go",C_Cpp:"C and C++",Csound_Document:"Csound Document",Csound_Orchestra:"Csound",Csound_Score:"Csound Score",coffee:"CoffeeScript",HTML_Ruby:"HTML (Ruby)",HTML_Elixir:"HTML (Elixir)",FTL:"FreeMarker",PHP_Laravel_blade:"PHP (Blade Template)",Perl6:"Perl 6",AutoHotKey:"AutoHotkey / AutoIt"},a={};for(var c in r){var p=r[c],l=(s[c]||c).replace(/_/g," "),h=c.toLowerCase(),u=new o(h,l,p[0]);a[h]=u,i.push(u)}t.getModeForPath=function(e){for(var t=a.text,n=e.split(/[\/\\]/).pop(),o=0;o<i.length;o++)if(i[o].supportsFile(n)){t=i[o];break}return t},t.modes=i,t.modesByName=a}),ace.define("ace/ext/prompt",["require","exports","module","ace/config","ace/range","ace/lib/dom","ace/autocomplete","ace/autocomplete/popup","ace/autocomplete/popup","ace/undomanager","ace/tokenizer","ace/ext/menu_tools/overlay_page","ace/ext/modelist"],function(e,t,n){"use strict";var i,o=e("../config").nls,r=e("../range").Range,s=e("../lib/dom"),a=e("../autocomplete").FilteredList,c=e("../autocomplete/popup").AcePopup,p=e("../autocomplete/popup").$singleLineEditor,l=e("../undomanager").UndoManager,h=e("../tokenizer").Tokenizer,u=e("./menu_tools/overlay_page").overlayPage,d=e("./modelist");function f(e,t,n,o){if("object"==typeof t)return f(e,"",t,n);if(i){var r=i;if(e=r.editor,r.close(),r.name&&r.name==n.name)return}if(n.$type)return f[n.$type](e,o);var a=p();a.session.setUndoManager(new l);var d=s.buildDom(["div",{class:"ace_prompt_container"+(n.hasDescription?" input-box-with-description":"")}]),m=u(e,d,w);if(d.appendChild(a.container),e&&(e.cmdLine=a,a.setOption("fontSize",e.getOption("fontSize"))),t&&a.setValue(t,1),n.selection&&a.selection.setRange({start:a.session.doc.indexToPosition(n.selection[0]),end:a.session.doc.indexToPosition(n.selection[1])}),n.getCompletions){var g=new c;g.renderer.setStyle("ace_autocomplete_inline"),g.container.style.display="block",g.container.style.maxWidth="600px",g.container.style.width="100%",g.container.style.marginTop="3px",g.renderer.setScrollMargin(2,2,0,0),g.autoSelect=!1,g.renderer.$maxLines=15,g.setRow(-1),g.on("click",function(e){var t=g.getData(g.getRow());t.error||(a.setValue(t.value||t.name||t),x(),e.stop())}),d.appendChild(g.container),S()}if(n.$rules){var v=new h(n.$rules);a.session.bgTokenizer.setTokenizer(v)}if(n.placeholder&&a.setOption("placeholder",n.placeholder),n.hasDescription){var b=s.buildDom(["div",{class:"ace_prompt_text_container"}]);s.buildDom(n.prompt||"Press 'Enter' to confirm or 'Escape' to cancel",b),d.appendChild(b)}function x(){var e;e=g&&g.getCursorPosition().row>0?C():a.getValue();var t=g?g.getData(g.getRow()):e;t&&!t.error&&(w(),n.onAccept&&n.onAccept({value:e,item:t},a))}m.setIgnoreFocusOut(n.ignoreFocusOut);var y={Enter:x,"Esc|Shift-Esc":function(){n.onCancel&&n.onCancel(a.getValue(),a),w()}};function w(){m.close(),o&&o(),i=null}function S(){if(n.getCompletions){var e;n.getPrefix&&(e=n.getPrefix(a));var t=n.getCompletions(a);g.setData(t,e),g.resize(!0)}}function C(){var e=g.getData(g.getRow());if(e&&!e.error)return e.value||e.caption||e}g&&Object.assign(y,{Up:function(e){g.goTo("up"),C()},Down:function(e){g.goTo("down"),C()},"Ctrl-Up|Ctrl-Home":function(e){g.goTo("start"),C()},"Ctrl-Down|Ctrl-End":function(e){g.goTo("end"),C()},Tab:function(e){g.goTo("down"),C()},PageUp:function(e){g.gotoPageUp(),C()},PageDown:function(e){g.gotoPageDown(),C()}}),a.commands.bindKeys(y),a.on("input",function(){n.onInput&&n.onInput(),S()}),a.resize(!0),g&&g.resize(!0),a.focus(),i={close:w,name:n.name,editor:e}}f.gotoLine=function(e,t){var n;f(e,":"+(n=e.selection.toJSON(),Array.isArray(n)||(n=[n]),n.map(function(e){var t=e.isBackwards?e.start:e.end,n=e.isBackwards?e.end:e.start,i=n.row+1+":"+n.column;return n.row==t.row?n.column!=t.column&&(i+=">:"+t.column):i+=">"+(t.row+1)+":"+t.column,i}).reverse().join(", ")),{name:"gotoLine",selection:[1,Number.MAX_VALUE],onAccept:function(t){var n=t.value,i=f.gotoLine._history;i||(f.gotoLine._history=i=[]),-1!=i.indexOf(n)&&i.splice(i.indexOf(n),1),i.unshift(n),i.length>20&&(i.length=20);var o=e.getCursorPosition(),s=[];n.replace(/^:/,"").split(/,/).map(function(t){var n=t.split(/([<>:+-]|c?\d+)|[^c\d<>:+-]+/).filter(Boolean),i=0;function a(){var t=n[i++];if(t){if("c"==t[0]){var r=parseInt(t.slice(1))||0;return e.session.doc.indexToPosition(r)}var s=o.row,a=0;return/\d/.test(t)&&(s=parseInt(t)-1,t=n[i++]),":"==t&&(t=n[i++],/\d/.test(t)&&(a=parseInt(t)||0)),{row:s,column:a}}}o=a();var c=r.fromPoints(o,o);">"==n[i]?(i++,c.end=a()):"<"==n[i]&&(i++,c.start=a()),s.unshift(c)}),e.selection.fromJSON(s);var a=e.renderer.scrollTop;e.renderer.scrollSelectionIntoView(e.selection.anchor,e.selection.cursor,.5),e.renderer.animateScrolling(a)},history:function(){return f.gotoLine._history?f.gotoLine._history:[]},getCompletions:function(t){var n=t.getValue(),i=n.replace(/^:/,"").split(":"),o=Math.min(parseInt(i[0])||1,e.session.getLength())-1;return[n+"  "+e.session.getLine(o)].concat(this.history())},$rules:{start:[{regex:/\d+/,token:"string"},{regex:/[:,><+\-c]/,token:"keyword"}]}})},f.commands=function(e,t){function n(e){return(e||"").replace(/^./,function(e){return e.toUpperCase(e)}).replace(/[a-z][A-Z]/g,function(e){return e[0]+" "+e[1].toLowerCase(e)})}var i=function(t){var i=[],o={};return e.keyBinding.$handlers.forEach(function(e){var r=e.platform,s=e.byName;for(var a in s){var c=s[a].bindKey;"string"!==typeof c&&(c=c&&c[r]||"");var p=s[a],l=p.description||n(p.name);Array.isArray(p)||(p=[p]),p.forEach(function(e){"string"!=typeof e&&(e=e.name),t.find(function(t){return t===e})||(o[e]?o[e].key+="|"+c:(o[e]={key:c,command:e,description:l},i.push(o[e])))})}}),i}(["insertstring","inserttext","setIndentation","paste"]);i=i.map(function(e){return{value:e.description,meta:e.key,command:e.command}}),f(e,"",{name:"commands",selection:[0,Number.MAX_VALUE],maxHistoryCount:5,onAccept:function(t){if(t.item){var n=t.item.command;this.addToHistory(t.item),e.execCommand(n)}},addToHistory:function(e){var t=this.history();t.unshift(e),delete e.message;for(var n=1;n<t.length;n++)if(t[n].command==e.command){t.splice(n,1);break}this.maxHistoryCount>0&&t.length>this.maxHistoryCount&&t.splice(t.length-1,1),f.commands.history=t},history:function(){return f.commands.history||[]},getPrefix:function(e){var t=e.getCursorPosition();return e.getValue().substring(0,t.column)},getCompletions:function(e){function t(e,t){var n=JSON.parse(JSON.stringify(e));return new a(n).filterCompletions(n,t)}var n=this.getPrefix(e),r=t(this.history(),n),s=function(e,t){if(!t||!t.length)return e;var n=[];t.forEach(function(e){n.push(e.command)});var i=[];return e.forEach(function(e){-1===n.indexOf(e.command)&&i.push(e)}),i}(i,r);s=t(s,n),r.length&&s.length&&(r[0].message=o("prompt.recently-used","Recently used"),s[0].message=o("prompt.other-commands","Other commands"));var c=r.concat(s);return c.length>0?c:[{value:o("prompt.no-matching-commands","No matching commands"),error:1}]}})},f.modes=function(e,t){var n=d.modes;n=n.map(function(e){return{value:e.caption,mode:e.name}}),f(e,"",{name:"modes",selection:[0,Number.MAX_VALUE],onAccept:function(t){if(t.item){var n="ace/mode/"+t.item.mode;e.session.setMode(n)}},getPrefix:function(e){var t=e.getCursorPosition();return e.getValue().substring(0,t.column)},getCompletions:function(e){var t=this.getPrefix(e),i=function(e,t){var n=JSON.parse(JSON.stringify(e));return new a(n).filterCompletions(n,t)}(n,t);return i.length>0?i:[{caption:"No mode matching",value:"No mode matching",error:1}]}})},s.importCssString(".ace_prompt_container {\n    max-width: 603px;\n    width: 100%;\n    margin: 20px auto;\n    padding: 3px;\n    background: white;\n    border-radius: 2px;\n    box-shadow: 0px 2px 3px 0px #555;\n}","promtp.css",!1),t.prompt=f}),ace.require(["ace/ext/prompt"],function(e){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=e)});