SELECT DISTINCT T.NUMERO,
                T.LOCAL,
                T.LOTE,
                T.TIPO,
                T.ANO,
                T.SEQUENCIA,
                COALESCE(T.DATA, CURRENT_DATE) AS DATATRAMITACAO,
                P.DATAPROCESSO,
                L.DESCRICAO,
                S.NOME,
                I.DESCRICAO DESCSITUACAO,
                U.DESCRICAO ASSUNTO,
                P.ASSUNTO COMPLEMENTOASSUNTO,
                T.FUNCAO,
                P.STATUS,
                P.SITUACAO,
                P.LOCALDESTINO,

                (SELECT DESCRICAO
                   FROM SITUACOES
                  WHERE CODIGO = P.SITUACAO) DESCR_SIT,

                (SELECT T2.LOCAL
                   FROM TRAMITACAO T2
                  WHERE P.TIPO = T2.TIPO
                    AND P.ANO = T2.ANO
                    AND P.NUMERO = T2.NUMERO
                    AND P.ENTIDADE = T2.ENTIDADE
                    AND T2.FUNCAO <> 'E'
                    AND T2.SEQUENCIA = (T.SEQUENCIA - 1)) LOCAL_BASE,

                (SELECT L2.DESCRICAO
                   FROM TRAMITACAO T2, LOCAIS L2
                  WHERE P.TIPO = T2.TIPO
                    AND P.ANO = T2.ANO
                    AND P.NUMERO = T2.NUMERO
                    AND P.ENTIDADE = T2.ENTIDADE
                    AND T2.FUNCAO <> 'E'
                    AND T2.SEQUENCIA = (T.SEQUENCIA - 1)
                    AND T2.LOCAL = L2.CODIGO
                    AND T2.ENTIDADE = L2.ENTIDADE) LOCAL_DESCBASE,

                (SELECT L3.DESCRICAO
                   FROM LOCAIS L3
                  WHERE L3.ENTIDADE = P.ENTIDADE
                    AND L3.CODIGO = P.LOCALDESTINO) LOCAL_ATUAL,
                S.CODPESSOA,
                S.NOME AS NOMEPESSOA,
                S.CNPJ_CPF AS CNPJCPFPESSOA
  FROM TRAMITACAO T,
       PROCESSOS  P,
       LOCAIS     L,
       PESSOA     S,
       SITUACOES  I,
       ASSUNTO    U
 WHERE T.FUNCAO = 'E'
   AND T.TIPO = P.TIPO
   AND T.ANO = P.ANO
   AND T.NUMERO = P.NUMERO
   AND T.ENTIDADE = P.ENTIDADE
   AND T.LOCAL = L.CODIGO
   AND T.ENTIDAde = L.ENTIDADE
   AND S.CODPESSOA = P.CODPESSOA
   AND P.SITUACAO = I.CODIGO
   AND P.CODASSUNTO = U.CODIGO
   AND P.ENTIDADE = :entidade
   AND (T.ANO >= :anoini OR :anoini = -99)
   AND (T.ANO <= :anofim OR :anofim = -99)
   AND (T.TIPO >= :tipo OR :tipo = -99)
   AND (T.NUMERO >= :numeroini OR :numeroini = -99)
   AND (T.NUMERO <= :numerofim OR :numerofim = -99)   
   AND (P.DATAPROCESSO >= :dataprocini OR :dataprocini = :dataprocinidefault)
   AND (P.DATAPROCESSO <= :dataprocfim OR :dataprocfim = :dataprocfimdefault)
   AND (P.CODPESSOA >= :pessoa OR :pessoa = -99)
   AND (P.SITUACAO = :situacao OR :situacao = -99)
   AND (P.CODASSUNTO = :assunto OR :assunto = -99)
   AND (P.LOCALDESTINO >= :localdestinoini OR :localdestinoini = -99)
   AND (P.LOCALDESTINO <= :localdestinofim OR :localdestinofim = -99)
   AND (T.DATA >= :datatramiteini OR :datatramiteini = :datatramiteinidefault)
   AND (T.DATA <= :datatramitefim OR :datatramitefim = :datatramitefimdefault)
   AND (T.LOTE = :lote OR :lote = -99)
   AND (upper(T.PARECER) like upper(:parecer) OR :parecer = '(TODOS)')
