SELECT * FROM (
SELECT DISTINCT  P.ENTIDADE,
                 T.NUMERO,
                 T.TIPO,
                 T.ANO,
                 T.SEQUENCIA,
                 CAST(T.DATA AS DATE) AS DATA,
                 CAST(P.DATAPROCESSO AS DATE) AS DATAPROCESSO,
                 U.DESCRICAO ASSUNTO,
				 P.CODASSUNTO,
                 P.ASSUNTO COMPLEMENTOASSUNTO,
                 T.FUNCAO,
                 CASE T.FUNCAO
                     WHEN 'A' THEN 'Arquivado'
                     WHEN 'R' THEN 'Recebido'
                     WHEN 'C' THEN 'Aberto'
                     WHEN 'E' THEN 'Encaminhado'
                 END AS STATUS,
                 P.SITUACAO,
                 P.LOCALDESTINO,

                 (SELECT DESCRICAO
                    FROM SITUACOES
                   WHERE CODIGO = P.SITUACAO) DESCR_SIT,

                (SELECT T2.LOCAL
                   FROM TRAMITACAO T2
                  WHERE P.TIPO = T2.TIPO
                    AND P.ANO = T2.ANO
                    AND P.NUMERO = T2.NUMERO
                    AND P.ENTIDADE = T2.ENTIDADE
                    AND T2.FUNCAO = 'C'
                    AND T2.SEQUENCIA = 1) LOCAL_ABERTURA,

                (SELECT L2.DESCRICAO
                   FROM TRAMITACAO T2, LOCAIS L2
                  WHERE P.TIPO = T2.TIPO
                    AND P.ANO = T2.ANO
                    AND P.NUMERO = T2.NUMERO
                    AND P.ENTIDADE = T2.ENTIDADE
                    AND T2.FUNCAO = 'C'
                    AND T2.SEQUENCIA = 1
                    AND T2.LOCAL = L2.CODIGO
                    AND T2.ENTIDADE = L2.ENTIDADE) LOCAL_DESCABERTURA,

                COALESCE((SELECT T2.LOCAL
                            FROM TRAMITACAO T2
                           WHERE P.TIPO = T2.TIPO
                             AND P.ANO = T2.ANO
                             AND P.NUMERO = T2.NUMERO
                             AND P.ENTIDADE = T2.ENTIDADE
                             AND T2.FUNCAO <> 'E'
                             AND T2.SEQUENCIA = (T.SEQUENCIA - 1)), (SELECT L3.codigo
                                                                       FROM LOCAIS L3
                                                                      WHERE L3.ENTIDADE = P.ENTIDADE
                                                                        AND L3.CODIGO = P.LOCALORIGEM)) LOCAL_BASE,

                (SELECT L2.DESCRICAO
                            FROM TRAMITACAO T2, LOCAIS L2
                           WHERE P.TIPO = T2.TIPO
                             AND P.ANO = T2.ANO
                             AND P.NUMERO = T2.NUMERO
                             AND P.ENTIDADE = T2.ENTIDADE
                             AND T2.FUNCAO <> 'E'
                             AND T2.SEQUENCIA = (T.SEQUENCIA - 1)
                             AND T2.LOCAL = L2.CODIGO
                             AND T2.ENTIDADE = L2.ENTIDADE) LOCAL_DESCBASE,

                (SELECT T2.LOCAL
                            FROM TRAMITACAO T2, LOCAIS L2
                           WHERE P.TIPO = T2.TIPO
                             AND P.ANO = T2.ANO
                             AND P.NUMERO = T2.NUMERO
                             AND P.ENTIDADE = T2.ENTIDADE
                             AND T2.FUNCAO <> 'E'
                             AND T2.SEQUENCIA = T.SEQUENCIA
                             AND T2.LOCAL = L2.CODIGO
                             AND T2.ENTIDADE = L2.ENTIDADE) CODLOCAL_ATUAL,

                (SELECT L2.DESCRICAO
                            FROM TRAMITACAO T2, LOCAIS L2
                           WHERE P.TIPO = T2.TIPO
                             AND P.ANO = T2.ANO
                             AND P.NUMERO = T2.NUMERO
                             AND P.ENTIDADE = T2.ENTIDADE
                             AND T2.FUNCAO <> 'E'
                             AND T2.SEQUENCIA = T.SEQUENCIA
                             AND T2.LOCAL = L2.CODIGO
                             AND T2.ENTIDADE = L2.ENTIDADE) LOCAL_ATUAL
  FROM TRAMITACAO T
 INNER JOIN PROCESSOS P
    ON T.TIPO = P.TIPO
   AND T.ANO = P.ANO
   AND T.NUMERO = P.NUMERO
   AND T.ENTIDADE = P.ENTIDADE
 INNER JOIN LOCAIS L
    ON T.LOCAL = L.CODIGO
   AND T.ENTIDADE = L.ENTIDADE
 INNER JOIN ASSUNTO U
    ON P.CODASSUNTO = U.CODIGO
) P WHERE 1 = 1
