select distinct
   P.DIGITACAO,
   T.PARECER,
   TP.DESCRICAO as TIPOPROTOCOLO,
	P.NUMERO,
	P.DATAORIGEM,
	P.TIPO,
	P.ANO,
	PS.NOME as REQUERENTE,
	ASU.DESCRICAO as ASSUNTO,
	P.ASSUNTO as COMPLEMENTOASSUNTO,
	P.CODASSUNTO,
	P.SENHAINTERNET,
	P.OUTROSDADOS as OBSERVACAO,
	P.MOTIVOEDICAO,
	P.CADASTRO,
	P.PROCESSO_REFERENCIA,
	P.MOTIVOEXIGENCIA,
	case
		when P.EXIGENCIA = 'N' then 'Não'
		when P.EXIGENCIA = 'S' then 'Sim'
	end as EXIGENCIA,
	S.DESCRICAO as SITUACAO,
	case
		when T.FUNCAO = 'R' then 'Recebido'
		when T.FUNCAO = 'A' then 'Arquivado'
		when T.FUNCAO = 'C' then 'Aberto'
		when T.FUNCAO = 'E' then 'Encaminhado'
	end as STATUS,
	T.funcao,
	L.CODIGO,
	L.DESCRICAO as local,
	T.DATA,
	T.HORA,
	U.LOGIN1,
	U.NOME NOMEUSUARIO,
	T.CODCAIXA,
	T.APEDIDODE,
	C.DESCRICAO as DESCRCAIXA,
	T.SEQUENCIA
from
	PROCESSOS P
inner join TIPOSPROTOCOLO TP on
	P.TIPO = TP.CODIGO
inner join PESSOA PS on
	P.CODPESSOA = PS.CODPESSOA
inner join ASSUNTO ASU on
	P.CODASSUNTO = ASU.CODIGO
inner join TRAMITACAO T on
	P.numero = T.NUMERO
	and P.TIPO = T.TIPO
	and P.ANO = T.ANO
	and P.ENTIDADE = T.ENTIDADE
inner join SITUACOES S on
	T.SITUACAO = S.CODIGO
inner join LOCAIS L on
	T.LOCAL = L.CODIGO
	and T.ENTIDADE = L.ENTIDADE
left join USUARIO U on
	T.USUARIOREG = U.LOGIN1
left join CAIXA C on
	T.CODCAIXA = C.CODIGO
	and T.ANOCAIXA = C.ANO
where
	P.TIPO = ?
	and P.ANO = ?
	and P.NUMERO = ?
	and P.ENTIDADE = ?
order by
	T.SEQUENCIA desc
