SELECT 'Pendente' as descricao, COUNT(P.NUMERO) as quantidade
  FROM PROCESSOS P
 INNER JOIN ASSUNTO A
    ON P.CODASSUNTO = A.CODIGO
 WHERE p.STATUS = 'E'
   AND A.OUVIDORIA = 'S'
   AND P.ENTIDADE = :ENTIDADE
   AND (SELECT COUNT(*) FROM TRAMITACAO T 
    WHERE P.ANO = T.ANO 
        AND P.ENTIDADE = T.ENTIDADE
        AND P.NUMERO = T.NUMERO
        AND P.ANO = T.ANO) = 2

UNION

SELECT 'Finalizado' as descricao, COUNT(P.NUMERO) as quantidade
  FROM PROCESSOS  P
 INNER JOIN ASSUNTO A
    ON P.CODASSUNTO = A.CODIGO
 WHERE P.STATUS = 'A' -- ARQUIVADO
   AND A.OUVIDORIA = 'S'
   AND P.ENTIDADE = :ENTIDADE
   AND P.SITUACAO NOT IN (SELECT CAST(COALESCE(VALOR,NULL) AS NUMERIC)
                            FROM PARAMETROS
                           WHERE CODIGO = 91
                             AND EXERCICIO = 2019)

UNION

SELECT 'Indeferido' as descricao, COUNT(P.NUMERO) as quantidade
  FROM PROCESSOS  P
 INNER JOIN ASSUNTO A
    ON P.CODASSUNTO = A.CODIGO
 WHERE P.STATUS = 'A' -- ARQUIVADO
   AND A.OUVIDORIA = 'S'
   AND P.ENTIDADE = :ENTIDADE
   AND P.SITUACAO IN (SELECT CAST(COALESCE(VALOR,NULL) AS NUMERIC)
                        FROM PARAMETROS
                       WHERE CODIGO = 91
                         AND EXERCICIO = 2019)

UNION

SELECT 'Andamento' as descricao, COUNT(P.NUMERO) as quantidade
  FROM PROCESSOS  P
 INNER JOIN ASSUNTO A
    ON P.CODASSUNTO = A.CODIGO
 WHERE A.OUVIDORIA = 'S'
   AND P.ENTIDADE = :ENTIDADE
   AND P.STATUS IN ('E', 'R')
   AND EXISTS ( SELECT T1.ENTIDADE, T1.ANO, T1.TIPO, T1.NUMERO
                  FROM TRAMITACAO T1
                 WHERE P.ENTIDADE  = T1.ENTIDADE
                   AND P.NUMERO    = T1.NUMERO
                   AND P.TIPO      = T1.TIPO
                   AND P.ANO       = T1.ANO
                 GROUP BY T1.ENTIDADE, T1.NUMERO, T1.TIPO, T1.ANO
                 HAVING COUNT(T1.ENTIDADE) > 2)

